/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.NullnessCasts;
import com.google.common.base.Objects;
import com.google.common.base.ParametricNullness;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Suppliers {
    private Suppliers() {
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Supplier<T> compose(Function<? super F, T> function, Supplier<F> supplier) {
        void var1_1;
        Function<? super F, T> function2;
        return new SupplierComposition<F, T>(function2, var1_1);
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        Supplier<T> supplier;
        if (delegate instanceof NonSerializableMemoizingSupplier || delegate instanceof MemoizingSupplier) {
            return delegate;
        }
        if (delegate instanceof Serializable) {
            return new MemoizingSupplier<T>(delegate);
        }
        return new NonSerializableMemoizingSupplier<T>(supplier);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, long duration, TimeUnit unit) {
        void var3_2;
        void var1_1;
        Supplier<T> supplier;
        return new ExpiringMemoizingSupplier<T>(supplier, (long)var1_1, (TimeUnit)var3_2);
    }

    public static <T> Supplier<T> ofInstance(@ParametricNullness T instance) {
        T t;
        return new SupplierOfInstance<T>(t);
    }

    public static <T> Supplier<T> synchronizedSupplier(Supplier<T> delegate) {
        Supplier<T> supplier;
        return new ThreadSafeSupplier<T>(supplier);
    }

    public static <T> Function<Supplier<T>, T> supplierFunction() {
        SupplierFunctionImpl supplierFunctionImpl = SupplierFunctionImpl.INSTANCE;
        return supplierFunctionImpl;
    }

    private static enum SupplierFunctionImpl implements SupplierFunction<Object>
    {
        INSTANCE;


        @Override
        public final Object apply(Supplier<Object> input) {
            return input.get();
        }

        public final String toString() {
            return "Suppliers.supplierFunction()";
        }
    }

    private static interface SupplierFunction<T>
    extends Function<Supplier<T>, T> {
    }

    private static class ThreadSafeSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ThreadSafeSupplier(Supplier<T> delegate) {
            void var1_1;
            this.delegate = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        @Override
        @ParametricNullness
        public T get() {
            Supplier<T> supplier = this.delegate;
            synchronized (supplier) {
                return this.delegate.get();
            }
        }

        public String toString() {
            String string = String.valueOf(this.delegate);
            return new StringBuilder(32 + String.valueOf(string).length()).append("Suppliers.synchronizedSupplier(").append(string).append(")").toString();
        }
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        @ParametricNullness
        final T instance;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SupplierOfInstance(@ParametricNullness T instance) {
            void var1_1;
            this.instance = var1_1;
        }

        @Override
        @ParametricNullness
        public T get() {
            return this.instance;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (obj instanceof SupplierOfInstance) {
                void var1_1;
                SupplierOfInstance that = (SupplierOfInstance)obj;
                return Objects.equal(this.instance, var1_1.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            String string = String.valueOf(this.instance);
            return new StringBuilder(22 + String.valueOf(string).length()).append("Suppliers.ofInstance(").append(string).append(")").toString();
        }
    }

    @VisibleForTesting
    static class ExpiringMemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        final long durationNanos;
        volatile transient T value;
        volatile transient long expirationNanos;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ExpiringMemoizingSupplier(Supplier<T> delegate, long duration, TimeUnit unit) {
            void var2_2;
            void var1_1;
            this.delegate = (Supplier)Preconditions.checkNotNull(var1_1);
            this.durationNanos = unit.toNanos(duration);
            Preconditions.checkArgument(duration > 0L, "duration (%s %s) must be > 0", (long)var2_2, (Object)unit);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T get() {
            long nanos = this.expirationNanos;
            long now = Platform.systemNanoTime();
            if (nanos == 0L || now - nanos >= 0L) {
                ExpiringMemoizingSupplier expiringMemoizingSupplier = this;
                synchronized (expiringMemoizingSupplier) {
                    if (nanos == this.expirationNanos) {
                        void var1_1;
                        void var3_3;
                        T t = this.delegate.get();
                        this.value = t;
                        nanos = var3_3 + this.durationNanos;
                        this.expirationNanos = nanos == 0L ? 1L : var1_1;
                        return t;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            String string = String.valueOf(this.delegate);
            long l = this.durationNanos;
            return new StringBuilder(62 + String.valueOf(string).length()).append("Suppliers.memoizeWithExpiration(").append(string).append(", ").append(l).append(", NANOS)").toString();
        }
    }

    @VisibleForTesting
    static class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        volatile Supplier<T> delegate;
        volatile boolean initialized;
        T value;

        /*
         * WARNING - void declaration
         */
        NonSerializableMemoizingSupplier(Supplier<T> delegate) {
            void var1_1;
            this.delegate = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T get() {
            if (!this.initialized) {
                NonSerializableMemoizingSupplier nonSerializableMemoizingSupplier = this;
                synchronized (nonSerializableMemoizingSupplier) {
                    if (!this.initialized) {
                        void var2_2;
                        T t = java.util.Objects.requireNonNull(this.delegate).get();
                        this.value = t;
                        this.initialized = true;
                        this.delegate = null;
                        return var2_2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            String string;
            String string2;
            Supplier<T> delegate = this.delegate;
            if (delegate == null) {
                delegate = String.valueOf(this.value);
                string2 = new StringBuilder(25 + String.valueOf(delegate).length()).append("<supplier that returned ").append((String)((Object)delegate)).append(">").toString();
            } else {
                string2 = string;
            }
            string = String.valueOf(string2);
            return new StringBuilder(19 + String.valueOf(string).length()).append("Suppliers.memoize(").append(string).append(")").toString();
        }
    }

    @VisibleForTesting
    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        MemoizingSupplier(Supplier<T> delegate) {
            void var1_1;
            this.delegate = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        void var2_2;
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return var2_2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            Object object;
            String string;
            if (this.initialized) {
                string = String.valueOf(this.value);
                object = new StringBuilder(25 + String.valueOf(string).length()).append("<supplier that returned ").append(string).append(">").toString();
            } else {
                object = this.delegate;
            }
            string = String.valueOf(object);
            return new StringBuilder(19 + String.valueOf(string).length()).append("Suppliers.memoize(").append(string).append(")").toString();
        }
    }

    private static class SupplierComposition<F, T>
    implements Supplier<T>,
    Serializable {
        final Function<? super F, T> function;
        final Supplier<F> supplier;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SupplierComposition(Function<? super F, T> function, Supplier<F> supplier) {
            void var2_2;
            void var1_1;
            this.function = (Function)Preconditions.checkNotNull(var1_1);
            this.supplier = (Supplier)Preconditions.checkNotNull(var2_2);
        }

        @Override
        @ParametricNullness
        public T get() {
            return this.function.apply(this.supplier.get());
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (obj instanceof SupplierComposition) {
                void var1_1;
                SupplierComposition that = (SupplierComposition)obj;
                return this.function.equals(that.function) && this.supplier.equals(var1_1.supplier);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.function, this.supplier);
        }

        public String toString() {
            String string = String.valueOf(this.function);
            String string2 = String.valueOf(this.supplier);
            return new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Suppliers.compose(").append(string).append(", ").append(string2).append(")").toString();
        }
    }
}

