/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(String string) {
        return Platform.nullToEmpty(string);
    }

    public static String emptyToNull(String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String padStart(String string, int minLength, char padChar) {
        void var3_3;
        String string2;
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string2);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String padEnd(String string, int minLength, char padChar) {
        void var3_4;
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(String string, int count) {
        void var3_5;
        void var0_1;
        void var1_2;
        void n;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            if (count == 0) {
                return "";
            }
            return string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = var2_3; n < size - n; n <<= 1) {
            void v0 = n;
            System.arraycopy(array, 0, array, (int)v0, (int)v0);
        }
        System.arraycopy(array, 0, array, (int)n, (int)(var1_2 - var0_1));
        return new String((char[])var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public static String commonPrefix(CharSequence a, CharSequence b) {
        void var3_3;
        CharSequence charSequence;
        void var1_1;
        int p;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a, p - 1) || Strings.validSurrogatePairAt((CharSequence)var1_1, p - 1)) {
            --p;
        }
        return charSequence.subSequence(0, (int)var3_3).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String commonSuffix(CharSequence a, CharSequence b) {
        CharSequence charSequence;
        void var3_3;
        block4: {
            int s;
            block3: {
                void var1_1;
                Preconditions.checkNotNull(a);
                Preconditions.checkNotNull(b);
                int maxSuffixLength = Math.min(a.length(), b.length());
                for (s = 0; s < maxSuffixLength; ++s) {
                    CharSequence charSequence2 = a;
                    CharSequence charSequence3 = b;
                    if (charSequence2.charAt(charSequence2.length() - s - 1) != charSequence3.charAt(charSequence3.length() - s - 1)) break;
                }
                CharSequence charSequence4 = a;
                if (Strings.validSurrogatePairAt(charSequence4, charSequence4.length() - s - 1)) break block3;
                void v3 = var1_1;
                if (!Strings.validSurrogatePairAt((CharSequence)v3, v3.length() - s - 1)) break block4;
            }
            --s;
        }
        CharSequence charSequence5 = a;
        return charSequence5.subSequence(charSequence5.length() - var3_3, charSequence.length()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        void var1_1;
        CharSequence charSequence;
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(charSequence.charAt((int)(var1_1 + true)));
    }

    /*
     * WARNING - void declaration
     */
    public static String lenientFormat(String template, Object ... args) {
        void var2_3;
        String string;
        void var3_4;
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Strings.lenientToString(args[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, (int)var3_4, string.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String lenientToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            Object object;
            void var1_1;
            String string = o.getClass().getName();
            o = Integer.toHexString(System.identityHashCode(o));
            Object objectToString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(o).length()).append(string).append('@').append((String)o).toString();
            String string2 = String.valueOf(objectToString);
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, string2.length() != 0 ? "Exception during lenientFormat for ".concat(string2) : new String("Exception during lenientFormat for "), e);
            string = var1_1.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string).length()).append("<").append((String)object).append(" threw ").append(string).append(">").toString();
        }
    }
}

