/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.AbstractIterator;
import com.google.common.base.CharMatcher;
import com.google.common.base.CommonMatcher;
import com.google.common.base.CommonPattern;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.JdkPattern;
import com.google.common.base.Joiner;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    /*
     * WARNING - void declaration
     */
    private Splitter(Strategy strategy) {
        this((Strategy)var1_1, false, CharMatcher.none(), Integer.MAX_VALUE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.strategy = var1_1;
        this.omitEmptyStrings = var2_2;
        this.trimmer = var3_3;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        return Splitter.on(CharMatcher.is(separator));
    }

    public static Splitter on(CharMatcher separatorMatcher) {
        CharMatcher charMatcher;
        Preconditions.checkNotNull(separatorMatcher);
        return new Splitter(new Strategy(){

            /*
             * WARNING - void declaration
             */
            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                void var2_2;
                void var1_1;
                return new SplittingIterator(this, (Splitter)var1_1, (CharSequence)var2_2){
                    final /* synthetic */ 1 this$0;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((Splitter)var2_2, (CharSequence)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    int separatorStart(int start) {
                        void var1_1;
                        return this.this$0.charMatcher.indexIn(this.toSplit, (int)var1_1);
                    }

                    @Override
                    int separatorEnd(int separatorPosition) {
                        return separatorPosition + 1;
                    }
                };
            }
        });
    }

    public static Splitter on(String separator) {
        String string;
        Preconditions.checkArgument(separator.length() != 0, "The separator may not be the empty string.");
        if (separator.length() == 1) {
            return Splitter.on(separator.charAt(0));
        }
        return new Splitter(new Strategy(){

            /*
             * WARNING - void declaration
             */
            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                void var2_2;
                void var1_1;
                return new SplittingIterator(this, (Splitter)var1_1, (CharSequence)var2_2){
                    final /* synthetic */ 2 this$0;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((Splitter)var2_2, (CharSequence)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int separatorStart(int start) {
                        void p;
                        int separatorLength = this.this$0.string.length();
                        int last = this.toSplit.length() - separatorLength;
                        while (p <= last) {
                            block3: {
                                for (int i = 0; i < separatorLength; ++i) {
                                    if (this.toSplit.charAt(i + p) == this.this$0.string.charAt(i)) {
                                        continue;
                                    }
                                    break block3;
                                }
                                return (int)p;
                            }
                            ++p;
                        }
                        return -1;
                    }

                    @Override
                    public int separatorEnd(int separatorPosition) {
                        return separatorPosition + this.this$0.string.length();
                    }
                };
            }
        });
    }

    @GwtIncompatible
    public static Splitter on(Pattern separatorPattern) {
        Pattern pattern;
        return Splitter.on(new JdkPattern(pattern));
    }

    private static Splitter on(CommonPattern separatorPattern) {
        CommonPattern commonPattern;
        Preconditions.checkArgument(!separatorPattern.matcher("").matches(), "The pattern may not match the empty string: %s", (Object)separatorPattern);
        return new Splitter(new Strategy(){

            /*
             * WARNING - void declaration
             */
            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                void var3_3;
                void var2_2;
                void var1_1;
                CommonMatcher matcher = commonPattern.matcher(toSplit);
                return new SplittingIterator(this, (Splitter)var1_1, (CharSequence)var2_2, (CommonMatcher)var3_3){
                    final /* synthetic */ CommonMatcher val$matcher;
                    {
                        void var3_3;
                        void var2_2;
                        this.val$matcher = commonMatcher;
                        super((Splitter)var2_2, (CharSequence)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int separatorStart(int start) {
                        void var1_1;
                        if (this.val$matcher.find((int)var1_1)) {
                            return this.val$matcher.start();
                        }
                        return -1;
                    }

                    @Override
                    public int separatorEnd(int separatorPosition) {
                        return this.val$matcher.end();
                    }
                };
            }
        });
    }

    @GwtIncompatible
    public static Splitter onPattern(String separatorPattern) {
        return Splitter.on(Platform.compilePattern(separatorPattern));
    }

    public static Splitter fixedLength(int length) {
        int n;
        Preconditions.checkArgument(length > 0, "The length may not be less than 1");
        return new Splitter(new Strategy(){

            /*
             * WARNING - void declaration
             */
            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                void var2_2;
                void var1_1;
                return new SplittingIterator(this, (Splitter)var1_1, (CharSequence)var2_2){
                    final /* synthetic */ 4 this$0;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((Splitter)var2_2, (CharSequence)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int separatorStart(int start) {
                        int nextChunkStart = start + this.this$0.n;
                        if (nextChunkStart < this.toSplit.length()) {
                            void var1_1;
                            return (int)var1_1;
                        }
                        return -1;
                    }

                    @Override
                    public int separatorEnd(int separatorPosition) {
                        return separatorPosition;
                    }
                };
            }
        });
    }

    public final Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    /*
     * WARNING - void declaration
     */
    public final Splitter limit(int maxItems) {
        void var1_1;
        Preconditions.checkArgument(maxItems > 0, "must be greater than zero: %s", maxItems);
        return new Splitter(this.strategy, this.omitEmptyStrings, this.trimmer, (int)var1_1);
    }

    public final Splitter trimResults() {
        return this.trimResults(CharMatcher.whitespace());
    }

    /*
     * WARNING - void declaration
     */
    public final Splitter trimResults(CharMatcher trimmer) {
        void var1_1;
        Preconditions.checkNotNull(trimmer);
        return new Splitter(this.strategy, this.omitEmptyStrings, (CharMatcher)var1_1, this.limit);
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<String> split(CharSequence sequence) {
        void var1_1;
        Preconditions.checkNotNull(sequence);
        return new Iterable<String>(this, (CharSequence)var1_1){
            final /* synthetic */ CharSequence val$sequence;
            final /* synthetic */ Splitter this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$sequence = charSequence;
            }

            @Override
            public Iterator<String> iterator() {
                return Splitter.access$000(this.this$0, this.val$sequence);
            }

            public String toString() {
                return Joiner.on(", ").appendTo(new StringBuilder("["), (Iterable<? extends Object>)this).append(']').toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<String> splittingIterator(CharSequence sequence) {
        void var1_1;
        return this.strategy.iterator(this, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> splitToList(CharSequence sequence) {
        void var2_2;
        Preconditions.checkNotNull(sequence);
        Iterator<String> iterator = this.splittingIterator(sequence);
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final Stream<String> splitToStream(CharSequence sequence) {
        void var1_1;
        return StreamSupport.stream(this.split((CharSequence)var1_1).spliterator(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final MapSplitter withKeyValueSeparator(String separator) {
        void var1_1;
        return this.withKeyValueSeparator(Splitter.on((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final MapSplitter withKeyValueSeparator(char separator) {
        void var1_1;
        return this.withKeyValueSeparator(Splitter.on((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final MapSplitter withKeyValueSeparator(Splitter keyValueSplitter) {
        void var1_1;
        return new MapSplitter(this, (Splitter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Iterator access$000(Splitter x0, CharSequence x1) {
        void var1_1;
        return x0.splittingIterator((CharSequence)var1_1);
    }

    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int offset = 0;
        int limit;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        /*
         * WARNING - void declaration
         */
        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            void var2_2;
            void var1_1;
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = ((Splitter)var1_1).limit;
            this.toSplit = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected String computeNext() {
            int nextStart = this.offset;
            while (this.offset != -1) {
                void var3_3;
                void var2_2;
                int end;
                int start = nextStart;
                SplittingIterator splittingIterator = this;
                int separatorPosition = splittingIterator.separatorStart(splittingIterator.offset);
                if (separatorPosition == -1) {
                    end = this.toSplit.length();
                    this.offset = -1;
                } else {
                    end = separatorPosition;
                    this.offset = this.separatorEnd(separatorPosition);
                }
                if (this.offset == nextStart) {
                    ++this.offset;
                    if (this.offset <= this.toSplit.length()) continue;
                    this.offset = -1;
                    continue;
                }
                while (start < end && this.trimmer.matches(this.toSplit.charAt(start))) {
                    ++start;
                }
                while (end > start && this.trimmer.matches(this.toSplit.charAt(end - 1))) {
                    --end;
                }
                if (this.omitEmptyStrings && start == end) {
                    nextStart = this.offset;
                    continue;
                }
                if (this.limit == 1) {
                    this.offset = -1;
                    for (end = this.toSplit.length(); end > start && this.trimmer.matches(this.toSplit.charAt(end - 1)); --end) {
                    }
                } else {
                    --this.limit;
                }
                return this.toSplit.subSequence((int)var2_2, (int)var3_3).toString();
            }
            return (String)this.endOfData();
        }
    }

    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }

    @Beta
    public static final class MapSplitter {
        private static final String INVALID_ENTRY_MESSAGE = "Chunk [%s] is not a valid entry";
        private final Splitter outerSplitter;
        private final Splitter entrySplitter;

        /*
         * WARNING - void declaration
         */
        private MapSplitter(Splitter outerSplitter, Splitter entrySplitter) {
            void var2_2;
            void var1_1;
            this.outerSplitter = var1_1;
            this.entrySplitter = (Splitter)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final Map<String, String> split(CharSequence sequence) {
            void var2_2;
            Iterator<String> iterator;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String entry : this.outerSplitter.split((CharSequence)((Object)iterator))) {
                void var3_3;
                Iterator entryFields = Splitter.access$000(this.entrySplitter, entry);
                Preconditions.checkArgument(entryFields.hasNext(), INVALID_ENTRY_MESSAGE, (Object)entry);
                String key = (String)entryFields.next();
                Preconditions.checkArgument(!map.containsKey(key), "Duplicate key [%s] found.", (Object)key);
                Preconditions.checkArgument(entryFields.hasNext(), INVALID_ENTRY_MESSAGE, (Object)entry);
                String value = (String)entryFields.next();
                map.put(key, value);
                Preconditions.checkArgument(!entryFields.hasNext(), INVALID_ENTRY_MESSAGE, (Object)var3_3);
            }
            return Collections.unmodifiableMap(var2_2);
        }
    }
}

