/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import java.util.BitSet;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class SmallCharMatcher
extends CharMatcher.NamedFastMatcher {
    static final int MAX_SIZE = 1023;
    private final char[] table;
    private final boolean containsZero;
    private final long filter;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final double DESIRED_LOAD_FACTOR = 0.5;

    /*
     * WARNING - void declaration
     */
    private SmallCharMatcher(char[] table, long filter, boolean containsZero, String description) {
        super(description);
        void var2_2;
        void var1_1;
        this.table = var1_1;
        this.filter = var2_2;
        this.containsZero = containsZero;
    }

    static int smear(int hashCode) {
        int n;
        return 461845907 * Integer.rotateLeft(n * -862048943, 15);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkFilter(int c) {
        void var1_1;
        return 1L == (1L & this.filter >> var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static int chooseTableSize(int setSize) {
        void var1_1;
        if (setSize == 1) {
            return 2;
        }
        int tableSize = Integer.highestOneBit(setSize - 1) << 1;
        while ((double)tableSize * 0.5 < (double)setSize) {
            tableSize <<= 1;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static CharMatcher from(BitSet chars, String description) {
        void var1_1;
        void var2_2;
        long filter = 0L;
        int size = chars.cardinality();
        boolean containsZero = chars.get(0);
        char[] table = new char[SmallCharMatcher.chooseTableSize(size)];
        int mask = table.length - 1;
        int c = chars.nextSetBit(0);
        while (c != -1) {
            filter |= 1L << c;
            int index = SmallCharMatcher.smear(c) & mask;
            while (true) {
                if (table[index] == '\u0000') break;
                index = index + 1 & mask;
            }
            table[index] = (char)c;
            c = chars.nextSetBit(c + 1);
        }
        return new SmallCharMatcher(table, (long)var2_2, containsZero, (String)var1_1);
    }

    @Override
    public final boolean matches(char c) {
        int startingIndex;
        if (c == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c)) {
            return false;
        }
        int mask = this.table.length - 1;
        int index = startingIndex = SmallCharMatcher.smear(c) & mask;
        do {
            if (this.table[index] == '\u0000') {
                return false;
            }
            if (this.table[index] != c) continue;
            return true;
        } while ((index = index + 1 & mask) != startingIndex);
        return false;
    }

    @Override
    final void setBits(BitSet table) {
        if (this.containsZero) {
            table.set(0);
        }
        char[] cArray = this.table;
        int n = this.table.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\u0000') continue;
            table.set(c);
        }
    }
}

