/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class Present<T>
extends Optional<T> {
    private final T reference;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    Present(T reference) {
        void var1_1;
        this.reference = var1_1;
    }

    @Override
    public final boolean isPresent() {
        return true;
    }

    @Override
    public final T get() {
        return this.reference;
    }

    @Override
    public final T or(T defaultValue) {
        Preconditions.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
        return this.reference;
    }

    @Override
    public final Optional<T> or(Optional<? extends T> secondChoice) {
        Preconditions.checkNotNull(secondChoice);
        return this;
    }

    @Override
    public final T or(Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier);
        return this.reference;
    }

    @Override
    public final T orNull() {
        return this.reference;
    }

    @Override
    public final Set<T> asSet() {
        return Collections.singleton(this.reference);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V> Optional<V> transform(Function<? super T, V> function) {
        void var1_1;
        return new Present(Preconditions.checkNotNull(var1_1.apply(this.reference), "the Function passed to Optional.transform() must not return null."));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object instanceof Present) {
            void var1_1;
            Present other = (Present)object;
            return this.reference.equals(var1_1.reference);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 1502476572 + this.reference.hashCode();
    }

    @Override
    public final String toString() {
        String string = String.valueOf(this.reference);
        return new StringBuilder(13 + String.valueOf(string).length()).append("Optional.of(").append(string).append(")").toString();
    }
}

