/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CommonPattern;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.JdkPattern;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.ParametricNullness;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Predicates {
    private Predicates() {
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> alwaysFalse() {
        return ObjectPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        Predicate<T> predicate2;
        return new NotPredicate<T>(predicate2);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        Iterable<? extends Predicate<? super T>> iterable;
        return new AndPredicate(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        Predicate<? super T>[] predicateArray;
        return new AndPredicate(Predicates.defensiveCopy(predicateArray));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        void var1_1;
        Predicate<? super T> predicate;
        return new AndPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), (Predicate)Preconditions.checkNotNull(var1_1)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        Iterable<? extends Predicate<? super T>> iterable;
        return new OrPredicate(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        Predicate<? super T>[] predicateArray;
        return new OrPredicate(Predicates.defensiveCopy(predicateArray));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        void var1_1;
        Predicate<? super T> predicate;
        return new OrPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), (Predicate)Preconditions.checkNotNull(var1_1)));
    }

    public static <T> Predicate<T> equalTo(@ParametricNullness T target) {
        T t;
        if (target == null) {
            return Predicates.isNull();
        }
        return new IsEqualToPredicate(t).withNarrowedType();
    }

    @GwtIncompatible
    public static <T> Predicate<T> instanceOf(Class<?> clazz) {
        Class<?> clazz2;
        return new InstanceOfPredicate(clazz2);
    }

    @GwtIncompatible
    @Beta
    public static Predicate<Class<?>> subtypeOf(Class<?> clazz) {
        Class<?> clazz2;
        return new SubtypeOfPredicate(clazz2);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        Collection<? extends T> collection;
        return new InPredicate(collection);
    }

    /*
     * WARNING - void declaration
     */
    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        void var1_1;
        Predicate<B> predicate2;
        return new CompositionPredicate(predicate2, (Function)var1_1);
    }

    @GwtIncompatible
    public static Predicate<CharSequence> containsPattern(String pattern) {
        String string;
        return new ContainsPatternFromStringPredicate(string);
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public static Predicate<CharSequence> contains(Pattern pattern) {
        Pattern pattern2;
        return new ContainsPatternPredicate(new JdkPattern(pattern2));
    }

    /*
     * WARNING - void declaration
     */
    private static String toStringHelper(String methodName, Iterable<?> components) {
        CharSequence charSequence;
        Iterator iterator;
        CharSequence builder = new StringBuilder("Predicates.").append(methodName).append('(');
        boolean first = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object o = iterator.next();
            if (!first) {
                ((StringBuilder)builder).append(',');
            }
            ((StringBuilder)builder).append(var3_3);
            first = false;
        }
        return ((StringBuilder)charSequence).append(')').toString();
    }

    /*
     * WARNING - void declaration
     */
    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> first, Predicate<? super T> second) {
        void var1_1;
        Predicate<? super T> predicate;
        return Arrays.asList(predicate, var1_1);
    }

    private static <T> List<T> defensiveCopy(T ... array) {
        return Predicates.defensiveCopy(Arrays.asList(array));
    }

    /*
     * WARNING - void declaration
     */
    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        void var1_1;
        Iterator<T> iterator;
        ArrayList<void> list = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object element = iterator.next();
            list.add(Preconditions.checkNotNull(var2_2));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$800(String x0, Iterable x1) {
        void var1_1;
        return Predicates.toStringHelper(x0, var1_1);
    }

    @GwtIncompatible
    private static class ContainsPatternFromStringPredicate
    extends ContainsPatternPredicate {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ContainsPatternFromStringPredicate(String string) {
            super(Platform.compilePattern((String)var1_1));
            void var1_1;
        }

        @Override
        public String toString() {
            String string = this.pattern.pattern();
            return new StringBuilder(28 + String.valueOf(string).length()).append("Predicates.containsPattern(").append(string).append(")").toString();
        }
    }

    @GwtIncompatible
    private static class ContainsPatternPredicate
    implements Predicate<CharSequence>,
    Serializable {
        final CommonPattern pattern;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ContainsPatternPredicate(CommonPattern pattern) {
            void var1_1;
            this.pattern = (CommonPattern)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(CharSequence t) {
            void var1_1;
            return this.pattern.matcher((CharSequence)var1_1).find();
        }

        public int hashCode() {
            return Objects.hashCode(this.pattern.pattern(), this.pattern.flags());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ContainsPatternPredicate) {
                void var1_1;
                ContainsPatternPredicate that = (ContainsPatternPredicate)obj;
                return Objects.equal(this.pattern.pattern(), that.pattern.pattern()) && this.pattern.flags() == var1_1.pattern.flags();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            String patternString = MoreObjects.toStringHelper(this.pattern).add("pattern", this.pattern.pattern()).add("pattern.flags", this.pattern.flags()).toString();
            return new StringBuilder(21 + String.valueOf(patternString).length()).append("Predicates.contains(").append((String)var1_1).append(")").toString();
        }
    }

    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<B> p;
        final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private CompositionPredicate(Predicate<B> p, Function<A, ? extends B> f) {
            void var2_2;
            void var1_1;
            this.p = (Predicate)Preconditions.checkNotNull(var1_1);
            this.f = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(@ParametricNullness A a) {
            void var1_1;
            return this.p.apply(this.f.apply(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CompositionPredicate) {
                void var1_1;
                CompositionPredicate that = (CompositionPredicate)obj;
                return this.f.equals(that.f) && this.p.equals(var1_1.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.p);
            String string2 = String.valueOf(this.f);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("(").append(string2).append(")").toString();
        }
    }

    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private InPredicate(Collection<?> target) {
            void var1_1;
            this.target = (Collection)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(@ParametricNullness T t) {
            try {
                void var1_1;
                return this.target.contains(var1_1);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InPredicate) {
                void var1_1;
                InPredicate that = (InPredicate)obj;
                return this.target.equals(var1_1.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.target);
            return new StringBuilder(15 + String.valueOf(string).length()).append("Predicates.in(").append(string).append(")").toString();
        }
    }

    @GwtIncompatible
    private static class SubtypeOfPredicate
    implements Predicate<Class<?>>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SubtypeOfPredicate(Class<?> clazz) {
            void var1_1;
            this.clazz = (Class)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(Class<?> input) {
            void var1_1;
            return this.clazz.isAssignableFrom((Class<?>)var1_1);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SubtypeOfPredicate) {
                void var1_1;
                SubtypeOfPredicate that = (SubtypeOfPredicate)obj;
                return this.clazz == var1_1.clazz;
            }
            return false;
        }

        public String toString() {
            String string = this.clazz.getName();
            return new StringBuilder(22 + String.valueOf(string).length()).append("Predicates.subtypeOf(").append(string).append(")").toString();
        }
    }

    @GwtIncompatible
    private static class InstanceOfPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private InstanceOfPredicate(Class<?> clazz) {
            void var1_1;
            this.clazz = (Class)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(@ParametricNullness T o) {
            void var1_1;
            return this.clazz.isInstance(var1_1);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InstanceOfPredicate) {
                void var1_1;
                InstanceOfPredicate that = (InstanceOfPredicate)obj;
                return this.clazz == var1_1.clazz;
            }
            return false;
        }

        public String toString() {
            String string = this.clazz.getName();
            return new StringBuilder(23 + String.valueOf(string).length()).append("Predicates.instanceOf(").append(string).append(")").toString();
        }
    }

    private static class IsEqualToPredicate
    implements Predicate<Object>,
    Serializable {
        private final Object target;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private IsEqualToPredicate(Object target) {
            void var1_1;
            this.target = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(Object o) {
            void var1_1;
            return this.target.equals(var1_1);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                void var1_1;
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(var1_1.target);
            }
            return false;
        }

        public String toString() {
            String string = String.valueOf(this.target);
            return new StringBuilder(20 + String.valueOf(string).length()).append("Predicates.equalTo(").append(string).append(")").toString();
        }

        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }

    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private OrPredicate(List<? extends Predicate<? super T>> components) {
            void var1_1;
            this.components = var1_1;
        }

        @Override
        public boolean apply(@ParametricNullness T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.components.get(i).apply(t)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.components.hashCode() + 87855567;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OrPredicate) {
                void var1_1;
                OrPredicate that = (OrPredicate)obj;
                return this.components.equals(var1_1.components);
            }
            return false;
        }

        public String toString() {
            return Predicates.access$800("or", this.components);
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private AndPredicate(List<? extends Predicate<? super T>> components) {
            void var1_1;
            this.components = var1_1;
        }

        @Override
        public boolean apply(@ParametricNullness T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.components.get(i).apply(t)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.components.hashCode() + 306654252;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AndPredicate) {
                void var1_1;
                AndPredicate that = (AndPredicate)obj;
                return this.components.equals(var1_1.components);
            }
            return false;
        }

        public String toString() {
            return Predicates.access$800("and", this.components);
        }
    }

    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        NotPredicate(Predicate<T> predicate) {
            void var1_1;
            this.predicate = (Predicate)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(@ParametricNullness T t) {
            void var1_1;
            return !this.predicate.apply(var1_1);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NotPredicate) {
                void var1_1;
                NotPredicate that = (NotPredicate)obj;
                return this.predicate.equals(var1_1.predicate);
            }
            return false;
        }

        public String toString() {
            String string = String.valueOf(this.predicate);
            return new StringBuilder(16 + String.valueOf(string).length()).append("Predicates.not(").append(string).append(")").toString();
        }
    }

    static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            @Override
            public final boolean apply(Object o) {
                return true;
            }

            public final String toString() {
                return "Predicates.alwaysTrue()";
            }
        }
        ,
        ALWAYS_FALSE{

            @Override
            public final boolean apply(Object o) {
                return false;
            }

            public final String toString() {
                return "Predicates.alwaysFalse()";
            }
        }
        ,
        IS_NULL{

            @Override
            public final boolean apply(Object o) {
                return o == null;
            }

            public final String toString() {
                return "Predicates.isNull()";
            }
        }
        ,
        NOT_NULL{

            @Override
            public final boolean apply(Object o) {
                return o != null;
            }

            public final String toString() {
                return "Predicates.notNull()";
            }
        };


        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }
}

