/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Strings;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, char p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, int p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, long p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (long)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, char p1, char p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), Character.valueOf((char)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, char p1, int p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, char p1, long p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), (long)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, char p1, Object p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, int p1, char p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2, Character.valueOf((char)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, int p1, long p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2, (long)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, int p1, Object p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2, var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, long p1, char p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (long)var2_2, Character.valueOf(p2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, long p1, int p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, long p1, long p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, long p1, Object p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, char p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, Character.valueOf((char)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, int p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, long p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, (long)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, Object p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, var3_3, p3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3, Object p4) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, var3_3, p3, p4));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalStateException(String.valueOf(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, char p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, int p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, long p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (long)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, char p1, char p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), Character.valueOf((char)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, char p1, int p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, char p1, long p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), (long)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, char p1, Object p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, int p1, char p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (int)var2_2, Character.valueOf((char)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, int p1, long p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (int)var2_2, (long)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, int p1, Object p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (int)var2_2, var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, long p1, char p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (long)var2_2, Character.valueOf(p2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, long p1, int p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, long p1, long p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, long p1, Object p2) {
        if (!b) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1, char p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2, Character.valueOf((char)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1, int p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1, long p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2, (long)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1, Object p2) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2, var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2, var3_3, p3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3, Object p4) {
        if (!b) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalStateException(Strings.lenientFormat((String)var1_1, var2_2, var3_3, p3, p4));
        }
    }

    public static <T> T checkNotNull(T reference) {
        T t;
        if (reference == null) {
            throw new NullPointerException();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T reference, Object errorMessage) {
        T t;
        if (reference == null) {
            void var1_1;
            throw new NullPointerException(String.valueOf(var1_1));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        T t;
        if (reference == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (Object[])var2_2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, char p1) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2)));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, int p1) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (int)var2_2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, long p1) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (long)var2_2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, char p1, char p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), Character.valueOf((char)var3_3)));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, char p1, int p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), (int)var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, char p1, long p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), (long)var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, char p1, Object p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2), var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, int p1, char p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (int)var2_2, Character.valueOf((char)var3_3)));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, int p1, int p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (int)var2_2, (int)var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, int p1, long p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (int)var2_2, (long)var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, int p1, Object p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (int)var2_2, var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, long p1, char p2) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (long)var2_2, Character.valueOf(p2)));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, long p1, int p2) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, long p1, long p2) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, long p1, Object p2) {
        T t;
        if (obj == null) {
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, (long)var2_2, p2));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1, char p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2, Character.valueOf((char)var3_3)));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1, int p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2, (int)var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1, long p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2, (long)var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1, Object p2) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2, var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1, Object p2, Object p3) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2, var3_3, p3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T obj, String errorMessageTemplate, Object p1, Object p2, Object p3, Object p4) {
        T t;
        if (obj == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new NullPointerException(Strings.lenientFormat((String)var1_1, var2_2, var3_3, p3, p4));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkElementIndex(int index, int size) {
        void var1_1;
        return Preconditions.checkElementIndex(index, (int)var1_1, "index");
    }

    /*
     * WARNING - void declaration
     */
    public static int checkElementIndex(int index, int size, String desc) {
        int n;
        if (index < 0 || index >= size) {
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index, (int)var1_1, (String)var2_2));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static String badElementIndex(int index, int size, String desc) {
        void var1_1;
        int n;
        void var2_2;
        if (index < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(size).toString());
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", var2_2, n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int checkPositionIndex(int index, int size) {
        void var1_1;
        return Preconditions.checkPositionIndex(index, (int)var1_1, "index");
    }

    /*
     * WARNING - void declaration
     */
    public static int checkPositionIndex(int index, int size, String desc) {
        int n;
        if (index < 0 || index > size) {
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index, (int)var1_1, (String)var2_2));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static String badPositionIndex(int index, int size, String desc) {
        void var1_1;
        int n;
        void var2_2;
        if (index < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(size).toString());
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", var2_2, n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            void var2_2;
            void var1_1;
            int n;
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n, (int)var1_1, (int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String badPositionIndexes(int start, int end, int size) {
        int n;
        void var1_1;
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            void var2_2;
            return Preconditions.badPositionIndex(end, (int)var2_2, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", (int)var1_1, n);
    }
}

