/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.CommonPattern;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Enums;
import com.google.common.base.JdkPattern;
import com.google.common.base.Optional;
import com.google.common.base.PatternCompiler;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        void var1_1;
        Class<T> clazz;
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        if (ref == null) {
            return Optional.absent();
        }
        return Optional.of((Enum)clazz.cast(var1_1.get()));
    }

    static String formatCompact4Digits(double value) {
        double d;
        return String.format(Locale.ROOT, "%.4g", d);
    }

    static boolean stringIsNullOrEmpty(String string) {
        String string2;
        return string == null || string2.isEmpty();
    }

    static String nullToEmpty(String string) {
        String string2;
        if (string == null) {
            return "";
        }
        return string2;
    }

    static String emptyToNull(String string) {
        String string2;
        if (Platform.stringIsNullOrEmpty(string)) {
            return null;
        }
        return string2;
    }

    static CommonPattern compilePattern(String pattern) {
        String string;
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(string);
    }

    static boolean patternCompilerIsPcreLike() {
        return patternCompiler.isPcreLike();
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static void logPatternCompilerError(ServiceConfigurationError e) {
        ServiceConfigurationError serviceConfigurationError;
        logger.log(Level.WARNING, "Error loading regex compiler, falling back to next option", serviceConfigurationError);
    }

    /*
     * WARNING - void declaration
     */
    static void checkGwtRpcEnabled() {
        String propertyName = "guava.gwt.emergency_reenable_rpc";
        if (!Boolean.parseBoolean(System.getProperty("guava.gwt.emergency_reenable_rpc", "false"))) {
            void var0;
            throw new UnsupportedOperationException(Strings.lenientFormat("We are removing GWT-RPC support for Guava types. You can temporarily reenable support by setting the system property %s to true. For more about system properties, see %s. For more about Guava's GWT-RPC support, see %s.", var0, "https://stackoverflow.com/q/5189914/28465", "https://groups.google.com/d/msg/guava-announce/zHZTFg7YF3o/rQNnwdHeEwAJ"));
        }
        logger.log(Level.WARNING, "Later in 2020, we will remove GWT-RPC support for Guava types. You are seeing this warning because you are sending a Guava type over GWT-RPC, which will break. You can identify which type by looking at the class name in the attached stack trace.", new Throwable());
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CommonPattern compile(String pattern) {
            void var1_1;
            return new JdkPattern(Pattern.compile((String)var1_1));
        }

        @Override
        public final boolean isPcreLike() {
            return true;
        }
    }
}

