/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class PairwiseEquivalence<E, T extends E>
extends Equivalence<Iterable<T>>
implements Serializable {
    final Equivalence<E> elementEquivalence;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    PairwiseEquivalence(Equivalence<E> elementEquivalence) {
        void var1_1;
        this.elementEquivalence = (Equivalence)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doEquivalent(Iterable<T> iterableA, Iterable<T> iterableB) {
        void var2_2;
        void var1_1;
        Iterator<T> iteratorA = iterableA.iterator();
        Iterator<T> iteratorB = iterableB.iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (this.elementEquivalence.equivalent(iteratorA.next(), iteratorB.next())) continue;
            return false;
        }
        return !var1_1.hasNext() && !var2_2.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int doHash(Iterable<T> iterable) {
        void var2_2;
        Iterator iterator;
        int hash = 78721;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object element = iterator.next();
            hash = hash * 24943 + this.elementEquivalence.hash(var3_3);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object instanceof PairwiseEquivalence) {
            void var1_1;
            PairwiseEquivalence that = (PairwiseEquivalence)object;
            return this.elementEquivalence.equals(var1_1.elementEquivalence);
        }
        return false;
    }

    public final int hashCode() {
        return this.elementEquivalence.hashCode() ^ 0x46A3EB07;
    }

    public final String toString() {
        String string = String.valueOf(this.elementEquivalence);
        return new StringBuilder(11 + String.valueOf(string).length()).append(string).append(".pairwise()").toString();
    }
}

