/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Absent;
import com.google.common.base.AbstractIterator;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Present;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T reference) {
        T t;
        return new Present<T>(Preconditions.checkNotNull(t));
    }

    public static <T> Optional<T> fromNullable(T nullableReference) {
        T t;
        if (nullableReference == null) {
            return Optional.absent();
        }
        return new Present<T>(t);
    }

    public static <T> Optional<T> fromJavaUtil(java.util.Optional<T> javaUtilOptional) {
        java.util.Optional<Object> optional;
        if (javaUtilOptional == null) {
            return null;
        }
        return Optional.fromNullable(optional.orElse(null));
    }

    public static <T> java.util.Optional<T> toJavaUtil(Optional<T> googleOptional) {
        Optional<T> optional;
        if (googleOptional == null) {
            return null;
        }
        return optional.toJavaUtil();
    }

    public java.util.Optional<T> toJavaUtil() {
        return java.util.Optional.ofNullable(this.orNull());
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    @Beta
    public abstract T or(Supplier<? extends T> var1);

    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Beta
    public static <T> Iterable<T> presentInstances(Iterable<? extends Optional<? extends T>> optionals) {
        Iterable<? extends Optional<? extends T>> iterable;
        Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(this){
                    private final Iterator<? extends Optional<? extends T>> iterator;
                    final /* synthetic */ 1 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.iterator = Preconditions.checkNotNull(this.this$0.iterable.iterator());
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            void var1_1;
                            Optional optional = this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return var1_1.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

