/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class MoreObjects {
    /*
     * WARNING - void declaration
     */
    public static <T> T firstNonNull(T first, T second) {
        if (first != null) {
            T t;
            return t;
        }
        if (second != null) {
            void var1_1;
            return var1_1;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Object self) {
        Object object;
        return new ToStringHelper(object.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        Class<?> clazz2;
        return new ToStringHelper(clazz2.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String className) {
        String string;
        return new ToStringHelper(string);
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;
        private boolean omitEmptyValues;

        /*
         * WARNING - void declaration
         */
        private ToStringHelper(String className) {
            void var1_1;
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.omitEmptyValues = false;
            this.className = (String)Preconditions.checkNotNull(var1_1);
        }

        public final ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, Object value) {
            void var2_2;
            void var1_1;
            return this.addHolder((String)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, boolean value) {
            void var2_2;
            void var1_1;
            return this.addUnconditionalHolder((String)var1_1, String.valueOf((boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, char value) {
            void var2_2;
            void var1_1;
            return this.addUnconditionalHolder((String)var1_1, String.valueOf((char)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, double value) {
            void var2_2;
            void var1_1;
            return this.addUnconditionalHolder((String)var1_1, String.valueOf((double)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, float value) {
            void var2_2;
            void var1_1;
            return this.addUnconditionalHolder((String)var1_1, String.valueOf((float)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, int value) {
            void var2_2;
            void var1_1;
            return this.addUnconditionalHolder((String)var1_1, String.valueOf((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper add(String name, long value) {
            void var2_2;
            void var1_1;
            return this.addUnconditionalHolder((String)var1_1, String.valueOf((long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(Object value) {
            void var1_1;
            return this.addHolder(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(boolean value) {
            void var1_1;
            return this.addUnconditionalHolder(String.valueOf((boolean)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(char value) {
            void var1_1;
            return this.addUnconditionalHolder(String.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(double value) {
            void var1_1;
            return this.addUnconditionalHolder(String.valueOf((double)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(float value) {
            void var1_1;
            return this.addUnconditionalHolder(String.valueOf((float)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(int value) {
            void var1_1;
            return this.addUnconditionalHolder(String.valueOf((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final ToStringHelper addValue(long value) {
            void var1_1;
            return this.addUnconditionalHolder(String.valueOf((long)var1_1));
        }

        private static boolean isEmpty(Object value) {
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            if (value instanceof Map) {
                return ((Map)value).isEmpty();
            }
            if (value instanceof java.util.Optional) {
                return !((java.util.Optional)value).isPresent();
            }
            if (value instanceof OptionalInt) {
                return !((OptionalInt)value).isPresent();
            }
            if (value instanceof OptionalLong) {
                return !((OptionalLong)value).isPresent();
            }
            if (value instanceof OptionalDouble) {
                return !((OptionalDouble)value).isPresent();
            }
            if (value instanceof Optional) {
                return !((Optional)value).isPresent();
            }
            if (value.getClass().isArray()) {
                Object object;
                return Array.getLength(object) == 0;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            boolean omitEmptyValuesSnapshot = this.omitEmptyValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object[] value = valueHolder.value;
                if (valueHolder instanceof UnconditionalValueHolder || (value == null ? !omitNullValuesSnapshot : !omitEmptyValuesSnapshot || !ToStringHelper.isEmpty(value))) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        value = new Object[]{value};
                        String arrayString = Arrays.deepToString(value);
                        builder.append(arrayString, 1, arrayString.length() - 1);
                    } else {
                        void var6_6;
                        builder.append(var6_6);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        /*
         * WARNING - void declaration
         */
        private ValueHolder addHolder() {
            void var1_1;
            ValueHolder valueHolder = new ValueHolder();
            ToStringHelper toStringHelper = this;
            toStringHelper.holderTail = toStringHelper.holderTail.next = valueHolder;
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ToStringHelper addHolder(Object value) {
            void var1_1;
            ValueHolder valueHolder = this.addHolder();
            this.addHolder().value = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private ToStringHelper addHolder(String name, Object value) {
            void var1_1;
            void var2_2;
            ValueHolder valueHolder = this.addHolder();
            this.addHolder().value = var2_2;
            var3_3.name = (String)Preconditions.checkNotNull(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private UnconditionalValueHolder addUnconditionalHolder() {
            void var1_1;
            UnconditionalValueHolder valueHolder = new UnconditionalValueHolder();
            ToStringHelper toStringHelper = this;
            toStringHelper.holderTail = toStringHelper.holderTail.next = valueHolder;
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ToStringHelper addUnconditionalHolder(Object value) {
            void var1_1;
            UnconditionalValueHolder unconditionalValueHolder = this.addUnconditionalHolder();
            this.addUnconditionalHolder().value = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private ToStringHelper addUnconditionalHolder(String name, Object value) {
            void var1_1;
            void var2_2;
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            this.addUnconditionalHolder().value = var2_2;
            var3_3.name = (String)Preconditions.checkNotNull(var1_1);
            return this;
        }

        private static final class UnconditionalValueHolder
        extends ValueHolder {
            private UnconditionalValueHolder() {
            }
        }

        private static class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

