/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class Joiner {
    private final String separator;

    public static Joiner on(String separator) {
        String string;
        return new Joiner(string);
    }

    public static Joiner on(char separator) {
        char c;
        return new Joiner(String.valueOf(c));
    }

    /*
     * WARNING - void declaration
     */
    private Joiner(String separator) {
        void var1_1;
        this.separator = (String)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Joiner(Joiner prototype) {
        void var1_1;
        this.separator = var1_1.separator;
    }

    /*
     * WARNING - void declaration
     */
    public <A extends Appendable> A appendTo(A appendable, Iterable<? extends Object> parts) throws IOException {
        void var2_2;
        void var1_1;
        return this.appendTo(var1_1, var2_2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public <A extends Appendable> A appendTo(A appendable, Iterator<? extends Object> parts) throws IOException {
        void var1_1;
        Preconditions.checkNotNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Appendable> A appendTo(A appendable, Object[] parts) throws IOException {
        void var2_2;
        void var1_1;
        return this.appendTo(var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Appendable> A appendTo(A appendable, Object first, Object second, Object ... rest) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.appendTo(var1_1, Joiner.iterable(var2_2, var3_3, rest));
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder appendTo(StringBuilder builder, Iterable<? extends Object> parts) {
        void var2_2;
        void var1_1;
        return this.appendTo((StringBuilder)var1_1, var2_2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder appendTo(StringBuilder builder, Iterator<? extends Object> parts) {
        void var1_1;
        try {
            void var2_3;
            this.appendTo((Appendable)builder, (Iterator<? extends Object>)var2_3);
        }
        catch (IOException impossible) {
            void var1_2;
            throw new AssertionError(var1_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder appendTo(StringBuilder builder, Object[] parts) {
        void var2_2;
        void var1_1;
        return this.appendTo((StringBuilder)var1_1, (Iterable<? extends Object>)Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder appendTo(StringBuilder builder, Object first, Object second, Object ... rest) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.appendTo((StringBuilder)var1_1, Joiner.iterable(var2_2, var3_3, rest));
    }

    /*
     * WARNING - void declaration
     */
    public final String join(Iterable<? extends Object> parts) {
        void var1_1;
        return this.join(var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public final String join(Iterator<? extends Object> parts) {
        void var1_1;
        return this.appendTo(new StringBuilder(), (Iterator<? extends Object>)var1_1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String join(Object[] parts) {
        void var1_1;
        return this.join(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final String join(Object first, Object second, Object ... rest) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.join(Joiner.iterable(var1_1, var2_2, (Object[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Joiner useForNull(String nullText) {
        void var1_1;
        Preconditions.checkNotNull(nullText);
        Joiner joiner = this;
        return new Joiner(joiner, joiner, (String)var1_1){
            final /* synthetic */ String val$nullText;
            final /* synthetic */ Joiner this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$nullText = string;
                super((Joiner)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            CharSequence toString(Object part) {
                void var1_1;
                if (part == null) {
                    return this.val$nullText;
                }
                return this.this$0.toString(var1_1);
            }

            @Override
            public Joiner useForNull(String nullText) {
                throw new UnsupportedOperationException("already specified useForNull");
            }

            @Override
            public Joiner skipNulls() {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    public Joiner skipNulls() {
        Joiner joiner = this;
        return new Joiner(joiner, joiner){
            final /* synthetic */ Joiner this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Joiner)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <A extends Appendable> A appendTo(A appendable, Iterator<? extends Object> parts) throws IOException {
                void var1_1;
                Object part;
                Preconditions.checkNotNull(appendable, "appendable");
                Preconditions.checkNotNull(parts, "parts");
                while (parts.hasNext()) {
                    part = parts.next();
                    if (part == null) continue;
                    appendable.append(this.this$0.toString(part));
                    break;
                }
                while (parts.hasNext()) {
                    void var3_3;
                    part = parts.next();
                    if (part == null) continue;
                    appendable.append(this.this$0.separator);
                    appendable.append(this.this$0.toString(var3_3));
                }
                return var1_1;
            }

            @Override
            public Joiner useForNull(String nullText) {
                throw new UnsupportedOperationException("already specified skipNulls");
            }

            @Override
            public MapJoiner withKeyValueSeparator(String kvs) {
                throw new UnsupportedOperationException("can't use .skipNulls() with maps");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public MapJoiner withKeyValueSeparator(char keyValueSeparator) {
        void var1_1;
        return this.withKeyValueSeparator(String.valueOf((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MapJoiner withKeyValueSeparator(String keyValueSeparator) {
        void var1_1;
        return new MapJoiner(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    CharSequence toString(Object part) {
        void var1_1;
        Objects.requireNonNull(part);
        if (part instanceof CharSequence) {
            return (CharSequence)part;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static Iterable<Object> iterable(Object first, Object second, Object[] rest) {
        void var1_1;
        Object object;
        void var2_2;
        Preconditions.checkNotNull(rest);
        return new AbstractList<Object>((Object[])var2_2, object, (Object)var1_1){
            final /* synthetic */ Object[] val$rest;
            final /* synthetic */ Object val$first;
            final /* synthetic */ Object val$second;
            {
                this.val$rest = objectArray;
                this.val$first = object;
                this.val$second = object2;
            }

            @Override
            public int size() {
                return this.val$rest.length + 2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Object get(int index) {
                void var1_1;
                switch (index) {
                    case 0: {
                        return this.val$first;
                    }
                    case 1: {
                        return this.val$second;
                    }
                }
                return this.val$rest[var1_1 - 2];
            }
        };
    }

    public static final class MapJoiner {
        private final Joiner joiner;
        private final String keyValueSeparator;

        /*
         * WARNING - void declaration
         */
        private MapJoiner(Joiner joiner, String keyValueSeparator) {
            void var2_2;
            void var1_1;
            this.joiner = var1_1;
            this.keyValueSeparator = (String)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final <A extends Appendable> A appendTo(A appendable, Map<?, ?> map) throws IOException {
            void var2_2;
            void var1_1;
            return this.appendTo(var1_1, var2_2.entrySet());
        }

        /*
         * WARNING - void declaration
         */
        public final StringBuilder appendTo(StringBuilder builder, Map<?, ?> map) {
            void var2_2;
            void var1_1;
            return this.appendTo((StringBuilder)var1_1, (Iterable<? extends Map.Entry<?, ?>>)var2_2.entrySet());
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public final <A extends Appendable> A appendTo(A appendable, Iterable<? extends Map.Entry<?, ?>> entries) throws IOException {
            void var2_2;
            void var1_1;
            return this.appendTo(var1_1, var2_2.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public final <A extends Appendable> A appendTo(A appendable, Iterator<? extends Map.Entry<?, ?>> parts) throws IOException {
            void var1_1;
            Preconditions.checkNotNull(appendable);
            if (parts.hasNext()) {
                Map.Entry<?, ?> entry = parts.next();
                appendable.append(this.joiner.toString(entry.getKey()));
                appendable.append(this.keyValueSeparator);
                appendable.append(this.joiner.toString(entry.getValue()));
                while (parts.hasNext()) {
                    void var3_3;
                    appendable.append(this.joiner.separator);
                    Map.Entry<?, ?> e = parts.next();
                    appendable.append(this.joiner.toString(e.getKey()));
                    appendable.append(this.keyValueSeparator);
                    appendable.append(this.joiner.toString(var3_3.getValue()));
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public final StringBuilder appendTo(StringBuilder builder, Iterable<? extends Map.Entry<?, ?>> entries) {
            void var2_2;
            void var1_1;
            return this.appendTo((StringBuilder)var1_1, var2_2.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public final StringBuilder appendTo(StringBuilder builder, Iterator<? extends Map.Entry<?, ?>> entries) {
            void var1_1;
            try {
                void var2_3;
                this.appendTo((Appendable)builder, (Iterator<? extends Map.Entry<?, ?>>)var2_3);
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final String join(Map<?, ?> map) {
            void var1_1;
            return this.join(var1_1.entrySet());
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public final String join(Iterable<? extends Map.Entry<?, ?>> entries) {
            void var1_1;
            return this.join(var1_1.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public final String join(Iterator<? extends Map.Entry<?, ?>> entries) {
            void var1_1;
            return this.appendTo(new StringBuilder(), (Iterator<? extends Map.Entry<?, ?>>)var1_1).toString();
        }

        /*
         * WARNING - void declaration
         */
        public final MapJoiner useForNull(String nullText) {
            void var1_1;
            return new MapJoiner(this.joiner.useForNull((String)var1_1), this.keyValueSeparator);
        }
    }
}

