/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.NullnessCasts;
import com.google.common.base.Objects;
import com.google.common.base.ParametricNullness;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Functions {
    private Functions() {
    }

    public static Function<Object, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static <E> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <K, V> Function<K, V> forMap(Map<K, V> map) {
        Map<K, V> map2;
        return new FunctionForMapNoDefault<K, V>(map2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Function<K, V> forMap(Map<K, ? extends V> map, @ParametricNullness V defaultValue) {
        void var1_1;
        Map<K, ? extends V> map2;
        return new ForMapWithDefault<K, void>(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <A, B, C> Function<A, C> compose(Function<B, C> g, Function<A, ? extends B> f) {
        void var1_1;
        Function<B, C> function;
        return new FunctionComposition(function, var1_1);
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<T> predicate) {
        Predicate<T> predicate2;
        return new PredicateFunction(predicate2);
    }

    public static <E> Function<Object, E> constant(@ParametricNullness E value) {
        E e;
        return new ConstantFunction<E>(e);
    }

    public static <F, T> Function<F, T> forSupplier(Supplier<T> supplier) {
        Supplier<T> supplier2;
        return new SupplierFunction(supplier2);
    }

    private static class SupplierFunction<F, T>
    implements Function<F, T>,
    Serializable {
        private final Supplier<T> supplier;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SupplierFunction(Supplier<T> supplier) {
            void var1_1;
            this.supplier = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        @Override
        @ParametricNullness
        public T apply(@ParametricNullness F input) {
            return this.supplier.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SupplierFunction) {
                void var1_1;
                SupplierFunction that = (SupplierFunction)obj;
                return this.supplier.equals(var1_1.supplier);
            }
            return false;
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.supplier);
            return new StringBuilder(23 + String.valueOf(string).length()).append("Functions.forSupplier(").append(string).append(")").toString();
        }
    }

    private static class ConstantFunction<E>
    implements Function<Object, E>,
    Serializable {
        @ParametricNullness
        private final E value;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public ConstantFunction(@ParametricNullness E value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        @ParametricNullness
        public E apply(Object from) {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ConstantFunction) {
                void var1_1;
                ConstantFunction that = (ConstantFunction)obj;
                return Objects.equal(this.value, var1_1.value);
            }
            return false;
        }

        public int hashCode() {
            if (this.value == null) {
                return 0;
            }
            return this.value.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.value);
            return new StringBuilder(20 + String.valueOf(string).length()).append("Functions.constant(").append(string).append(")").toString();
        }
    }

    private static class PredicateFunction<T>
    implements Function<T, Boolean>,
    Serializable {
        private final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private PredicateFunction(Predicate<T> predicate) {
            void var1_1;
            this.predicate = (Predicate)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean apply(@ParametricNullness T t) {
            void var1_1;
            return this.predicate.apply(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof PredicateFunction) {
                void var1_1;
                PredicateFunction that = (PredicateFunction)obj;
                return this.predicate.equals(var1_1.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.predicate);
            return new StringBuilder(24 + String.valueOf(string).length()).append("Functions.forPredicate(").append(string).append(")").toString();
        }
    }

    private static class FunctionComposition<A, B, C>
    implements Function<A, C>,
    Serializable {
        private final Function<B, C> g;
        private final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public FunctionComposition(Function<B, C> g, Function<A, ? extends B> f) {
            void var2_2;
            void var1_1;
            this.g = (Function)Preconditions.checkNotNull(var1_1);
            this.f = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public C apply(@ParametricNullness A a) {
            void var1_1;
            return this.g.apply(this.f.apply(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FunctionComposition) {
                void var1_1;
                FunctionComposition that = (FunctionComposition)obj;
                return this.f.equals(that.f) && this.g.equals(var1_1.g);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.g.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.g);
            String string2 = String.valueOf(this.f);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("(").append(string2).append(")").toString();
        }
    }

    private static class ForMapWithDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, ? extends V> map;
        @ParametricNullness
        final V defaultValue;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ForMapWithDefault(Map<K, ? extends V> map, @ParametricNullness V defaultValue) {
            void var2_2;
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
            this.defaultValue = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public V apply(@ParametricNullness K key) {
            void var1_1;
            V result = this.map.get(key);
            if (result != null || this.map.containsKey(var1_1)) {
                void var2_2;
                return NullnessCasts.uncheckedCastNullableTToT(var2_2);
            }
            return this.defaultValue;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o instanceof ForMapWithDefault) {
                void var1_1;
                ForMapWithDefault that = (ForMapWithDefault)o;
                return this.map.equals(that.map) && Objects.equal(this.defaultValue, var1_1.defaultValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.map, this.defaultValue);
        }

        public String toString() {
            String string = String.valueOf(this.map);
            String string2 = String.valueOf(this.defaultValue);
            return new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Functions.forMap(").append(string).append(", defaultValue=").append(string2).append(")").toString();
        }
    }

    private static class FunctionForMapNoDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, V> map;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        FunctionForMapNoDefault(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public V apply(@ParametricNullness K key) {
            void var2_2;
            void var1_1;
            V result = this.map.get(key);
            Preconditions.checkArgument(result != null || this.map.containsKey(key), "Key '%s' not present in map", (Object)var1_1);
            return NullnessCasts.uncheckedCastNullableTToT(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o instanceof FunctionForMapNoDefault) {
                void var1_1;
                FunctionForMapNoDefault that = (FunctionForMapNoDefault)o;
                return this.map.equals(var1_1.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.map);
            return new StringBuilder(18 + String.valueOf(string).length()).append("Functions.forMap(").append(string).append(")").toString();
        }
    }

    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        public final Object apply(Object o) {
            return o;
        }

        public final String toString() {
            return "Functions.identity()";
        }
    }

    private static enum ToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final String apply(Object o) {
            void var1_1;
            Preconditions.checkNotNull(o);
            return var1_1.toString();
        }

        public final String toString() {
            return "Functions.toStringFunction()";
        }
    }
}

