/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
final class FunctionalEquivalence<F, T>
extends Equivalence<F>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Function<? super F, ? extends T> function;
    private final Equivalence<T> resultEquivalence;

    /*
     * WARNING - void declaration
     */
    FunctionalEquivalence(Function<? super F, ? extends T> function, Equivalence<T> resultEquivalence) {
        void var2_2;
        void var1_1;
        this.function = (Function)Preconditions.checkNotNull(var1_1);
        this.resultEquivalence = (Equivalence)Preconditions.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doEquivalent(F a, F b) {
        void var2_2;
        void var1_1;
        return this.resultEquivalence.equivalent(this.function.apply(var1_1), this.function.apply(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int doHash(F a) {
        void var1_1;
        return this.resultEquivalence.hash(this.function.apply(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionalEquivalence) {
            void var1_1;
            FunctionalEquivalence that = (FunctionalEquivalence)obj;
            return this.function.equals(that.function) && this.resultEquivalence.equals(var1_1.resultEquivalence);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.function, this.resultEquivalence);
    }

    public final String toString() {
        String string = String.valueOf(this.resultEquivalence);
        String string2 = String.valueOf(this.function);
        return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

