/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.FinalizableReference;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class FinalizableReferenceQueue
implements Closeable {
    private static final Logger logger = Logger.getLogger(FinalizableReferenceQueue.class.getName());
    private static final String FINALIZER_CLASS_NAME = "com.google.common.base.internal.Finalizer";
    private static final Method startFinalizer;
    final ReferenceQueue<Object> queue = new ReferenceQueue();
    final PhantomReference<Object> frqRef;
    final boolean threadStarted;

    /*
     * WARNING - void declaration
     */
    public FinalizableReferenceQueue() {
        void var1_1;
        FinalizableReferenceQueue finalizableReferenceQueue = this;
        this.frqRef = new PhantomReference<Object>(finalizableReferenceQueue, finalizableReferenceQueue.queue);
        boolean threadStarted = false;
        try {
            startFinalizer.invoke(null, FinalizableReference.class, this.queue, this.frqRef);
            threadStarted = true;
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (Throwable t) {
            void var2_3;
            logger.log(Level.INFO, "Failed to start reference finalizer thread. Reference cleanup will only occur when new references are created.", (Throwable)var2_3);
        }
        this.threadStarted = var1_1;
    }

    @Override
    public void close() {
        this.frqRef.enqueue();
        this.cleanUp();
    }

    /*
     * WARNING - void declaration
     */
    void cleanUp() {
        Reference<Object> reference;
        if (this.threadStarted) {
            return;
        }
        while ((reference = this.queue.poll()) != null) {
            reference.clear();
            try {
                ((FinalizableReference)((Object)reference)).finalizeReferent();
            }
            catch (Throwable t) {
                void var1_2;
                logger.log(Level.SEVERE, "Error cleaning up after reference.", (Throwable)var1_2);
            }
        }
    }

    private static Class<?> loadFinalizer(FinalizerLoader ... loaders) {
        FinalizerLoader[] finalizerLoaderArray = loaders;
        int n = loaders.length;
        for (int i = 0; i < n; ++i) {
            FinalizerLoader finalizerLoader = finalizerLoaderArray[i];
            Class<?> finalizer = finalizerLoader.loadFinalizer();
            if (finalizer == null) continue;
            return finalizerLoader;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    static Method getStartFinalizer(Class<?> finalizer) {
        try {
            return finalizer.getMethod("startFinalizer", Class.class, ReferenceQueue.class, PhantomReference.class);
        }
        catch (NoSuchMethodException e) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }

    static {
        Class<?> clazz = FinalizableReferenceQueue.loadFinalizer(new SystemLoader(), new DecoupledLoader(), new DirectLoader());
        startFinalizer = FinalizableReferenceQueue.getStartFinalizer(clazz);
    }

    static class DirectLoader
    implements FinalizerLoader {
        DirectLoader() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> loadFinalizer() {
            try {
                return Class.forName(FinalizableReferenceQueue.FINALIZER_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                void var1_1;
                throw new AssertionError(var1_1);
            }
        }
    }

    static class DecoupledLoader
    implements FinalizerLoader {
        private static final String LOADING_ERROR = "Could not load Finalizer in its own class loader. Loading Finalizer in the current class loader instead. As a result, you will not be able to garbage collect this class loader. To support reclaiming this class loader, either resolve the underlying issue, or move Guava to your system class path.";

        DecoupledLoader() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> loadFinalizer() {
            try {
                DecoupledLoader decoupledLoader = this;
                URLClassLoader uRLClassLoader = decoupledLoader.newLoader(decoupledLoader.getBaseUrl());
                return uRLClassLoader.loadClass(FinalizableReferenceQueue.FINALIZER_CLASS_NAME);
            }
            catch (Exception e) {
                void var1_2;
                logger.log(Level.WARNING, LOADING_ERROR, (Throwable)var1_2);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        URL getBaseUrl() throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            String finalizerPath = String.valueOf(FinalizableReferenceQueue.FINALIZER_CLASS_NAME.replace('.', '/')).concat(".class");
            URL finalizerUrl = this.getClass().getClassLoader().getResource(finalizerPath);
            if (finalizerUrl == null) {
                throw new FileNotFoundException(finalizerPath);
            }
            String urlString = finalizerUrl.toString();
            if (!urlString.endsWith(finalizerPath)) {
                String string = String.valueOf(urlString);
                throw new IOException(string.length() != 0 ? "Unsupported path style: ".concat(string) : new String("Unsupported path style: "));
            }
            urlString = urlString.substring(0, urlString.length() - var1_1.length());
            return new URL((URL)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        URLClassLoader newLoader(URL base) {
            void var1_1;
            return new URLClassLoader(new URL[]{var1_1}, null);
        }
    }

    static class SystemLoader
    implements FinalizerLoader {
        @VisibleForTesting
        static boolean disabled;

        SystemLoader() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> loadFinalizer() {
            ClassLoader systemLoader;
            if (disabled) {
                return null;
            }
            try {
                systemLoader = ClassLoader.getSystemClassLoader();
            }
            catch (SecurityException securityException) {
                logger.info("Not allowed to access system class loader.");
                return null;
            }
            if (systemLoader != null) {
                try {
                    void var1_1;
                    return var1_1.loadClass(FinalizableReferenceQueue.FINALIZER_CLASS_NAME);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            return null;
        }
    }

    static interface FinalizerLoader {
        public Class<?> loadFinalizer();
    }
}

