/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.FunctionalEquivalence;
import com.google.common.base.Objects;
import com.google.common.base.PairwiseEquivalence;
import com.google.common.base.ParametricNullness;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.function.BiPredicate;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Equivalence<T>
implements BiPredicate<T, T> {
    protected Equivalence() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equivalent(T a, T b) {
        void var2_2;
        void var1_1;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.doEquivalent(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final boolean test(T t, T u) {
        void var2_2;
        void var1_1;
        return this.equivalent(var1_1, var2_2);
    }

    protected abstract boolean doEquivalent(T var1, T var2);

    /*
     * WARNING - void declaration
     */
    public final int hash(T t) {
        void var1_1;
        if (t == null) {
            return 0;
        }
        return this.doHash(var1_1);
    }

    protected abstract int doHash(T var1);

    /*
     * WARNING - void declaration
     */
    public final <F> Equivalence<F> onResultOf(Function<? super F, ? extends T> function) {
        void var1_1;
        return new FunctionalEquivalence(var1_1, this);
    }

    public final <S extends T> Wrapper<S> wrap(@ParametricNullness S reference) {
        Wrapper wrapper;
        wrapper = new Wrapper(this, wrapper);
        return wrapper;
    }

    @GwtCompatible(serializable=true)
    public final <S extends T> Equivalence<Iterable<S>> pairwise() {
        return new PairwiseEquivalence(this);
    }

    /*
     * WARNING - void declaration
     */
    public final Predicate<T> equivalentTo(T target) {
        void var1_1;
        return new EquivalentToPredicate<void>(this, var1_1);
    }

    public static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    static final class Identity
    extends Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        Identity() {
        }

        @Override
        protected final boolean doEquivalent(Object a, Object b) {
            return false;
        }

        @Override
        protected final int doHash(Object o) {
            return System.identityHashCode(o);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class Equals
    extends Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();
        private static final long serialVersionUID = 1L;

        Equals() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final boolean doEquivalent(Object a, Object b) {
            void var2_2;
            return a.equals(var2_2);
        }

        @Override
        protected final int doHash(Object o) {
            return o.hashCode();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EquivalentToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Equivalence<T> equivalence;
        private final T target;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        EquivalentToPredicate(Equivalence<T> equivalence, T target) {
            void var2_2;
            void var1_1;
            this.equivalence = (Equivalence)Preconditions.checkNotNull(var1_1);
            this.target = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(T input) {
            void var1_1;
            return this.equivalence.equivalent(var1_1, (void)this.target);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentToPredicate) {
                void var1_1;
                EquivalentToPredicate that = (EquivalentToPredicate)obj;
                return this.equivalence.equals(that.equivalence) && Objects.equal(this.target, var1_1.target);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode(this.equivalence, this.target);
        }

        public final String toString() {
            String string = String.valueOf(this.equivalence);
            String string2 = String.valueOf(this.target);
            return new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".equivalentTo(").append(string2).append(")").toString();
        }
    }

    public static final class Wrapper<T>
    implements Serializable {
        private final Equivalence<? super T> equivalence;
        @ParametricNullness
        private final T reference;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private Wrapper(Equivalence<? super T> equivalence, @ParametricNullness T reference) {
            void var2_2;
            void var1_1;
            this.equivalence = (Equivalence)Preconditions.checkNotNull(var1_1);
            this.reference = var2_2;
        }

        @ParametricNullness
        public final T get() {
            return this.reference;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Wrapper) {
                Wrapper that = (Wrapper)obj;
                if (this.equivalence.equals(that.equivalence)) {
                    void var1_1;
                    Equivalence<T> equivalence = this.equivalence;
                    return equivalence.equivalent(this.reference, var1_1.reference);
                }
            }
            return false;
        }

        public final int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public final String toString() {
            String string = String.valueOf(this.equivalence);
            String string2 = String.valueOf(this.reference);
            return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".wrap(").append(string2).append(")").toString();
        }
    }
}

