/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Optional;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Enums {
    @GwtIncompatible
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> enumConstantCache = new WeakHashMap();

    private Enums() {
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static Field getField(Enum<?> enumValue) {
        Class<?> clazz = enumValue.getDeclaringClass();
        try {
            void var1_2;
            return var1_2.getDeclaredField(enumValue.name());
        }
        catch (NoSuchFieldException impossible) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Optional<T> getIfPresent(Class<T> enumClass, String value) {
        void var1_1;
        Class<T> clazz;
        Preconditions.checkNotNull(enumClass);
        Preconditions.checkNotNull(value);
        return Platform.getEnumIfPresent(clazz, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> populateCache(Class<T> enumClass) {
        void var1_1;
        Class<T> clazz;
        HashMap<String, WeakReference<void>> result = new HashMap<String, WeakReference<void>>();
        for (Enum enumInstance : EnumSet.allOf(enumClass)) {
            void var3_3;
            result.put(enumInstance.name(), new WeakReference<void>(var3_3));
        }
        enumConstantCache.put(clazz, result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> getEnumConstants(Class<T> enumClass) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = enumConstantCache;
        synchronized (map) {
            void var2_3;
            Map<String, WeakReference<Enum>> constants = enumConstantCache.get(enumClass);
            if (constants == null) {
                Class<T> clazz;
                constants = Enums.populateCache(clazz);
            }
            return var2_3;
        }
    }

    public static <T extends Enum<T>> Converter<String, T> stringConverter(Class<T> enumClass) {
        Class<T> clazz;
        return new StringConverter<T>(clazz);
    }

    private static final class StringConverter<T extends Enum<T>>
    extends Converter<String, T>
    implements Serializable {
        private final Class<T> enumClass;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        StringConverter(Class<T> enumClass) {
            void var1_1;
            this.enumClass = (Class)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final T doForward(String value) {
            void var1_1;
            return Enum.valueOf(this.enumClass, (String)var1_1);
        }

        @Override
        protected final String doBackward(T enumValue) {
            return ((Enum)enumValue).name();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof StringConverter) {
                void var1_1;
                StringConverter that = (StringConverter)object;
                return this.enumClass.equals(var1_1.enumClass);
            }
            return false;
        }

        public final int hashCode() {
            return this.enumClass.hashCode();
        }

        public final String toString() {
            String string = this.enumClass.getName();
            return new StringBuilder(29 + String.valueOf(string).length()).append("Enums.stringConverter(").append(string).append(".class)").toString();
        }
    }
}

