/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Function;
import com.google.common.base.NullnessCasts;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    private transient Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    Converter(boolean handleNullAutomatically) {
        void var1_1;
        this.handleNullAutomatically = var1_1;
    }

    protected abstract B doForward(A var1);

    protected abstract A doBackward(B var1);

    /*
     * WARNING - void declaration
     */
    public final B convert(A a) {
        void var1_1;
        return this.correctedDoForward(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    B correctedDoForward(A a) {
        void var1_1;
        if (this.handleNullAutomatically) {
            if (a == null) {
                return null;
            }
            return Preconditions.checkNotNull(this.doForward(a));
        }
        return this.unsafeDoForward(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    A correctedDoBackward(B b) {
        void var1_1;
        if (this.handleNullAutomatically) {
            if (b == null) {
                return null;
            }
            return Preconditions.checkNotNull(this.doBackward(b));
        }
        return this.unsafeDoBackward(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private B unsafeDoForward(A a) {
        void var1_1;
        return this.doForward(NullnessCasts.uncheckedCastNullableTToT(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private A unsafeDoBackward(B b) {
        void var1_1;
        return this.doBackward(NullnessCasts.uncheckedCastNullableTToT(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<B> convertAll(Iterable<? extends A> fromIterable) {
        void var1_1;
        Preconditions.checkNotNull(fromIterable, "fromIterable");
        return new Iterable<B>(this, (Iterable)var1_1){
            final /* synthetic */ Iterable val$fromIterable;
            final /* synthetic */ Converter this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$fromIterable = iterable;
            }

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(this){
                    private final Iterator<? extends A> fromIterator;
                    final /* synthetic */ 1 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.fromIterator = this.this$1.val$fromIterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fromIterator.hasNext();
                    }

                    @Override
                    public B next() {
                        return this.this$1.this$0.convert(this.fromIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.fromIterator.remove();
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public Converter<B, A> reverse() {
        void var1_1;
        Converter<B, A> result = this.reverse;
        if (result == null) {
            this.reverse = new ReverseConverter(this);
            return this.reverse;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <C> Converter<A, C> andThen(Converter<B, C> secondConverter) {
        void var1_1;
        return this.doAndThen((Converter<B, C>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    <C> Converter<A, C> doAndThen(Converter<B, C> secondConverter) {
        void var1_1;
        return new ConverterComposition(this, (Converter)Preconditions.checkNotNull(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final B apply(A a) {
        void var1_1;
        return this.convert(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return super.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> forwardFunction, Function<? super B, ? extends A> backwardFunction) {
        void var1_1;
        Function<? super A, ? extends B> function;
        return new FunctionBasedConverter(function, (Function)var1_1);
    }

    public static <T> Converter<T, T> identity() {
        return IdentityConverter.INSTANCE;
    }

    private static final class IdentityConverter<T>
    extends Converter<T, T>
    implements Serializable {
        static final IdentityConverter<?> INSTANCE = new IdentityConverter();
        private static final long serialVersionUID = 0L;

        private IdentityConverter() {
        }

        @Override
        protected final T doForward(T t) {
            return t;
        }

        @Override
        protected final T doBackward(T t) {
            return t;
        }

        public final IdentityConverter<T> reverse() {
            return this;
        }

        @Override
        final <S> Converter<T, S> doAndThen(Converter<T, S> otherConverter) {
            return Preconditions.checkNotNull(otherConverter, "otherConverter");
        }

        public final String toString() {
            return "Converter.identity()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class FunctionBasedConverter<A, B>
    extends Converter<A, B>
    implements Serializable {
        private final Function<? super A, ? extends B> forwardFunction;
        private final Function<? super B, ? extends A> backwardFunction;

        /*
         * WARNING - void declaration
         */
        private FunctionBasedConverter(Function<? super A, ? extends B> forwardFunction, Function<? super B, ? extends A> backwardFunction) {
            void var2_2;
            void var1_1;
            this.forwardFunction = (Function)Preconditions.checkNotNull(var1_1);
            this.backwardFunction = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final B doForward(A a) {
            void var1_1;
            return this.forwardFunction.apply(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final A doBackward(B b) {
            void var1_1;
            return this.backwardFunction.apply(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof FunctionBasedConverter) {
                void var1_1;
                FunctionBasedConverter that = (FunctionBasedConverter)object;
                return this.forwardFunction.equals(that.forwardFunction) && this.backwardFunction.equals(var1_1.backwardFunction);
            }
            return false;
        }

        public final int hashCode() {
            return this.forwardFunction.hashCode() * 31 + this.backwardFunction.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.forwardFunction);
            String string2 = String.valueOf(this.backwardFunction);
            return new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Converter.from(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static final class ConverterComposition<A, B, C>
    extends Converter<A, C>
    implements Serializable {
        final Converter<A, B> first;
        final Converter<B, C> second;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ConverterComposition(Converter<A, B> first, Converter<B, C> second) {
            void var2_2;
            void var1_1;
            this.first = var1_1;
            this.second = var2_2;
        }

        @Override
        protected final C doForward(A a) {
            throw new AssertionError();
        }

        @Override
        protected final A doBackward(C c) {
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final C correctedDoForward(A a) {
            void var1_1;
            return this.second.correctedDoForward(this.first.correctedDoForward(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final A correctedDoBackward(C c) {
            void var1_1;
            return this.first.correctedDoBackward(this.second.correctedDoBackward(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof ConverterComposition) {
                void var1_1;
                ConverterComposition that = (ConverterComposition)object;
                return this.first.equals(that.first) && this.second.equals(var1_1.second);
            }
            return false;
        }

        public final int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.first);
            String string2 = String.valueOf(this.second);
            return new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".andThen(").append(string2).append(")").toString();
        }
    }

    private static final class ReverseConverter<A, B>
    extends Converter<B, A>
    implements Serializable {
        final Converter<A, B> original;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ReverseConverter(Converter<A, B> original) {
            void var1_1;
            this.original = var1_1;
        }

        @Override
        protected final A doForward(B b) {
            throw new AssertionError();
        }

        @Override
        protected final B doBackward(A a) {
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final A correctedDoForward(B b) {
            void var1_1;
            return this.original.correctedDoBackward(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final B correctedDoBackward(A a) {
            void var1_1;
            return this.original.correctedDoForward(var1_1);
        }

        @Override
        public final Converter<A, B> reverse() {
            return this.original;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof ReverseConverter) {
                void var1_1;
                ReverseConverter that = (ReverseConverter)object;
                return this.original.equals(var1_1.original);
            }
            return false;
        }

        public final int hashCode() {
            return ~this.original.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.original);
            return new StringBuilder(10 + String.valueOf(string).length()).append(string).append(".reverse()").toString();
        }
    }
}

