/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import java.util.BitSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class CharMatcher
implements Predicate<Character> {
    private static final int DISTINCT_CHARS = 65536;

    public static CharMatcher any() {
        return Any.INSTANCE;
    }

    public static CharMatcher none() {
        return None.INSTANCE;
    }

    public static CharMatcher whitespace() {
        return Whitespace.INSTANCE;
    }

    public static CharMatcher breakingWhitespace() {
        return BreakingWhitespace.INSTANCE;
    }

    public static CharMatcher ascii() {
        return Ascii.INSTANCE;
    }

    @Deprecated
    public static CharMatcher digit() {
        return Digit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaDigit() {
        return JavaDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetter() {
        return JavaLetter.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetterOrDigit() {
        return JavaLetterOrDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaUpperCase() {
        return JavaUpperCase.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLowerCase() {
        return JavaLowerCase.INSTANCE;
    }

    public static CharMatcher javaIsoControl() {
        return JavaIsoControl.INSTANCE;
    }

    @Deprecated
    public static CharMatcher invisible() {
        return Invisible.INSTANCE;
    }

    @Deprecated
    public static CharMatcher singleWidth() {
        return SingleWidth.INSTANCE;
    }

    public static CharMatcher is(char match) {
        char c;
        return new Is(c);
    }

    public static CharMatcher isNot(char match) {
        char c;
        return new IsNot(c);
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        CharSequence charSequence;
        switch (sequence.length()) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither(sequence.charAt(0), sequence.charAt(1));
            }
        }
        return new AnyOf(charSequence);
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf(sequence).negate();
    }

    /*
     * WARNING - void declaration
     */
    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        void var1_1;
        char c;
        return new InRange(c, (char)var1_1);
    }

    public static CharMatcher forPredicate(Predicate<? super Character> predicate) {
        Predicate<? super Character> predicate2;
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        return new ForPredicate(predicate2);
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new Negated(this);
    }

    /*
     * WARNING - void declaration
     */
    public CharMatcher and(CharMatcher other) {
        void var1_1;
        return new And(this, (CharMatcher)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CharMatcher or(CharMatcher other) {
        void var1_1;
        return new Or(this, (CharMatcher)var1_1);
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    CharMatcher precomputedInternal() {
        void var3_3;
        void var1_1;
        void var2_2;
        String string;
        BitSet table = new BitSet();
        this.setBits(table);
        int totalCharacters = table.cardinality();
        if (totalCharacters << 1 <= 65536) {
            return CharMatcher.precomputedPositive(totalCharacters, table, this.toString());
        }
        table.flip(0, 65536);
        int negatedCharacters = 65536 - totalCharacters;
        String suffix = ".negate()";
        final String description = this.toString();
        if (description.endsWith(suffix)) {
            string = description.substring(0, description.length() - suffix.length());
        } else {
            String string2 = String.valueOf(description);
            String string3 = String.valueOf(suffix);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        String negatedDescription = string;
        return new NegatedFastMatcher(this, CharMatcher.precomputedPositive((int)var2_2, (BitSet)var1_1, (String)var3_3)){
            {
                void var2_2;
                super((CharMatcher)var2_2);
            }

            @Override
            public String toString() {
                return description;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static CharMatcher precomputedPositive(int totalCharacters, BitSet table, String description) {
        void var2_3;
        void var1_1;
        int n;
        switch (totalCharacters) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is((char)table.nextSetBit(0));
            }
            case 2: {
                void var1_2;
                int c1 = (char)table.nextSetBit(0);
                char c2 = (char)table.nextSetBit(c1 + 1);
                return CharMatcher.isEither((char)n, (char)var1_2);
            }
        }
        if (CharMatcher.isSmall(n, var1_1.length())) {
            return SmallCharMatcher.from((BitSet)var1_1, description);
        }
        return new BitSetMatcher((BitSet)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static boolean isSmall(int totalCharacters, int tableLength) {
        int n;
        void var1_1;
        return totalCharacters <= 1023 && var1_1 > n << 2 << 4;
    }

    @GwtIncompatible
    void setBits(BitSet table) {
        for (int c = 65535; c >= 0; --c) {
            if (!this.matches((char)c)) continue;
            table.set(c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchesAnyOf(CharSequence sequence) {
        void var1_1;
        return !this.matchesNoneOf((CharSequence)var1_1);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (this.matches(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchesNoneOf(CharSequence sequence) {
        void var1_1;
        return this.indexIn((CharSequence)var1_1) == -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexIn(CharSequence sequence) {
        void var1_1;
        return this.indexIn((CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int indexIn(CharSequence sequence, int start) {
        void i;
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        while (i < length) {
            if (this.matches(sequence.charAt((int)i))) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int countIn(CharSequence sequence) {
        void var2_2;
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String removeFrom(CharSequence sequence) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        while (++pos != chars.length) {
            if (!this.matches(chars[pos])) {
                chars[pos - spread] = chars[pos];
                continue;
            }
            ++spread;
        }
        return new String((char[])var1_1, 0, (int)(var2_2 - var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public String retainFrom(CharSequence sequence) {
        void var1_1;
        return this.negate().removeFrom((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replaceFrom(CharSequence sequence, char replacement) {
        void var1_1;
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] chars = cArray;
        cArray[pos] = replacement;
        for (int i = pos + 1; i < chars.length; ++i) {
            if (!this.matches(chars[i])) continue;
            chars[i] = replacement;
        }
        return new String((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        void var1_1;
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder buf = new StringBuilder(len * 3 / 2 + 16);
        int oldpos = 0;
        do {
            buf.append(string, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn(string, oldpos = pos + 1)) != -1);
        buf.append((CharSequence)var1_1, oldpos, len);
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String trimFrom(CharSequence sequence) {
        void var2_2;
        void var3_3;
        void var1_1;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (int last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return var1_1.subSequence((int)var3_3, (int)(var2_2 + true)).toString();
    }

    public String trimLeadingFrom(CharSequence sequence) {
        int len = sequence.length();
        for (int first = 0; first < len; ++first) {
            if (this.matches(sequence.charAt(first))) continue;
            return sequence.subSequence(first, len).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence sequence) {
        int n = sequence.length();
        for (int last = n - 1; last >= 0; --last) {
            if (this.matches(sequence.charAt(last))) continue;
            return sequence.subSequence(0, last + 1).toString();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String collapseFrom(CharSequence sequence, char replacement) {
        void var1_1;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char c = sequence.charAt(i);
            if (!this.matches(c)) continue;
            if (!(c != replacement || i != len - 1 && this.matches(sequence.charAt(i + 1)))) {
                ++i;
                continue;
            }
            StringBuilder builder = new StringBuilder(len).append(sequence, 0, i).append(replacement);
            return this.finishCollapseFrom(sequence, i + 1, len, replacement, builder, true);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        void var2_2;
        void var1_1;
        void var3_3;
        int first;
        int len = sequence.length();
        int last = len - 1;
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        while (last > first && this.matches(sequence.charAt(last))) {
            --last;
        }
        if (first == 0 && last == var3_3 - true) {
            return this.collapseFrom(sequence, replacement);
        }
        return this.finishCollapseFrom((CharSequence)var1_1, first, last + 1, (char)var2_2, new StringBuilder(last + 1 - first), false);
    }

    private String finishCollapseFrom(CharSequence sequence, int start, int end, char replacement, StringBuilder builder, boolean inMatchingGroup) {
        for (int i = start; i < end; ++i) {
            char c = sequence.charAt(i);
            if (this.matches(c)) {
                if (inMatchingGroup) continue;
                builder.append(replacement);
                inMatchingGroup = true;
                continue;
            }
            builder.append(c);
            inMatchingGroup = false;
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public boolean apply(Character character) {
        void var1_1;
        return this.matches(var1_1.charValue());
    }

    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String showCharacter(char c) {
        void var2_2;
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i = 0; i < 4; ++i) {
            tmp[5 - i] = hex.charAt(c & 0xF);
            c = (char)(c >> 4);
        }
        return String.copyValueOf((char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static IsEither isEither(char c1, char c2) {
        void var1_1;
        char c;
        return new IsEither(c, (char)var1_1);
    }

    private static final class ForPredicate
    extends CharMatcher {
        private final Predicate<? super Character> predicate;

        /*
         * WARNING - void declaration
         */
        ForPredicate(Predicate<? super Character> predicate) {
            void var1_1;
            this.predicate = (Predicate)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.predicate.apply(Character.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(Character character) {
            void var1_1;
            return this.predicate.apply((Character)Preconditions.checkNotNull(var1_1));
        }

        @Override
        public final String toString() {
            String string = String.valueOf(this.predicate);
            return new StringBuilder(26 + String.valueOf(string).length()).append("CharMatcher.forPredicate(").append(string).append(")").toString();
        }
    }

    private static final class InRange
    extends FastMatcher {
        private final char startInclusive;
        private final char endInclusive;

        /*
         * WARNING - void declaration
         */
        InRange(char startInclusive, char endInclusive) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(endInclusive >= startInclusive);
            this.startInclusive = var1_1;
            this.endInclusive = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.startInclusive <= c && var1_1 <= this.endInclusive;
        }

        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            table.set((int)this.startInclusive, this.endInclusive + '\u0001');
        }

        @Override
        public final String toString() {
            String string = CharMatcher.showCharacter(this.startInclusive);
            String string2 = CharMatcher.showCharacter(this.endInclusive);
            return new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.inRange('").append(string).append("', '").append(string2).append("')").toString();
        }
    }

    private static final class AnyOf
    extends CharMatcher {
        private final char[] chars;

        /*
         * WARNING - void declaration
         */
        public AnyOf(CharSequence chars) {
            void var1_1;
            this.chars = var1_1.toString().toCharArray();
            Arrays.sort(this.chars);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return Arrays.binarySearch(this.chars, (char)var1_1) >= 0;
        }

        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            char[] cArray = this.chars;
            int n = this.chars.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                table.set(c);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toString() {
            void var1_1;
            StringBuilder description = new StringBuilder("CharMatcher.anyOf(\"");
            char[] cArray = this.chars;
            int n = this.chars.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                description.append(CharMatcher.showCharacter(c));
            }
            description.append("\")");
            return var1_1.toString();
        }
    }

    private static final class IsEither
    extends FastMatcher {
        private final char match1;
        private final char match2;

        /*
         * WARNING - void declaration
         */
        IsEither(char match1, char match2) {
            void var2_2;
            void var1_1;
            this.match1 = var1_1;
            this.match2 = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return c == this.match1 || var1_1 == this.match2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            void var1_1;
            table.set(this.match1);
            var1_1.set(this.match2);
        }

        @Override
        public final String toString() {
            String string = CharMatcher.showCharacter(this.match1);
            String string2 = CharMatcher.showCharacter(this.match2);
            return new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.anyOf(\"").append(string).append(string2).append("\")").toString();
        }
    }

    private static final class IsNot
    extends FastMatcher {
        private final char match;

        /*
         * WARNING - void declaration
         */
        IsNot(char match) {
            void var1_1;
            this.match = var1_1;
        }

        @Override
        public final boolean matches(char c) {
            return c != this.match;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharMatcher and(CharMatcher other) {
            void var1_1;
            if (other.matches(this.match)) {
                return super.and(other);
            }
            return var1_1;
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            if (other.matches(this.match)) {
                return IsNot.any();
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            void var1_1;
            table.set(0, this.match);
            var1_1.set(this.match + '\u0001', 65536);
        }

        @Override
        public final CharMatcher negate() {
            return IsNot.is(this.match);
        }

        @Override
        public final String toString() {
            String string = CharMatcher.showCharacter(this.match);
            return new StringBuilder(21 + String.valueOf(string).length()).append("CharMatcher.isNot('").append(string).append("')").toString();
        }
    }

    private static final class Is
    extends FastMatcher {
        private final char match;

        /*
         * WARNING - void declaration
         */
        Is(char match) {
            void var1_1;
            this.match = var1_1;
        }

        @Override
        public final boolean matches(char c) {
            return c == this.match;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String replaceFrom(CharSequence sequence, char replacement) {
            void var2_2;
            return sequence.toString().replace(this.match, (char)var2_2);
        }

        @Override
        public final CharMatcher and(CharMatcher other) {
            if (other.matches(this.match)) {
                return this;
            }
            return Is.none();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharMatcher or(CharMatcher other) {
            void var1_1;
            if (other.matches(this.match)) {
                return other;
            }
            return super.or((CharMatcher)var1_1);
        }

        @Override
        public final CharMatcher negate() {
            return Is.isNot(this.match);
        }

        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            table.set(this.match);
        }

        @Override
        public final String toString() {
            String string = CharMatcher.showCharacter(this.match);
            return new StringBuilder(18 + String.valueOf(string).length()).append("CharMatcher.is('").append(string).append("')").toString();
        }
    }

    private static final class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        /*
         * WARNING - void declaration
         */
        Or(CharMatcher a, CharMatcher b) {
            void var2_2;
            void var1_1;
            this.first = (CharMatcher)Preconditions.checkNotNull(var1_1);
            this.second = (CharMatcher)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            void var1_1;
            this.first.setBits(table);
            this.second.setBits((BitSet)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.first.matches(c) || this.second.matches((char)var1_1);
        }

        @Override
        public final String toString() {
            String string = String.valueOf(this.first);
            String string2 = String.valueOf(this.second);
            return new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.or(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static final class And
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        /*
         * WARNING - void declaration
         */
        And(CharMatcher a, CharMatcher b) {
            void var2_2;
            void var1_1;
            this.first = (CharMatcher)Preconditions.checkNotNull(var1_1);
            this.second = (CharMatcher)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.first.matches(c) && this.second.matches((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            void var2_2;
            void var1_1;
            void var3_3;
            BitSet tmp1 = new BitSet();
            this.first.setBits(tmp1);
            BitSet tmp2 = new BitSet();
            this.second.setBits(tmp2);
            tmp1.and((BitSet)var3_3);
            var1_1.or((BitSet)var2_2);
        }

        @Override
        public final String toString() {
            String string = String.valueOf(this.first);
            String string2 = String.valueOf(this.second);
            return new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.and(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static class Negated
    extends CharMatcher {
        final CharMatcher original;

        /*
         * WARNING - void declaration
         */
        Negated(CharMatcher original) {
            void var1_1;
            this.original = (CharMatcher)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(char c) {
            void var1_1;
            return !this.original.matches((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matchesAllOf(CharSequence sequence) {
            void var1_1;
            return this.original.matchesNoneOf((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matchesNoneOf(CharSequence sequence) {
            void var1_1;
            return this.original.matchesAllOf((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int countIn(CharSequence sequence) {
            void var1_1;
            return sequence.length() - this.original.countIn((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        void setBits(BitSet table) {
            void var2_2;
            void var1_1;
            BitSet tmp = new BitSet();
            this.original.setBits(tmp);
            tmp.flip(0, 65536);
            var1_1.or((BitSet)var2_2);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        public String toString() {
            String string = String.valueOf(this.original);
            return new StringBuilder(9 + String.valueOf(string).length()).append(string).append(".negate()").toString();
        }
    }

    private static final class SingleWidth
    extends RangesMatcher {
        static final SingleWidth INSTANCE = new SingleWidth();

        private SingleWidth() {
            super("CharMatcher.singleWidth()", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        }
    }

    private static final class Invisible
    extends RangesMatcher {
        private static final String RANGE_STARTS = "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u0890\u08e2\u1680\u180e\u2000\u2028\u205f\u2066\u3000\ud800\ufeff\ufff9";
        private static final String RANGE_ENDS = " \u00a0\u00ad\u0605\u061c\u06dd\u070f\u0891\u08e2\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufffb";
        static final Invisible INSTANCE = new Invisible();

        private Invisible() {
            super("CharMatcher.invisible()", RANGE_STARTS.toCharArray(), RANGE_ENDS.toCharArray());
        }
    }

    private static final class JavaIsoControl
    extends NamedFastMatcher {
        static final JavaIsoControl INSTANCE = new JavaIsoControl();

        private JavaIsoControl() {
            super("CharMatcher.javaIsoControl()");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return c <= '\u001f' || c >= '\u007f' && var1_1 <= 159;
        }
    }

    private static final class JavaLowerCase
    extends CharMatcher {
        static final JavaLowerCase INSTANCE = new JavaLowerCase();

        private JavaLowerCase() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isLowerCase(c);
        }

        @Override
        public final String toString() {
            return "CharMatcher.javaLowerCase()";
        }
    }

    private static final class JavaUpperCase
    extends CharMatcher {
        static final JavaUpperCase INSTANCE = new JavaUpperCase();

        private JavaUpperCase() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isUpperCase(c);
        }

        @Override
        public final String toString() {
            return "CharMatcher.javaUpperCase()";
        }
    }

    private static final class JavaLetterOrDigit
    extends CharMatcher {
        static final JavaLetterOrDigit INSTANCE = new JavaLetterOrDigit();

        private JavaLetterOrDigit() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isLetterOrDigit(c);
        }

        @Override
        public final String toString() {
            return "CharMatcher.javaLetterOrDigit()";
        }
    }

    private static final class JavaLetter
    extends CharMatcher {
        static final JavaLetter INSTANCE = new JavaLetter();

        private JavaLetter() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isLetter(c);
        }

        @Override
        public final String toString() {
            return "CharMatcher.javaLetter()";
        }
    }

    private static final class JavaDigit
    extends CharMatcher {
        static final JavaDigit INSTANCE = new JavaDigit();

        private JavaDigit() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isDigit(c);
        }

        @Override
        public final String toString() {
            return "CharMatcher.javaDigit()";
        }
    }

    private static final class Digit
    extends RangesMatcher {
        private static final String ZEROES = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10";
        static final Digit INSTANCE = new Digit();

        private static char[] zeroes() {
            return ZEROES.toCharArray();
        }

        /*
         * WARNING - void declaration
         */
        private static char[] nines() {
            void var0;
            char[] nines = new char[37];
            for (int i = 0; i < 37; ++i) {
                nines[i] = (char)(ZEROES.charAt(i) + 9);
            }
            return var0;
        }

        private Digit() {
            super("CharMatcher.digit()", Digit.zeroes(), Digit.nines());
        }
    }

    private static class RangesMatcher
    extends CharMatcher {
        private final String description;
        private final char[] rangeStarts;
        private final char[] rangeEnds;

        RangesMatcher(String description, char[] rangeStarts, char[] rangeEnds) {
            this.description = description;
            this.rangeStarts = rangeStarts;
            this.rangeEnds = rangeEnds;
            Preconditions.checkArgument(rangeStarts.length == rangeEnds.length);
            for (int i = 0; i < rangeStarts.length; ++i) {
                Preconditions.checkArgument(rangeStarts[i] <= rangeEnds[i]);
                if (i + 1 >= rangeStarts.length) continue;
                Preconditions.checkArgument(rangeEnds[i] < rangeStarts[i + 1]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(char c) {
            void var2_2;
            void var1_1;
            int index = Arrays.binarySearch(this.rangeStarts, c);
            if (index >= 0) {
                return true;
            }
            return (index = ~index - 1) >= 0 && var1_1 <= this.rangeEnds[var2_2];
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static final class Ascii
    extends NamedFastMatcher {
        static final Ascii INSTANCE = new Ascii();

        Ascii() {
            super("CharMatcher.ascii()");
        }

        @Override
        public final boolean matches(char c) {
            return c <= '\u007f';
        }
    }

    private static final class BreakingWhitespace
    extends CharMatcher {
        static final CharMatcher INSTANCE = new BreakingWhitespace();

        private BreakingWhitespace() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c >= '\u2000' && var1_1 <= 8202;
        }

        @Override
        public final String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    @VisibleForTesting
    static final class Whitespace
    extends NamedFastMatcher {
        static final String TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
        static final int MULTIPLIER = 1682554634;
        static final int SHIFT = Integer.numberOfLeadingZeros(32 - 1);
        static final Whitespace INSTANCE = new Whitespace();

        Whitespace() {
            super("CharMatcher.whitespace()");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return TABLE.charAt(c * 1682554634 >>> SHIFT) == var1_1;
        }

        @Override
        @GwtIncompatible
        final void setBits(BitSet table) {
            for (int i = 0; i < 32; ++i) {
                table.set(TABLE.charAt(i));
            }
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final None INSTANCE = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public final boolean matches(char c) {
            return false;
        }

        @Override
        public final int indexIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexIn(CharSequence sequence, int start) {
            void var1_2;
            void var2_3;
            int length = sequence.length();
            Preconditions.checkPositionIndex((int)var2_3, (int)var1_2);
            return -1;
        }

        @Override
        public final int lastIndexIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return -1;
        }

        @Override
        public final boolean matchesAllOf(CharSequence sequence) {
            return sequence.length() == 0;
        }

        @Override
        public final boolean matchesNoneOf(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return true;
        }

        @Override
        public final String removeFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final String replaceFrom(CharSequence sequence, char replacement) {
            return sequence.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String replaceFrom(CharSequence sequence, CharSequence replacement) {
            void var1_1;
            Preconditions.checkNotNull(replacement);
            return var1_1.toString();
        }

        @Override
        public final String collapseFrom(CharSequence sequence, char replacement) {
            return sequence.toString();
        }

        @Override
        public final String trimFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final String trimLeadingFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final String trimTrailingFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final int countIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return 0;
        }

        @Override
        public final CharMatcher and(CharMatcher other) {
            Preconditions.checkNotNull(other);
            return this;
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            return Preconditions.checkNotNull(other);
        }

        @Override
        public final CharMatcher negate() {
            return None.any();
        }
    }

    private static final class Any
    extends NamedFastMatcher {
        static final Any INSTANCE = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public final boolean matches(char c) {
            return true;
        }

        @Override
        public final int indexIn(CharSequence sequence) {
            if (sequence.length() == 0) {
                return -1;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexIn(CharSequence sequence, int start) {
            void var2_3;
            void var1_2;
            int length = sequence.length();
            Preconditions.checkPositionIndex(start, length);
            if (start == var1_2) {
                return -1;
            }
            return (int)var2_3;
        }

        @Override
        public final int lastIndexIn(CharSequence sequence) {
            return sequence.length() - 1;
        }

        @Override
        public final boolean matchesAllOf(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return true;
        }

        @Override
        public final boolean matchesNoneOf(CharSequence sequence) {
            return sequence.length() == 0;
        }

        @Override
        public final String removeFrom(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return "";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String replaceFrom(CharSequence sequence, char replacement) {
            void var1_1;
            void var2_2;
            char[] array = new char[sequence.length()];
            Arrays.fill(array, (char)var2_2);
            return new String((char[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String replaceFrom(CharSequence sequence, CharSequence replacement) {
            void var3_3;
            StringBuilder result = new StringBuilder(sequence.length() * replacement.length());
            for (int i = 0; i < sequence.length(); ++i) {
                result.append(replacement);
            }
            return var3_3.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String collapseFrom(CharSequence sequence, char replacement) {
            void var2_2;
            if (sequence.length() == 0) {
                return "";
            }
            return String.valueOf((char)var2_2);
        }

        @Override
        public final String trimFrom(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return "";
        }

        @Override
        public final int countIn(CharSequence sequence) {
            return sequence.length();
        }

        @Override
        public final CharMatcher and(CharMatcher other) {
            return Preconditions.checkNotNull(other);
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            Preconditions.checkNotNull(other);
            return this;
        }

        @Override
        public final CharMatcher negate() {
            return Any.none();
        }
    }

    @GwtIncompatible
    private static final class BitSetMatcher
    extends NamedFastMatcher {
        private final BitSet table;

        /*
         * WARNING - void declaration
         */
        private BitSetMatcher(BitSet table, String description) {
            super((String)var2_2);
            void var1_1;
            void var2_2;
            if (table.length() + 64 < table.size()) {
                table = (BitSet)table.clone();
            }
            this.table = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.table.get((int)var1_1);
        }

        @Override
        final void setBits(BitSet bitSet) {
            bitSet.or(this.table);
        }
    }

    static class NegatedFastMatcher
    extends Negated {
        /*
         * WARNING - void declaration
         */
        NegatedFastMatcher(CharMatcher original) {
            super((CharMatcher)var1_1);
            void var1_1;
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        /*
         * WARNING - void declaration
         */
        NamedFastMatcher(String description) {
            void var1_1;
            this.description = (String)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }
}

