/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String convert(CaseFormat format, String s) {
            void var2_2;
            void var1_1;
            if (format == LOWER_UNDERSCORE) {
                return s.replace('-', '_');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s.replace('-', '_'));
            }
            return super.convert((CaseFormat)var1_1, (String)var2_2);
        }
    }
    ,
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String convert(CaseFormat format, String s) {
            void var2_2;
            void var1_1;
            if (format == LOWER_HYPHEN) {
                return s.replace('_', '-');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s);
            }
            return super.convert((CaseFormat)var1_1, (String)var2_2);
        }
    }
    ,
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }

        @Override
        final String normalizeFirstWord(String word) {
            return Ascii.toLowerCase(word);
        }
    }
    ,
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }
    }
    ,
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_"){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return Ascii.toUpperCase(word);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String convert(CaseFormat format, String s) {
            void var2_2;
            void var1_1;
            if (format == LOWER_HYPHEN) {
                return Ascii.toLowerCase(s.replace('_', '-'));
            }
            if (format == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase(s);
            }
            return super.convert((CaseFormat)var1_1, (String)var2_2);
        }
    };

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    /*
     * WARNING - void declaration
     */
    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        void var3_3;
        this.wordBoundary = var3_3;
        this.wordSeparator = wordSeparator;
    }

    /*
     * WARNING - void declaration
     */
    public final String to(CaseFormat format, String str) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(str);
        if (format == this) {
            return str;
        }
        return this.convert((CaseFormat)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    String convert(CaseFormat format, String s) {
        void var2_2;
        void var1_1;
        void var3_3;
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = this.wordBoundary.indexIn(s, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s.length() + 4 * format.wordSeparator.length());
                out.append(format.normalizeFirstWord(s.substring(i, j)));
            } else {
                ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s.substring(i, j)));
            }
            out.append(format.wordSeparator);
            i = j + this.wordSeparator.length();
        }
        if (i == 0) {
            return format.normalizeFirstWord(s);
        }
        return ((StringBuilder)Objects.requireNonNull(var3_3)).append(var1_1.normalizeWord(var2_2.substring(i))).toString();
    }

    /*
     * WARNING - void declaration
     */
    public Converter<String, String> converterTo(CaseFormat targetFormat) {
        void var1_1;
        return new StringConverter(this, (CaseFormat)var1_1);
    }

    abstract String normalizeWord(String var1);

    /*
     * WARNING - void declaration
     */
    String normalizeFirstWord(String word) {
        void var1_1;
        return this.normalizeWord((String)var1_1);
    }

    private static String firstCharOnlyToUpper(String word) {
        String string;
        if (word.isEmpty()) {
            return word;
        }
        char c = Ascii.toUpperCase(word.charAt(0));
        string = Ascii.toLowerCase(string.substring(1));
        return new StringBuilder(1 + String.valueOf(string).length()).append(c).append(string).toString();
    }

    private static final class StringConverter
    extends Converter<String, String>
    implements Serializable {
        private final CaseFormat sourceFormat;
        private final CaseFormat targetFormat;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        StringConverter(CaseFormat sourceFormat, CaseFormat targetFormat) {
            void var2_2;
            void var1_1;
            this.sourceFormat = (CaseFormat)Preconditions.checkNotNull(var1_1);
            this.targetFormat = (CaseFormat)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String doForward(String s) {
            void var1_1;
            return this.sourceFormat.to(this.targetFormat, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String doBackward(String s) {
            void var1_1;
            return this.targetFormat.to(this.sourceFormat, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof StringConverter) {
                void var1_1;
                StringConverter that = (StringConverter)object;
                return this.sourceFormat.equals((Object)that.sourceFormat) && this.targetFormat.equals((Object)var1_1.targetFormat);
            }
            return false;
        }

        public final int hashCode() {
            return this.sourceFormat.hashCode() ^ this.targetFormat.hashCode();
        }

        public final String toString() {
            String string = String.valueOf((Object)this.sourceFormat);
            String string2 = String.valueOf((Object)this.targetFormat);
            return new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".converterTo(").append(string2).append(")").toString();
        }
    }
}

