/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0011\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\fH\u0082 J)\u0010$\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\t\u0010&\u001a\u00020\fH\u0082 J(\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\fH\u0014J\u0019\u0010)\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010*\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\fH\u0082 R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/skiko/swing/LinuxOpenGLSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "bytesToDraw", "", "offScreenBufferPtr", "", "offScreenContextPtr", "storage", "Lorg/jetbrains/skia/Bitmap;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "createAndBindTexture", "width", "", "height", "dispose", "", "disposeOffScreenBuffer", "bufferPtr", "disposeOffScreenContext", "contextPtr", "finishRendering", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "getFboId", "texturePtr", "makeOffScreenBuffer", "oldBufferPtr", "makeOffScreenContext", "onRender", "nanoTime", "startRendering", "unbindAndDisposeTexture", "skiko"})
public final class LinuxOpenGLSwingRedrawer
extends SwingRedrawerBase {
    private final SkikoRenderDelegate renderDelegate;
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    private final long offScreenContextPtr;
    private long offScreenBufferPtr;
    private final Bitmap storage;
    private byte[] bytesToDraw;

    /*
     * WARNING - void declaration
     */
    public LinuxOpenGLSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate renderDelegate, SkiaLayerAnalytics analytics) {
        void it;
        long l;
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, (SkiaLayerAnalytics)var3_3, GraphicsApi.OPENGL);
        this.renderDelegate = var2_2;
        this.onDeviceChosen("OpenGL OffScreen");
        this.swingOffscreenDrawer = new SwingOffscreenDrawer((SwingLayerProperties)((Object)linuxOpenGLSwingRedrawer));
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
        long l2 = l = linuxOpenGLSwingRedrawer2.makeOffScreenContext();
        linuxOpenGLSwingRedrawer = linuxOpenGLSwingRedrawer2;
        if (it == 0L) {
            throw new RenderException("Cannot create OpenGL context", null, 2, null);
        }
        linuxOpenGLSwingRedrawer.offScreenContextPtr = l;
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.disposeOffScreenBuffer(linuxOpenGLSwingRedrawer.offScreenBufferPtr);
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
        linuxOpenGLSwingRedrawer2.disposeOffScreenContext(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void onRender(Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.offScreenBufferPtr = this.makeOffScreenBuffer(this.offScreenContextPtr, this.offScreenBufferPtr, width2, height2);
        if (this.offScreenBufferPtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL buffer", null, 2, null);
        }
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.startRendering(linuxOpenGLSwingRedrawer.offScreenContextPtr, this.offScreenBufferPtr);
        try {
            void var1_1;
            void var3_4;
            void var2_3;
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, (int)var2_3, (int)var3_4, nanoTime, (Graphics2D)var1_1){
                final /* synthetic */ LinuxOpenGLSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$width = var2_2;
                    this.$height = var3_3;
                    this.$nanoTime = $nanoTime;
                    this.$g = $g;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(CloseScope $this$autoCloseScope) {
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                    long texturePtr = LinuxOpenGLSwingRedrawer.access$createAndBindTexture(this.this$0, this.$width, this.$height);
                    if (texturePtr == 0L) {
                        throw new RenderException("Cannot create offScreen OpenGL texture", null, 2, null);
                    }
                    int fbId = LinuxOpenGLSwingRedrawer.access$getFboId(this.this$0, texturePtr);
                    Managed renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLRenderTarget(this.$width, this.$height, 0, 8, fbId, 32856));
                    DirectContext directContext = (DirectContext)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLContext());
                    renderTarget = Surface.Companion.makeFromBackendRenderTarget(directContext, (BackendRenderTarget)renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (renderTarget == null || ($this$autoCloseScope = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)renderTarget)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    Object surface = $this$autoCloseScope;
                    Canvas canvas = ((Surface)surface).getCanvas();
                    canvas.clear(0);
                    LinuxOpenGLSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                    LinuxOpenGLSwingRedrawer.access$flush(this.this$0, (Surface)var1_1, this.$g);
                    LinuxOpenGLSwingRedrawer.access$unbindAndDisposeTexture(this.this$0, (long)var2_2);
                }
            }));
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
            linuxOpenGLSwingRedrawer2.finishRendering(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
            return;
        }
        catch (Throwable throwable) {
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer3 = this;
            linuxOpenGLSwingRedrawer3.finishRendering(linuxOpenGLSwingRedrawer3.offScreenContextPtr);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void flush(Surface surface, Graphics2D g) {
        void var1_1;
        surface.flushAndSubmit(true);
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        int dstRowBytes = width2 << 2;
        if (this.storage.getWidth() != width2 || this.storage.getHeight() != height2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, dstRowBytes, 0, 5, null)];
        }
        var1_1.readPixels(this.storage, 0, 0);
        boolean bl = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, dstRowBytes, 0, 0, 26, null);
        if (bl) {
            void var3_4;
            void var2_3;
            this.swingOffscreenDrawer.draw((Graphics2D)var2_3, this.bytesToDraw, (int)var3_4, height2);
        }
    }

    private final native long makeOffScreenContext();

    private final native long disposeOffScreenContext(long var1);

    private final native long makeOffScreenBuffer(long var1, long var3, int var5, int var6);

    private final native void disposeOffScreenBuffer(long var1);

    private final native void startRendering(long var1, long var3);

    private final native void finishRendering(long var1);

    private final native long createAndBindTexture(int var1, int var2);

    private final native int getFboId(long var1);

    private final native void unbindAndDisposeTexture(long var1);

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$createAndBindTexture(LinuxOpenGLSwingRedrawer $this, int width2, int height2) {
        void var2_2;
        void var1_1;
        return $this.createAndBindTexture((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$getFboId(LinuxOpenGLSwingRedrawer $this, long texturePtr) {
        void var1_1;
        return $this.getFboId((long)var1_1);
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(LinuxOpenGLSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$flush(LinuxOpenGLSwingRedrawer $this, Surface surface, Graphics2D g) {
        void var2_2;
        void var1_1;
        $this.flush((Surface)var1_1, (Graphics2D)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$unbindAndDisposeTexture(LinuxOpenGLSwingRedrawer $this, long texturePtr) {
        void var1_1;
        $this.unbindAndDisposeTexture((long)var1_1);
    }
}

