/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OpenGLApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/skiko/context/OpenGLContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "currentHeight", "", "currentWidth", "initCanvas", "", "initContext", "", "isSizeChanged", "width", "height", "rendererInfo", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nOpenGLContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenGLContextHandler.kt\norg/jetbrains/skiko/context/OpenGLContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,71:1\n124#2,4:72\n159#2,4:76\n*S KotlinDebug\n*F\n+ 1 OpenGLContextHandler.kt\norg/jetbrains/skiko/context/OpenGLContextHandler\n*L\n12#1:72,4\n16#1:76,4\n*E\n"})
public final class OpenGLContextHandler
extends JvmContextHandler {
    private int currentWidth;
    private int currentHeight;

    /*
     * WARNING - void declaration
     */
    public OpenGLContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object this_$iv;
                this.setContext(RenderTargetsKt.makeGLContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(this_$iv = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    this_$iv = ((Logger)this_$iv).getLoggerImpl();
                    this_$iv.info("Renderer info:\n " + ((ContextHandler)this).rendererInfo());
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                void var1_2;
                Throwable throwable;
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                throwable = (Throwable)var1_2;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia OpenGL context!";
                skikoLoggerInterface2.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            void var2_2;
            void var1_1;
            this.currentWidth = var1_1;
            this.currentHeight = var2_2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        int h;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            void var3_5;
            void var1_2;
            void var2_3;
            this.disposeCanvas();
            OpenGLApi gl = OpenGLApi.Companion.getInstance();
            int fbId = gl.glGetIntegerv(gl.getGL_DRAW_FRAMEBUFFER_BINDING());
            this.setRenderTarget(RenderTargetsKt.makeGLRenderTarget((int)var2_3, (int)var1_2, 0, 8, (int)var3_5, 32856));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
        }
        OpenGLContextHandler openGLContextHandler = this;
        Surface surface = openGLContextHandler.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        openGLContextHandler.setCanvas(surface.getCanvas());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String rendererInfo() {
        void var1_1;
        OpenGLApi gl;
        OpenGLApi openGLApi = gl = OpenGLApi.Companion.getInstance();
        OpenGLApi openGLApi2 = gl;
        void v2 = var1_1;
        return super.rendererInfo() + "Vendor: " + openGLApi.glGetString(openGLApi.getGL_VENDOR()) + "\nModel: " + openGLApi2.glGetString(openGLApi2.getGL_RENDERER()) + "\nTotal VRAM: " + v2.glGetIntegerv(v2.getGL_TOTAL_MEMORY()) / 1024 + " MB\n";
    }
}

