/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\fH\u0082 J\b\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\fH\u0082 J!\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0082 J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "device", "Lorg/jetbrains/skiko/redrawer/MetalDevice;", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "(Lorg/jetbrains/skiko/SkiaLayer;JLorg/jetbrains/skiko/MetalAdapter;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "finishFrame", "", "", "flush", "initCanvas", "initContext", "", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "makeMetalContext", "makeMetalRenderTarget", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "rendererInfo", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nMetalContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalContextHandler.kt\norg/jetbrains/skiko/context/MetalContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,91:1\n124#2,4:92\n159#2,4:96\n*S KotlinDebug\n*F\n+ 1 MetalContextHandler.kt\norg/jetbrains/skiko/context/MetalContextHandler\n*L\n28#1:92,4\n32#1:96,4\n*E\n"})
public final class MetalContextHandler
extends JvmContextHandler {
    private final long device;
    private final MetalAdapter adapter;

    /*
     * WARNING - void declaration
     */
    private MetalContextHandler(SkiaLayer layer, long device2, MetalAdapter adapter) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super((SkiaLayer)var1_1);
        this.device = var2_2;
        this.adapter = adapter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object this_$iv;
                MetalContextHandler metalContextHandler = this;
                metalContextHandler.setContext(metalContextHandler.makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(this_$iv = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    this_$iv = ((Logger)this_$iv).getLoggerImpl();
                    this_$iv.info("Renderer info:\n " + ((ContextHandler)this).rendererInfo());
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                void var1_2;
                Throwable throwable;
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                throwable = (Throwable)var1_2;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia Metal context!";
                skikoLoggerInterface2.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int width2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getWidth() * scale)), (int)0);
        int height2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getHeight() * scale)), (int)0);
        if (width2 > 0 && height2 > 0) {
            void var1_2;
            void var2_3;
            MetalContextHandler metalContextHandler = this;
            metalContextHandler.setRenderTarget(metalContextHandler.makeRenderTarget((int)var2_3, (int)var1_2));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
            MetalContextHandler metalContextHandler2 = this;
            Surface surface2 = metalContextHandler2.getSurface();
            Intrinsics.checkNotNull((Object)surface2);
            metalContextHandler2.setCanvas(surface2.getCanvas());
            return;
        }
        this.setRenderTarget(null);
        this.setSurface(null);
        this.setCanvas(null);
    }

    @Override
    protected final void flush() {
        super.flush();
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.flushAndSubmit();
        }
        this.finishFrame();
    }

    @Override
    public final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / 1024L / 1024L + " MB\n";
    }

    /*
     * WARNING - void declaration
     */
    private final BackendRenderTarget makeRenderTarget(int width2, int height2) {
        void var2_2;
        void var1_1;
        MetalContextHandler metalContextHandler = this;
        return new BackendRenderTarget(metalContextHandler.makeMetalRenderTarget(metalContextHandler.device, (int)var1_1, (int)var2_2));
    }

    private final DirectContext makeContext() {
        MetalContextHandler metalContextHandler = this;
        return new DirectContext(metalContextHandler.makeMetalContext(metalContextHandler.device));
    }

    private final void finishFrame() {
        MetalContextHandler metalContextHandler = this;
        metalContextHandler.finishFrame(metalContextHandler.device);
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTarget(long var1, int var3, int var4);

    private final native void finishFrame(long var1);

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ MetalContextHandler(SkiaLayer layer, long device2, MetalAdapter adapter, DefaultConstructorMarker $constructor_marker) {
        this((SkiaLayer)var1_1, (long)var2_2, adapter);
        void var2_2;
        void var1_1;
    }
}

