/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.AbstractDirectSoftwareRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\tH\u0014J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skiko/context/DirectSoftwareContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "currentHeight", "", "currentWidth", "isInited", "", "()Z", "setInited", "(Z)V", "softwareRedrawer", "Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "getSoftwareRedrawer", "()Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "flush", "", "initCanvas", "initContext", "isSizeChanged", "width", "height", "skiko"})
@SourceDebugExtension(value={"SMAP\nDirectSoftwareContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectSoftwareContextHandler.kt\norg/jetbrains/skiko/context/DirectSoftwareContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,63:1\n124#2,4:64\n*S KotlinDebug\n*F\n+ 1 DirectSoftwareContextHandler.kt\norg/jetbrains/skiko/context/DirectSoftwareContextHandler\n*L\n29#1:64,4\n*E\n"})
public final class DirectSoftwareContextHandler
extends JvmContextHandler {
    private boolean isInited;
    private int currentWidth;
    private int currentHeight;

    /*
     * WARNING - void declaration
     */
    public DirectSoftwareContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
    }

    public final boolean isInited() {
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    public final void setInited(boolean bl) {
        void var1_1;
        this.isInited = var1_1;
    }

    private final AbstractDirectSoftwareRedrawer getSoftwareRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AbstractDirectSoftwareRedrawer)redrawer;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            void var2_2;
            void var1_1;
            this.currentWidth = var1_1;
            this.currentHeight = var2_2;
            return true;
        }
        return false;
    }

    @Override
    protected final boolean initContext() {
        if (!this.isInited) {
            Logger this_$iv;
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && (this_$iv = Logger.INSTANCE).getLoggerImpl().isInfoEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface;
                skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
                skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
            }
            this.isInited = true;
        }
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        int h;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            if (w > 0 && h > 0) {
                void var1_2;
                void var2_3;
                this.getSoftwareRedrawer().resize((int)var2_3, (int)var1_2);
                DirectSoftwareContextHandler directSoftwareContextHandler = this;
                directSoftwareContextHandler.setSurface(directSoftwareContextHandler.getSoftwareRedrawer().acquireSurface());
                DirectSoftwareContextHandler directSoftwareContextHandler2 = this;
                Surface surface = directSoftwareContextHandler2.getSurface();
                Intrinsics.checkNotNull((Object)surface);
                directSoftwareContextHandler2.setCanvas(surface.getCanvas());
                return;
            }
            this.setSurface(null);
            this.setCanvas(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void flush() {
        Surface surface = this.getSurface();
        if (surface != null) {
            try {
                this.getSoftwareRedrawer().finishFrame(NativeKt.getPtr(surface));
            }
            catch (Throwable throwable) {
                void var1_1;
                Reference.reachabilityFence(var1_1);
                throw throwable;
            }
            Reference.reachabilityFence(surface);
            return;
        }
    }
}

