/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/skia/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "isEmpty", "", "()Z", "getLeft", "getRight", "getTop", "width", "getWidth", "equals", "other", "hashCode", "", "inflate", "spread", "intersect", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/Point;", "scale", "sx", "sy", "serializeToFloatArray", "", "serializeToFloatArray$skiko", "toIRect", "Lorg/jetbrains/skia/IRect;", "toString", "", "Companion", "skiko"})
public class Rect {
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    /*
     * WARNING - void declaration
     */
    public Rect(float left, float top, float right, float bottom) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.left = var1_1;
        this.top = var2_2;
        this.right = var3_3;
        this.bottom = bottom;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    /*
     * WARNING - void declaration
     */
    public final Rect intersect(Rect other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.right <= other.left || other.right <= this.left || this.bottom <= other.top || other.bottom <= this.top) {
            return null;
        }
        return new Rect(Math.max(this.left, other.left), Math.max(this.top, other.top), Math.min(this.right, other.right), Math.min(this.bottom, var1_1.bottom));
    }

    /*
     * WARNING - void declaration
     */
    public final Rect scale(float scale) {
        void var1_1;
        void v0 = var1_1;
        return this.scale((float)v0, (float)v0);
    }

    /*
     * WARNING - void declaration
     */
    public final Rect scale(float sx, float sy) {
        void var2_2;
        void var1_1;
        return new Rect(this.left * sx, this.top * sy, this.right * var1_1, this.bottom * var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Rect offset(float dx, float dy) {
        void var2_2;
        void var1_1;
        return new Rect(this.left + dx, this.top + dy, this.right + var1_1, this.bottom + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Rect offset(Point vec) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return this.offset(vec.getX(), var1_1.getY());
    }

    public final IRect toIRect() {
        return new IRect((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
    }

    /*
     * WARNING - void declaration
     */
    public Rect inflate(float spread) {
        void var1_1;
        if (spread <= 0.0f) {
            return Companion.makeLTRB(this.left - spread, this.top - spread, Math.max(this.left - spread, this.right + spread), Math.max(this.top - spread, this.bottom + spread));
        }
        return RRect.Companion.makeLTRB(this.left - spread, this.top - spread, Math.max(this.left - spread, this.right + spread), Math.max(this.top - spread, this.bottom + spread), (float)var1_1);
    }

    public final float[] serializeToFloatArray$skiko() {
        float[] fArray = new float[4];
        float[] fArray2 = fArray;
        fArray[0] = this.left;
        fArray2[1] = this.top;
        fArray2[2] = this.right;
        fArray2[3] = this.bottom;
        return fArray2;
    }

    public final boolean isEmpty() {
        return this.right == this.left || this.top == this.bottom;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        if (Float.compare(this.left, ((Rect)other).left) != 0) {
            return false;
        }
        if (Float.compare(this.top, ((Rect)other).top) != 0) {
            return false;
        }
        if (Float.compare(this.right, ((Rect)other).right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((Rect)var1_1).bottom) == 0;
    }

    public int hashCode() {
        int n = 59 + Float.floatToIntBits(this.left);
        n = n * 59 + Float.floatToIntBits(this.top);
        n = n * 59 + Float.floatToIntBits(this.right);
        n = n * 59 + Float.floatToIntBits(this.bottom);
        return n;
    }

    public String toString() {
        return "Rect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ')';
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Rect makeLTRB(float l, float t, float r, float b) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        return Companion.makeLTRB(f, (float)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Rect makeWH(float w, float h) {
        void var1_1;
        float f;
        return Companion.makeWH(f, (float)var1_1);
    }

    @JvmStatic
    public static final Rect makeWH(Point size2) {
        Point point;
        return Companion.makeWH(point);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Rect makeXYWH(float l, float t, float w, float h) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        return Companion.makeXYWH(f, (float)var1_1, (float)var2_2, (float)var3_3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ2\u0010\u0003\u001a\u00020\u00052#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\b\u000eJ)\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001dH\u0007J(\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/Rect$Companion;", "", "()V", "fromInteropPointer", "", "Lorg/jetbrains/skia/Rect;", "size", "", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "(ILkotlin/jvm/functions/Function2;)[Lorg/jetbrains/skia/Rect;", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "makeLTRB", "l", "", "t", "r", "b", "makeWH", "w", "h", "Lorg/jetbrains/skia/Point;", "makeXYWH", "skiko"})
    @SourceDebugExtension(value={"SMAP\nRect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rect.kt\norg/jetbrains/skia/Rect$Companion\n+ 2 Native.kt\norg/jetbrains/skia/impl/NativeKt\n+ 3 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,128:1\n96#2:129\n97#2,5:131\n96#2:136\n97#2,5:138\n56#3:130\n56#3:137\n1549#4:143\n1620#4,3:144\n37#5,2:147\n*S KotlinDebug\n*F\n+ 1 Rect.kt\norg/jetbrains/skia/Rect$Companion\n*L\n110#1:129\n110#1:131,5\n115#1:136\n115#1:138,5\n110#1:130\n115#1:137\n116#1:143\n116#1:144,3\n118#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Rect makeLTRB(float l, float t, float r, float b) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new Rect((float)var1_1, (float)var2_2, (float)var3_3, b);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Rect makeWH(float w, float h) {
            void var2_2;
            void var1_1;
            return new Rect(0.0f, 0.0f, (float)var1_1, (float)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Rect makeWH(Point size2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            return this.makeWH(size2.getX(), var1_1.getY());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Rect makeXYWH(float l, float t, float w, float h) {
            void var2_2;
            void var3_3;
            void var1_1;
            return new Rect(l, t, (float)(var1_1 + var3_3), (float)(var2_2 + h));
        }

        /*
         * WARNING - void declaration
         */
        public final Rect fromInteropPointer$skiko(Function2<? super InteropScope, Object, Unit> block) {
            void var1_1;
            void var2_2;
            void var3_3;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            float[] result$iv = new float[4];
            InteropScope $this$withResult_u24lambda_u242$iv = theScope.INSTANCE;
            Object handle$iv = $this$withResult_u24lambda_u242$iv.toInteropForResult(result$iv);
            block.invoke((Object)$this$withResult_u24lambda_u242$iv, handle$iv);
            var3_3.fromInterop(handle$iv, result$iv);
            void result = var2_2;
            return new Rect((float)result[0], (float)result[1], (float)result[2], (float)var1_1[3]);
        }

        /*
         * WARNING - void declaration
         */
        public final Rect[] fromInteropPointer$skiko(int size2, Function2<? super InteropScope, Object, Unit> block) {
            void var3_8;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            float[] result$iv = new float[size2];
            InteropScope $this$withResult_u24lambda_u242$iv = theScope.INSTANCE;
            Object handle$iv = $this$withResult_u24lambda_u242$iv.toInteropForResult(result$iv);
            block.invoke((Object)$this$withResult_u24lambda_u242$iv, handle$iv);
            $this$withResult_u24lambda_u242$iv.fromInterop(handle$iv, result$iv);
            Iterable $this$map$iv = CollectionsKt.chunked((Iterable)ArraysKt.toList((float[])result$iv), (int)4);
            block = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void var1_4;
                void var2_7;
                item$iv$iv = (List)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                float left = ((Number)item$iv$iv.get(0)).floatValue();
                float top = ((Number)item$iv$iv.get(1)).floatValue();
                float right = ((Number)item$iv$iv.get(2)).floatValue();
                float bottom = ((Number)item$iv$iv.get(3)).floatValue();
                collection2.add(new Rect((float)var2_7, right, top, (float)var1_4));
            }
            Collection collection3 = collection = (Collection)((List)var3_8);
            return collection.toArray(new Rect[0]);
        }

        /*
         * WARNING - void declaration
         */
        public final Rect fromInteropPointerNullable$skiko(Function1<Object, Boolean> block) {
            void var2_2;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Ref.BooleanRef result = new Ref.BooleanRef();
            new Ref.BooleanRef().element = true;
            Rect rect2 = this.fromInteropPointer$skiko((Function2<? super InteropScope, Object, Unit>)((Function2)new Function2<InteropScope, Object, Unit>(result, block){
                final /* synthetic */ Ref.BooleanRef $result;
                final /* synthetic */ Function1<Object, Boolean> $block;
                {
                    void var2_2;
                    void var1_1;
                    this.$result = var1_1;
                    this.$block = var2_2;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(InteropScope $this$fromInteropPointer, Object it) {
                    void var2_2;
                    Intrinsics.checkNotNullParameter((Object)$this$fromInteropPointer, (String)"$this$fromInteropPointer");
                    this.$result.element = (Boolean)this.$block.invoke((Object)var2_2);
                }
            }));
            if (var2_2.element) {
                void var1_1;
                return var1_1;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

