/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativePointerArray;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 D2\u00020\u0001:\u0001DB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB3\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\u0010\n\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fB\u001d\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0006\u00100\u001a\u00020\u0003J\u001e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\rJ\u0013\u00104\u001a\u00020%2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00106\u001a\u00020\u0003H\u0016J\u000e\u00107\u001a\u00020%2\u0006\u0010/\u001a\u00020\rJ\b\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0003J\u0016\u0010C\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0011\u0010(\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0019R\u0011\u0010+\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0019\u00a8\u0006E"}, d2={"Lorg/jetbrains/skia/ImageInfo;", "", "width", "", "height", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;)V", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "", "Lorg/jetbrains/skia/impl/NativePointer;", "(IIIIJ)V", "colorInfo", "Lorg/jetbrains/skia/ColorInfo;", "(Lorg/jetbrains/skia/ColorInfo;II)V", "bounds", "Lorg/jetbrains/skia/IRect;", "getBounds", "()Lorg/jetbrains/skia/IRect;", "bytesPerPixel", "getBytesPerPixel", "()I", "colorAlphaType", "getColorAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "getColorInfo", "()Lorg/jetbrains/skia/ColorInfo;", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "getHeight", "isEmpty", "", "()Z", "isGammaCloseToSRGB", "isOpaque", "minRowBytes", "getMinRowBytes", "shiftPerPixel", "getShiftPerPixel", "getWidth", "computeByteSize", "rowBytes", "computeMinByteSize", "computeOffset", "x", "y", "equals", "other", "hashCode", "isRowBytesValid", "toString", "", "withColorAlphaType", "withColorInfo", "_colorInfo", "withColorSpace", "withColorType", "withHeight", "_height", "withWidth", "_width", "withWidthHeight", "Companion", "skiko"})
public final class ImageInfo {
    public static final Companion Companion = new Companion(null);
    private final ColorInfo colorInfo;
    private final int width;
    private final int height;
    private static final ImageInfo DEFAULT = new ImageInfo(ColorInfo.Companion.getDEFAULT(), 0, 0);

    /*
     * WARNING - void declaration
     */
    public ImageInfo(ColorInfo colorInfo, int width2, int height2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)colorInfo, (String)"colorInfo");
        this.colorInfo = var1_1;
        this.width = var2_2;
        this.height = var3_3;
    }

    public final ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public ImageInfo(int width2, int height2, ColorType colorType, ColorAlphaType alphaType) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        this(new ColorInfo((ColorType)var3_3, alphaType, null), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ImageInfo(int width2, int height2, ColorType colorType, ColorAlphaType alphaType, ColorSpace colorSpace) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        this(new ColorInfo((ColorType)var3_3, alphaType, colorSpace), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ImageInfo(int width2, int height2, int colorType, int alphaType, long colorSpace) {
        this((int)var1_1, (int)var2_2, ColorType.values()[var3_3], ColorAlphaType.values()[alphaType], colorSpace == Native.Companion.getNullPointer() ? null : new ColorSpace(colorSpace));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public final int getMinRowBytes() {
        return this.width * this.getBytesPerPixel();
    }

    public final ColorType getColorType() {
        return this.colorInfo.getColorType();
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withColorType(ColorType colorType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        ImageInfo imageInfo2 = this;
        return imageInfo2.withColorInfo(imageInfo2.colorInfo.withColorType((ColorType)var1_1));
    }

    public final ColorAlphaType getColorAlphaType() {
        return this.colorInfo.getAlphaType();
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withColorAlphaType(ColorAlphaType alphaType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        ImageInfo imageInfo2 = this;
        return imageInfo2.withColorInfo(imageInfo2.colorInfo.withAlphaType((ColorAlphaType)var1_1));
    }

    public final ColorSpace getColorSpace() {
        return this.colorInfo.getColorSpace();
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withColorSpace(ColorSpace colorSpace) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        ImageInfo imageInfo2 = this;
        return imageInfo2.withColorInfo(imageInfo2.colorInfo.withColorSpace((ColorSpace)var1_1));
    }

    public final boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public final boolean isOpaque() {
        return this.colorInfo.isOpaque();
    }

    public final IRect getBounds() {
        return IRect.Companion.makeXYWH(0, 0, this.width, this.height);
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorInfo.isGammaCloseToSRGB();
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withWidthHeight(int width2, int height2) {
        void var2_2;
        void var1_1;
        return new ImageInfo(this.colorInfo, (int)var1_1, (int)var2_2);
    }

    public final int getBytesPerPixel() {
        return this.colorInfo.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorInfo.getShiftPerPixel();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRowBytesValid(long rowBytes) {
        void var1_1;
        void var3_2;
        if (rowBytes < (long)this.getMinRowBytes()) {
            return false;
        }
        int shift = this.getShiftPerPixel();
        return rowBytes >> shift << var3_2 == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final long computeOffset(int x2, int y2, long rowBytes) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.colorInfo.getColorType().computeOffset((int)var1_1, (int)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int computeByteSize(int rowBytes) {
        void var1_1;
        if (this.height == 0) {
            return 0;
        }
        return (this.height - 1) * var1_1 + this.width * this.getBytesPerPixel();
    }

    public final int computeMinByteSize() {
        ImageInfo imageInfo2 = this;
        return imageInfo2.computeByteSize(imageInfo2.getMinRowBytes());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ImageInfo)) {
            return false;
        }
        if (this.width != ((ImageInfo)other).width) {
            return false;
        }
        if (this.height != ((ImageInfo)other).height) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorInfo, (Object)((ImageInfo)var1_1).colorInfo);
    }

    public final int hashCode() {
        int n = 59 + this.width;
        n = n * 59 + this.height;
        n = n * 59 + this.colorInfo.hashCode();
        return n;
    }

    public final String toString() {
        return "ImageInfo(_colorInfo=" + this.colorInfo + ", _width=" + this.width + ", _height=" + this.height + ')';
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withColorInfo(ColorInfo _colorInfo) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)_colorInfo, (String)"_colorInfo");
        if (this.colorInfo == _colorInfo) {
            return this;
        }
        return new ImageInfo((ColorInfo)var1_1, this.width, this.height);
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withWidth(int _width) {
        void var1_1;
        if (this.width == _width) {
            return this;
        }
        return new ImageInfo(this.colorInfo, (int)var1_1, this.height);
    }

    /*
     * WARNING - void declaration
     */
    public final ImageInfo withHeight(int _height) {
        void var1_1;
        if (this.height == _height) {
            return this;
        }
        return new ImageInfo(this.colorInfo, this.width, (int)var1_1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jo\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\n2[\u0010\u000b\u001aW\u0012\u0017\u0012\u00150\tj\u0002`\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\u0019\u0012\u0017\u0018\u00010\u0001j\u0002`\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0018\u00010\u0001j\u0002`\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/ImageInfo$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/skia/ImageInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ImageInfo;", "createUsing", "_ptr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "_nGetImageInfo", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/skia/impl/InteropPointer;", "intArrayPointer", "nativePointerArrayPtr", "", "makeA8", "width", "", "height", "makeN32", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "makeN32Premul", "makeS32", "makeUnknown", "skiko"})
    @SourceDebugExtension(value={"SMAP\nImageInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageInfo.kt\norg/jetbrains/skia/ImageInfo$Companion\n+ 2 Native.kt\norg/jetbrains/skia/impl/NativeKt\n+ 3 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n*L\n1#1,309:1\n114#2:310\n115#2,2:312\n145#2:314\n146#2,5:316\n117#2,3:321\n56#3:311\n56#3:315\n*S KotlinDebug\n*F\n+ 1 ImageInfo.kt\norg/jetbrains/skia/ImageInfo$Companion\n*L\n293#1:310\n293#1:312,2\n294#1:314\n294#1:316,5\n293#1:321,3\n293#1:311\n294#1:315\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final ImageInfo getDEFAULT() {
            return DEFAULT;
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeN32(int width2, int height2, ColorAlphaType alphaType) {
            void var2_2;
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), (ColorAlphaType)var3_3, null), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeN32(int width2, int height2, ColorAlphaType alphaType, ColorSpace colorSpace) {
            void var2_2;
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), (ColorAlphaType)var3_3, colorSpace), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeS32(int width2, int height2, ColorAlphaType alphaType) {
            void var2_2;
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), (ColorAlphaType)var3_3, ColorSpace.Companion.getSRGB()), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeN32Premul(int width2, int height2) {
            void var2_2;
            void var1_1;
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, null), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeN32Premul(int width2, int height2, ColorSpace colorSpace) {
            void var2_2;
            void var1_1;
            void var3_3;
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, (ColorSpace)var3_3), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeA8(int width2, int height2) {
            void var2_2;
            void var1_1;
            return new ImageInfo(new ColorInfo(ColorType.ALPHA_8, ColorAlphaType.PREMUL, null), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo makeUnknown(int width2, int height2) {
            void var2_2;
            void var1_1;
            return new ImageInfo(new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null), (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ImageInfo createUsing(long _ptr, Function3<? super Long, Object, Object, Unit> _nGetImageInfo) {
            void var1_2;
            void nativePointerArrayPtr;
            void var3_3;
            Object handle$iv;
            Object handle$iv2;
            Intrinsics.checkNotNullParameter(_nGetImageInfo, (String)"_nGetImageInfo");
            Stats.INSTANCE.onNativeCall();
            Ref.ObjectRef colorSpacePtr = new Ref.ObjectRef();
            int[] result$iv = new int[4];
            InteropScope $this$withResult_u24lambda_u244$iv = theScope.INSTANCE;
            Object intArrayPointer = handle$iv2 = $this$withResult_u24lambda_u244$iv.toInteropForResult(result$iv);
            NativePointerArray result$iv2 = new NativePointerArray(1);
            InteropScope $this$withResult_u24lambda_u248$iv = theScope.INSTANCE;
            Object object = handle$iv = $this$withResult_u24lambda_u248$iv.toInteropForResult(result$iv2);
            Ref.ObjectRef objectRef = colorSpacePtr;
            var3_3.invoke((Object)_ptr, intArrayPointer, (Object)nativePointerArrayPtr);
            $this$withResult_u24lambda_u248$iv.fromInterop(handle$iv, result$iv2);
            objectRef.element = result$iv2.get(0);
            $this$withResult_u24lambda_u244$iv.fromInterop(handle$iv2, result$iv);
            int[] it = result$iv;
            int n = it[0];
            int n2 = it[1];
            int n3 = it[2];
            void v3 = var1_2[3];
            Object object2 = colorSpacePtr.element;
            Intrinsics.checkNotNull((Object)object2);
            return new ImageInfo(n, n2, n3, (int)v3, ((Number)object2).longValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

