/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.SecureRandomHolder;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidSerialized;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0001\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0001\u001a\r\u0010\u0005\u001a\u00020\u0001*\u00020\u0006H\u0087\b\u001a\r\u0010\u0007\u001a\u00020\u0006*\u00020\u0001H\u0087\b\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\f\u001a\u00020\t*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u001c\u0010\f\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\r\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0080\b\u00a8\u0006\u000f"}, d2={"secureRandomUuid", "Lkotlin/uuid/Uuid;", "serializedUuid", "", "uuid", "toKotlinUuid", "Ljava/util/UUID;", "toJavaUuid", "getUuid", "Ljava/nio/ByteBuffer;", "index", "", "putUuid", "reverseBytes", "", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuidJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n1#1,257:1\n257#1:258\n257#1:259\n257#1:260\n257#1:261\n257#1:262\n257#1:263\n257#1:264\n257#1:265\n*S KotlinDebug\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n119#1:258\n120#1:259\n164#1:260\n165#1:261\n204#1:262\n205#1:263\n251#1:264\n252#1:265\n*E\n"})
class UuidKt__UuidJVMKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalUuidApi
    public static final Uuid secureRandomUuid() {
        void var0;
        byte[] randomBytes = new byte[16];
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(randomBytes);
        return UuidKt.uuidFromRandomBytes((byte[])var0);
    }

    @ExperimentalUuidApi
    public static final Object serializedUuid(Uuid uuid) {
        Uuid uuid2;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return new UuidSerialized(uuid.getMostSignificantBits(), uuid2.getLeastSignificantBits());
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final Uuid toKotlinUuid(UUID $this$toKotlinUuid) {
        UUID uUID;
        Intrinsics.checkNotNullParameter($this$toKotlinUuid, "<this>");
        return Uuid.Companion.fromLongs($this$toKotlinUuid.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final UUID toJavaUuid(Uuid $this$toJavaUuid) {
        Uuid uuid;
        Intrinsics.checkNotNullParameter($this$toJavaUuid, "<this>");
        long l = uuid.getLeastSignificantBits();
        long mostSignificantBits = uuid.getMostSignificantBits();
        return new UUID(mostSignificantBits, l);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final Uuid getUuid(ByteBuffer $this$getUuid) {
        void var3_2;
        void var1_1;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if ($this$getUuid.position() + 15 >= $this$getUuid.limit()) {
            throw new BufferUnderflowException();
        }
        long msb = $this$getUuid.getLong();
        long lsb = $this$getUuid.getLong();
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l = msb;
            msb = Long.reverseBytes(l);
            l = lsb;
            lsb = Long.reverseBytes(l);
        }
        return Uuid.Companion.fromLongs((long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final Uuid getUuid(ByteBuffer $this$getUuid, int index) {
        void var2_2;
        ByteBuffer byteBuffer;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$getUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + index + ", with limit: " + $this$getUuid.limit() + ' ');
        }
        long msb = $this$getUuid.getLong(index);
        long lsb = $this$getUuid.getLong((int)(var1_1 + 8));
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l = msb;
            msb = Long.reverseBytes(l);
            l = lsb;
            lsb = Long.reverseBytes(l);
        }
        return Uuid.Companion.fromLongs((long)var2_2, lsb);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final ByteBuffer putUuid(ByteBuffer $this$putUuid, Uuid uuid) {
        ByteBuffer byteBuffer;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        long l = var1_1.getLeastSignificantBits();
        long msb = var1_1.getMostSignificantBits();
        if ($this$putUuid.position() + 15 >= $this$putUuid.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            void lsb;
            $this$putUuid.putLong(msb);
            byteBuffer = $this$putUuid.putLong((long)lsb);
        } else {
            ByteBuffer byteBuffer2;
            long l2 = msb;
            $this$putUuid.putLong(Long.reverseBytes(l2));
            l2 = l;
            byteBuffer = byteBuffer2.putLong(Long.reverseBytes(l2));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    public static final ByteBuffer putUuid(ByteBuffer $this$putUuid, int index, Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        long l = var2_2.getLeastSignificantBits();
        long msb = var2_2.getMostSignificantBits();
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$putUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + index + ", with limit: " + $this$putUuid.limit() + ' ');
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(index, msb);
            byteBuffer = $this$putUuid.putLong(index + 8, (long)lsb);
        } else {
            void var1_1;
            ByteBuffer byteBuffer2;
            long l2 = msb;
            $this$putUuid.putLong(index, Long.reverseBytes(l2));
            l2 = lsb;
            byteBuffer = byteBuffer2.putLong((int)(var1_1 + 8), Long.reverseBytes(l2));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    public static final long reverseBytes(long $this$reverseBytes) {
        return Long.reverseBytes($this$reverseBytes);
    }
}

