/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.io.Serializable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.ULong;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00060\u0001j\u0002`\u0002:\u0001#B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\\\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f26\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0014J\\\u0010\u0015\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f26\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\t\u001a\u0004\b\r\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lkotlin/uuid/Uuid;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "mostSignificantBits", "", "leastSignificantBits", "<init>", "(JJ)V", "getMostSignificantBits$annotations", "()V", "getMostSignificantBits", "()J", "getLeastSignificantBits$annotations", "getLeastSignificantBits", "toLongs", "T", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toULongs", "Lkotlin/ULong;", "toString", "", "toHexString", "toByteArray", "", "equals", "", "other", "", "hashCode", "", "writeReplace", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="2.0")
@ExperimentalUuidApi
public final class Uuid
implements Serializable {
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    private static final Uuid NIL = new Uuid(0L, 0L);
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_BITS = 128;
    private static final Comparator<Uuid> LEXICAL_ORDER = Uuid::LEXICAL_ORDER$lambda$0;

    /*
     * WARNING - void declaration
     */
    public Uuid(long mostSignificantBits, long leastSignificantBits) {
        void var3_2;
        void var1_1;
        this.mostSignificantBits = var1_1;
        this.leastSignificantBits = var3_2;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getMostSignificantBits$annotations() {
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getLeastSignificantBits$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private final <T> T toLongs(Function2<? super Long, ? super Long, ? extends T> action) {
        void var1_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var1_1.invoke(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private final <T> T toULongs(Function2<? super ULong, ? super ULong, ? extends T> action) {
        void var1_1;
        Intrinsics.checkNotNullParameter(action, "action");
        return (T)var1_1.invoke(ULong.box-impl(ULong.constructor-impl(this.getMostSignificantBits())), ULong.box-impl(ULong.constructor-impl(this.getLeastSignificantBits())));
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        byte[] bytes = new byte[36];
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits, bytes, 24, 6);
        bytes[23] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits >>> 48, bytes, 19, 2);
        bytes[18] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits, bytes, 14, 2);
        bytes[13] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 16, bytes, 9, 2);
        bytes[8] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 32, bytes, 0, 4);
        return StringsKt.decodeToString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String toHexString() {
        void var1_1;
        byte[] bytes = new byte[32];
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits, bytes, 16, 8);
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits, bytes, 0, 8);
        return StringsKt.decodeToString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        byte[] bytes = new byte[16];
        UuidKt__UuidKt.access$toByteArray(this.mostSignificantBits, bytes, 0);
        UuidKt__UuidKt.access$toByteArray(this.leastSignificantBits, bytes, 8);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)other).mostSignificantBits && this.leastSignificantBits == ((Uuid)var1_1).leastSignificantBits;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        long x = this.mostSignificantBits ^ this.leastSignificantBits;
        return (int)(x >> 32) ^ (int)var1_1;
    }

    private final Object writeReplace() {
        return UuidKt.serializedUuid(this);
    }

    /*
     * WARNING - void declaration
     */
    private static final int LEXICAL_ORDER$lambda$0(Uuid a, Uuid b) {
        void var1_1;
        Uuid uuid;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (a.mostSignificantBits != b.mostSignificantBits) {
            return Long.compareUnsigned(ULong.constructor-impl(a.mostSignificantBits), ULong.constructor-impl(b.mostSignificantBits));
        }
        return Long.compareUnsigned(ULong.constructor-impl(uuid.leastSignificantBits), ULong.constructor-impl(var1_1.leastSignificantBits));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0018J\u0006\u0010\u001b\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001dj\b\u0012\u0004\u0012\u00020\u0005`\u001e\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lkotlin/uuid/Uuid$Companion;", "", "<init>", "()V", "NIL", "Lkotlin/uuid/Uuid;", "getNIL", "()Lkotlin/uuid/Uuid;", "SIZE_BYTES", "", "SIZE_BITS", "fromLongs", "mostSignificantBits", "", "leastSignificantBits", "fromULongs", "Lkotlin/ULong;", "fromULongs-eb3DHEI", "(JJ)Lkotlin/uuid/Uuid;", "fromByteArray", "byteArray", "", "parse", "uuidString", "", "parseHex", "hexString", "random", "LEXICAL_ORDER", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getLEXICAL_ORDER", "()Ljava/util/Comparator;", "Ljava/util/Comparator;", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nUuid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uuid.kt\nkotlin/uuid/Uuid$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1#2:453\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Uuid getNIL() {
            return NIL;
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid fromLongs(long mostSignificantBits, long leastSignificantBits) {
            void var3_2;
            void var1_1;
            if (mostSignificantBits == 0L && leastSignificantBits == 0L) {
                return this.getNIL();
            }
            return new Uuid((long)var1_1, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid fromULongs-eb3DHEI(long mostSignificantBits, long leastSignificantBits) {
            void var3_2;
            void var1_1;
            return this.fromLongs((long)var1_1, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid fromByteArray(byte[] byteArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            if (!(((byte[])byteArray).length == 16)) {
                byteArray = "Expected exactly 16 bytes";
                throw new IllegalArgumentException(byteArray.toString());
            }
            return this.fromLongs(UuidKt__UuidKt.access$toLong((byte[])byteArray, 0), UuidKt__UuidKt.access$toLong((byte[])var1_1, 8));
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid parse(String uuidString) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter(uuidString, "uuidString");
            if (!(uuidString.length() == 36)) {
                String string = "Expected a 36-char string in the standard uuid format.";
                throw new IllegalArgumentException(string.toString());
            }
            long part1 = HexExtensionsKt.hexToLong$default(uuidString, 0, 8, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 8);
            long part2 = HexExtensionsKt.hexToLong$default(uuidString, 9, 13, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 13);
            long part3 = HexExtensionsKt.hexToLong$default(uuidString, 14, 18, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 18);
            long part4 = HexExtensionsKt.hexToLong$default(uuidString, 19, 23, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 23);
            long part5 = HexExtensionsKt.hexToLong$default((String)var1_1, 24, 36, null, 4, null);
            void msb = var2_3 << 32 | part2 << 16 | part3;
            long lsb = part4 << 48 | part5;
            return this.fromLongs((long)msb, lsb);
        }

        /*
         * WARNING - void declaration
         */
        public final Uuid parseHex(String hexString) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter(hexString, "hexString");
            if (!(hexString.length() == 32)) {
                String string = "Expected a 32-char hexadecimal string.";
                throw new IllegalArgumentException(string.toString());
            }
            long msb = HexExtensionsKt.hexToLong$default(hexString, 0, 16, null, 4, null);
            long lsb = HexExtensionsKt.hexToLong$default((String)var1_1, 16, 32, null, 4, null);
            return this.fromLongs((long)var2_3, lsb);
        }

        public final Uuid random() {
            return UuidKt.secureRandomUuid();
        }

        public final Comparator<Uuid> getLEXICAL_ORDER() {
            return LEXICAL_ORDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

