/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringNumberConversionsJVMKt;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000.\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\u0003\u001a\u001b\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\t\u001a\u001b\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\n\u001a\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\f\u001a\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\r\u001a\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\u0010\u001a\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0000\u00a8\u0006\u0015"}, d2={"toByteOrNull", "", "", "(Ljava/lang/String;)Ljava/lang/Byte;", "radix", "", "(Ljava/lang/String;I)Ljava/lang/Byte;", "toShortOrNull", "", "(Ljava/lang/String;)Ljava/lang/Short;", "(Ljava/lang/String;I)Ljava/lang/Short;", "toIntOrNull", "(Ljava/lang/String;)Ljava/lang/Integer;", "(Ljava/lang/String;I)Ljava/lang/Integer;", "toLongOrNull", "", "(Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;I)Ljava/lang/Long;", "numberFormatError", "", "input", "kotlin-stdlib"}, xs="kotlin/text/StringsKt")
class StringsKt__StringNumberConversionsKt
extends StringsKt__StringNumberConversionsJVMKt {
    @SinceKotlin(version="1.1")
    public static final Byte toByteOrNull(String $this$toByteOrNull) {
        String string;
        Intrinsics.checkNotNullParameter($this$toByteOrNull, "<this>");
        return StringsKt.toByteOrNull(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static final Byte toByteOrNull(String $this$toByteOrNull, int radix) {
        void var0_1;
        void var1_2;
        Intrinsics.checkNotNullParameter($this$toByteOrNull, "<this>");
        Integer n = StringsKt.toIntOrNull($this$toByteOrNull, (int)var1_2);
        if (n == null) {
            return null;
        }
        int n2 = n;
        if (n2 < -128 || n2 > 127) {
            return null;
        }
        return (byte)var0_1;
    }

    @SinceKotlin(version="1.1")
    public static final Short toShortOrNull(String $this$toShortOrNull) {
        String string;
        Intrinsics.checkNotNullParameter($this$toShortOrNull, "<this>");
        return StringsKt.toShortOrNull(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static final Short toShortOrNull(String $this$toShortOrNull, int radix) {
        void var0_1;
        void var1_2;
        Intrinsics.checkNotNullParameter($this$toShortOrNull, "<this>");
        Integer n = StringsKt.toIntOrNull($this$toShortOrNull, (int)var1_2);
        if (n == null) {
            return null;
        }
        int n2 = n;
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            return null;
        }
        return (short)var0_1;
    }

    @SinceKotlin(version="1.1")
    public static final Integer toIntOrNull(String $this$toIntOrNull) {
        String string;
        Intrinsics.checkNotNullParameter($this$toIntOrNull, "<this>");
        return StringsKt.toIntOrNull(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static final Integer toIntOrNull(String $this$toIntOrNull, int radix) {
        void i;
        int limit;
        boolean isNegative;
        int length;
        block15: {
            boolean start;
            block14: {
                Intrinsics.checkNotNullParameter($this$toIntOrNull, "<this>");
                CharsKt.checkRadix(radix);
                length = $this$toIntOrNull.length();
                if (length == 0) {
                    return null;
                }
                char firstChar = $this$toIntOrNull.charAt(0);
                if (Intrinsics.compare(firstChar, 48) >= 0) break block14;
                if (length == 1) {
                    return null;
                }
                start = true;
                switch (firstChar) {
                    case '-': {
                        isNegative = true;
                        limit = Integer.MIN_VALUE;
                        break block15;
                    }
                    case '+': {
                        isNegative = false;
                        limit = -2147483647;
                        break block15;
                    }
                    default: {
                        return null;
                    }
                }
            }
            start = false;
            isNegative = false;
            limit = -2147483647;
        }
        int limitBeforeMul = -59652323;
        int result = 0;
        while (i < length) {
            int digit = CharsKt.digitOf($this$toIntOrNull.charAt((int)i), radix);
            if (digit < 0) {
                return null;
            }
            if (result < limitBeforeMul) {
                if (limitBeforeMul == -59652323) {
                    limitBeforeMul = limit / radix;
                    if (result < limitBeforeMul) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if ((result *= radix) < limit + digit) {
                return null;
            }
            result -= digit;
            ++i;
        }
        if (isNegative) {
            return result;
        }
        return -result;
    }

    @SinceKotlin(version="1.1")
    public static final Long toLongOrNull(String $this$toLongOrNull) {
        String string;
        Intrinsics.checkNotNullParameter($this$toLongOrNull, "<this>");
        return StringsKt.toLongOrNull(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static final Long toLongOrNull(String $this$toLongOrNull, int radix) {
        void i;
        long limit;
        boolean isNegative;
        int length;
        block15: {
            boolean start;
            block14: {
                Intrinsics.checkNotNullParameter($this$toLongOrNull, "<this>");
                CharsKt.checkRadix(radix);
                length = $this$toLongOrNull.length();
                if (length == 0) {
                    return null;
                }
                char firstChar = $this$toLongOrNull.charAt(0);
                if (Intrinsics.compare(firstChar, 48) >= 0) break block14;
                if (length == 1) {
                    return null;
                }
                start = true;
                switch (firstChar) {
                    case '-': {
                        isNegative = true;
                        limit = Long.MIN_VALUE;
                        break block15;
                    }
                    case '+': {
                        isNegative = false;
                        limit = -9223372036854775807L;
                        break block15;
                    }
                    default: {
                        return null;
                    }
                }
            }
            start = false;
            isNegative = false;
            limit = -9223372036854775807L;
        }
        long limitBeforeMul = -256204778801521550L;
        long result = 0L;
        while (i < length) {
            int digit = CharsKt.digitOf($this$toLongOrNull.charAt((int)i), radix);
            if (digit < 0) {
                return null;
            }
            if (result < limitBeforeMul) {
                if (limitBeforeMul == -256204778801521550L) {
                    limitBeforeMul = limit / (long)radix;
                    if (result < limitBeforeMul) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                return null;
            }
            result -= (long)digit;
            ++i;
        }
        if (isNegative) {
            return result;
        }
        return -result;
    }

    public static final Void numberFormatError(String input) {
        String string;
        Intrinsics.checkNotNullParameter(input, "input");
        throw new NumberFormatException("Invalid number format: '" + string + '\'');
    }
}

