/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.XorWowRandom;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0014\u0010\b\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\tH\u0007\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"Random", "Lkotlin/random/Random;", "seed", "", "", "nextInt", "range", "Lkotlin/ranges/IntRange;", "nextLong", "Lkotlin/ranges/LongRange;", "fastLog2", "value", "takeUpperBits", "bitCount", "checkRangeBounds", "", "from", "until", "", "boundsErrorMessage", "", "", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Random.kt\nkotlin/random/RandomKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
public final class RandomKt {
    @SinceKotlin(version="1.3")
    public static final Random Random(int seed) {
        int n;
        int n2 = n;
        return new XorWowRandom(n2, n2 >> 31);
    }

    @SinceKotlin(version="1.3")
    public static final Random Random(long seed) {
        long l;
        return new XorWowRandom((int)seed, (int)(l >> 32));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.3")
    public static final int nextInt(Random $this$nextInt, IntRange range) {
        Random random;
        Intrinsics.checkNotNullParameter($this$nextInt, "<this>");
        Intrinsics.checkNotNullParameter(range, "range");
        if (((IntProgression)range).isEmpty()) {
            throw new IllegalArgumentException("Cannot get random in empty range: " + range);
        }
        if (range.getLast() < Integer.MAX_VALUE) {
            return $this$nextInt.nextInt(range.getFirst(), range.getLast() + 1);
        }
        if (range.getFirst() > Integer.MIN_VALUE) {
            void var1_1;
            return $this$nextInt.nextInt(range.getFirst() - 1, var1_1.getLast()) + 1;
        }
        return random.nextInt();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.3")
    public static final long nextLong(Random $this$nextLong, LongRange range) {
        Random random;
        Intrinsics.checkNotNullParameter($this$nextLong, "<this>");
        Intrinsics.checkNotNullParameter(range, "range");
        if (((LongProgression)range).isEmpty()) {
            throw new IllegalArgumentException("Cannot get random in empty range: " + range);
        }
        if (range.getLast() < Long.MAX_VALUE) {
            return $this$nextLong.nextLong(range.getFirst(), range.getLast() + 1L);
        }
        if (range.getFirst() > Long.MIN_VALUE) {
            void var1_1;
            return $this$nextLong.nextLong(range.getFirst() - 1L, var1_1.getLast()) + 1L;
        }
        return random.nextLong();
    }

    public static final int fastLog2(int value) {
        int n;
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    /*
     * WARNING - void declaration
     */
    public static final int takeUpperBits(int $this$takeUpperBits, int bitCount) {
        void var1_1;
        return $this$takeUpperBits >>> 32 - bitCount & -var1_1 >> 31;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkRangeBounds(int from, int until) {
        if (!(until > from)) {
            void var1_2;
            int n;
            String string = RandomKt.boundsErrorMessage(n, (int)var1_2);
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkRangeBounds(long from, long until) {
        if (!(until > from)) {
            void var2_2;
            long l;
            String string = RandomKt.boundsErrorMessage(l, (long)var2_2);
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkRangeBounds(double from, double until) {
        if (!(until > from)) {
            void var2_2;
            double d;
            String string = RandomKt.boundsErrorMessage(d, (double)var2_2);
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String boundsErrorMessage(Object from, Object until) {
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(until, "until");
        return "Random range is empty: [" + object + ", " + var1_1 + ").";
    }
}

