/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.encoding;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.collections.AbstractList;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.encoding.Base64Kt;
import kotlin.io.encoding.ExperimentalEncodingApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\t\b\u0017\u0018\u0000 >2\u00020\u0001:\u0002=>B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J=\u0010\u001b\u001a\u0002H\u001c\"\f\b\u0000\u0010\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u0002H\u001c2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001fJ\"\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\"\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J%\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b$J5\u0010%\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\u0003H\u0002J0\u0010+\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J%\u0010,\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b-J%\u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b1J(\u00102\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00103\u001a\u00020\u0014H\u0002J \u00107\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J%\u00108\u001a\u0002062\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b9J \u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006?"}, d2={"Lkotlin/io/encoding/Base64;", "", "isUrlSafe", "", "isMimeScheme", "paddingOption", "Lkotlin/io/encoding/Base64$PaddingOption;", "<init>", "(ZZLkotlin/io/encoding/Base64$PaddingOption;)V", "isUrlSafe$kotlin_stdlib", "()Z", "isMimeScheme$kotlin_stdlib", "getPaddingOption$kotlin_stdlib", "()Lkotlin/io/encoding/Base64$PaddingOption;", "withPadding", "option", "encodeToByteArray", "", "source", "startIndex", "", "endIndex", "encodeIntoByteArray", "destination", "destinationOffset", "encode", "", "encodeToAppendable", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "([BLjava/lang/Appendable;II)Ljava/lang/Appendable;", "decode", "decodeIntoByteArray", "", "encodeToByteArrayImpl", "encodeToByteArrayImpl$kotlin_stdlib", "encodeIntoByteArrayImpl", "encodeIntoByteArrayImpl$kotlin_stdlib", "encodeSize", "sourceSize", "encodeSize$kotlin_stdlib", "shouldPadOnEncode", "decodeImpl", "decodeSize", "decodeSize$kotlin_stdlib", "charsToBytesImpl", "charsToBytesImpl$kotlin_stdlib", "bytesToStringImpl", "bytesToStringImpl$kotlin_stdlib", "handlePaddingSymbol", "padIndex", "byteStart", "checkPaddingIsAllowed", "", "skipIllegalSymbolsIfMime", "checkSourceBounds", "checkSourceBounds$kotlin_stdlib", "checkDestinationBounds", "destinationSize", "capacityNeeded", "PaddingOption", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.8")
@ExperimentalEncodingApi
public class Base64 {
    public static final Default Default = new Default(null);
    private final boolean isUrlSafe;
    private final boolean isMimeScheme;
    private final PaddingOption paddingOption;
    private static final int bitsPerByte = 8;
    private static final int bitsPerSymbol = 6;
    public static final int bytesPerGroup = 3;
    public static final int symbolsPerGroup = 4;
    public static final byte padSymbol = 61;
    public static final int mimeLineLength = 76;
    private static final int mimeGroupsPerLine = 19;
    private static final byte[] mimeLineSeparatorSymbols;
    private static final Base64 UrlSafe;
    private static final Base64 Mime;

    /*
     * WARNING - void declaration
     */
    private Base64(boolean isUrlSafe, boolean isMimeScheme, PaddingOption paddingOption) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.isUrlSafe = var1_1;
        this.isMimeScheme = var2_3;
        this.paddingOption = var3_4;
        if (!(!this.isUrlSafe || !this.isMimeScheme)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean isUrlSafe$kotlin_stdlib() {
        return this.isUrlSafe;
    }

    public final boolean isMimeScheme$kotlin_stdlib() {
        return this.isMimeScheme;
    }

    public final PaddingOption getPaddingOption$kotlin_stdlib() {
        return this.paddingOption;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    public final Base64 withPadding(PaddingOption option) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)option, "option");
        if (this.paddingOption == option) {
            return this;
        }
        return new Base64(this.isUrlSafe, this.isMimeScheme, (PaddingOption)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] encodeToByteArray(byte[] source, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, "source");
        return this.encodeToByteArrayImpl$kotlin_stdlib((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(Base64 base64, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToByteArray");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return base64.encodeToByteArray(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int encodeIntoByteArray(byte[] source, byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.encodeIntoByteArrayImpl$kotlin_stdlib((byte[])var1_1, (byte[])var2_2, (int)var3_3, startIndex, endIndex);
    }

    public static /* synthetic */ int encodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = byArray.length;
        }
        return base64.encodeIntoByteArray(byArray, byArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(byte[] source, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source, "source");
        byArray = this.encodeToByteArrayImpl$kotlin_stdlib(byArray, (int)var2_2, (int)var3_3);
        return new String(byArray, Charsets.ISO_8859_1);
    }

    public static /* synthetic */ String encode$default(Base64 base64, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return base64.encode(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Appendable> A encodeToAppendable(byte[] source, A destination, int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        source = this.encodeToByteArrayImpl$kotlin_stdlib(source, (int)var3_3, endIndex);
        String stringResult = new String(source, Charsets.ISO_8859_1);
        destination.append((CharSequence)var1_1);
        return var2_2;
    }

    public static /* synthetic */ Appendable encodeToAppendable$default(Base64 base64, byte[] byArray, Appendable appendable, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToAppendable");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        return base64.encodeToAppendable(byArray, appendable, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] decode(byte[] source, int startIndex, int endIndex) {
        void var3_4;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        int n = this.decodeSize$kotlin_stdlib(source, startIndex, endIndex);
        byte[] destination = new byte[n];
        int n2 = this.decodeImpl((byte[])var1_1, destination, 0, (int)var2_3, (int)var3_4);
        if (!(n2 == destination.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return destination;
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return base64.decode(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int decodeIntoByteArray(byte[] source, byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        this.checkDestinationBounds(destination.length, destinationOffset, this.decodeSize$kotlin_stdlib(source, startIndex, endIndex));
        return this.decodeImpl((byte[])var1_1, (byte[])var2_2, (int)var3_3, startIndex, endIndex);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = byArray.length;
        }
        return base64.decodeIntoByteArray(byArray, byArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] decode(CharSequence source, int startIndex2, int endIndex) {
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source, "source");
        Base64 base64 = this;
        if (source instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(((String)source).length(), startIndex2, endIndex);
            String string = ((String)source).substring(startIndex2, endIndex);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            source = string;
            Charset startIndex2 = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(source, "null cannot be cast to non-null type java.lang.String");
            byte[] byArray2 = ((String)source).getBytes(startIndex2);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        } else {
            void var3_4;
            void var2_2;
            byArray = base64.charsToBytesImpl$kotlin_stdlib(source, (int)var2_2, (int)var3_4);
        }
        byte[] byteSource = byArray;
        return Base64.decode$default(this, (byte[])var1_1, 0, 0, 6, null);
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return base64.decode(charSequence, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int decodeIntoByteArray(CharSequence source, byte[] destination, int destinationOffset, int startIndex2, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Base64 base64 = this;
        if (source instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(((String)source).length(), startIndex2, endIndex);
            String string = ((String)source).substring(startIndex2, endIndex);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            source = string;
            Charset startIndex2 = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(source, "null cannot be cast to non-null type java.lang.String");
            byte[] byArray2 = ((String)source).getBytes(startIndex2);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        } else {
            int startIndex2;
            byArray = base64.charsToBytesImpl$kotlin_stdlib(source, startIndex2, endIndex);
        }
        byte[] byteSource = byArray;
        return Base64.decodeIntoByteArray$default(this, (byte[])var1_1, (byte[])var2_2, (int)var3_3, 0, 0, 24, null);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, CharSequence charSequence, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = charSequence.length();
        }
        return base64.decodeIntoByteArray(charSequence, byArray, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] encodeToByteArrayImpl$kotlin_stdlib(byte[] source, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        int n = this.encodeSize$kotlin_stdlib(endIndex - startIndex);
        byte[] destination = new byte[n];
        this.encodeIntoByteArrayImpl$kotlin_stdlib((byte[])var1_1, destination, 0, (int)var2_2, (int)var3_3);
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    public final int encodeIntoByteArrayImpl$kotlin_stdlib(byte[] source, byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        int bits;
        int i;
        int groupsPerLine;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.checkSourceBounds$kotlin_stdlib(source.length, startIndex, endIndex);
        this.checkDestinationBounds(destination.length, destinationOffset, this.encodeSize$kotlin_stdlib(endIndex - startIndex));
        byte[] encodeMap = this.isUrlSafe ? Base64Kt.access$getBase64UrlEncodeMap$p() : Base64Kt.access$getBase64EncodeMap$p();
        int sourceIndex = startIndex;
        int destinationIndex = destinationOffset;
        int n = groupsPerLine = this.isMimeScheme ? 19 : Integer.MAX_VALUE;
        while (sourceIndex + 2 < endIndex) {
            int groups2 = Math.min((endIndex - sourceIndex) / 3, groupsPerLine);
            for (i = 0; i < groups2; ++i) {
                int byte1 = source[sourceIndex++] & 0xFF;
                int byte2 = source[sourceIndex++] & 0xFF;
                int byte3 = source[sourceIndex++] & 0xFF;
                bits = byte1 << 16 | byte2 << 8 | byte3;
                destination[destinationIndex++] = encodeMap[bits >>> 18];
                destination[destinationIndex++] = encodeMap[bits >>> 12 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits >>> 6 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
            }
            if (groups2 != groupsPerLine || sourceIndex == endIndex) continue;
            destination[destinationIndex++] = mimeLineSeparatorSymbols[0];
            destination[destinationIndex++] = mimeLineSeparatorSymbols[1];
        }
        switch (endIndex - sourceIndex) {
            case 1: {
                i = source[sourceIndex++] & 0xFF;
                bits = i << 4;
                destination[destinationIndex++] = encodeMap[bits >>> 6];
                destination[destinationIndex++] = encodeMap[bits & 0x3F];
                if (!this.shouldPadOnEncode()) break;
                destination[destinationIndex++] = 61;
                destination[destinationIndex++] = 61;
                break;
            }
            case 2: {
                void var1_1;
                int byte1 = source[sourceIndex++] & 0xFF;
                int byte2 = var1_1[sourceIndex++] & 0xFF;
                int bits2 = byte1 << 10 | byte2 << 2;
                destination[destinationIndex++] = encodeMap[bits2 >>> 12];
                destination[destinationIndex++] = encodeMap[bits2 >>> 6 & 0x3F];
                destination[destinationIndex++] = encodeMap[bits2 & 0x3F];
                if (!this.shouldPadOnEncode()) break;
                var2_2[destinationIndex++] = 61;
            }
        }
        if (!(sourceIndex == endIndex)) {
            throw new IllegalStateException("Check failed.");
        }
        return destinationIndex - var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int encodeSize$kotlin_stdlib(int sourceSize) {
        void var2_2;
        int groups2 = sourceSize / 3;
        int trailingBytes = sourceSize % 3;
        int size = groups2 << 2;
        if (trailingBytes != 0) {
            void var1_1;
            size += this.shouldPadOnEncode() ? 4 : var1_1 + true;
        }
        if (this.isMimeScheme) {
            int n = size;
            size = n + ((n - 1) / 76 << 1);
        }
        if (size < 0) {
            throw new IllegalArgumentException("Input is too big");
        }
        return (int)var2_2;
    }

    private final boolean shouldPadOnEncode() {
        return this.paddingOption == PaddingOption.PRESENT || this.paddingOption == PaddingOption.PRESENT_OPTIONAL;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeImpl(byte[] source, byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        void var3_3;
        int symbol;
        int[] decodeMap = this.isUrlSafe ? Base64Kt.access$getBase64UrlDecodeMap$p() : Base64Kt.access$getBase64DecodeMap$p();
        int payload = 0;
        int byteStart = -8;
        int sourceIndex = startIndex;
        int destinationIndex = destinationOffset;
        boolean hasPadding = false;
        while (sourceIndex < endIndex) {
            int symbolBits;
            if (byteStart == -8 && sourceIndex + 3 < endIndex) {
                int symbol4;
                int symbol3;
                int bits;
                int symbol1 = decodeMap[source[sourceIndex++] & 0xFF];
                int symbol2 = decodeMap[source[sourceIndex++] & 0xFF];
                if ((bits = symbol1 << 18 | symbol2 << 12 | (symbol3 = decodeMap[source[sourceIndex++] & 0xFF]) << 6 | (symbol4 = decodeMap[source[sourceIndex++] & 0xFF])) >= 0) {
                    destination[destinationIndex++] = (byte)(bits >> 16);
                    destination[destinationIndex++] = (byte)(bits >> 8);
                    destination[destinationIndex++] = (byte)bits;
                    continue;
                }
                sourceIndex -= 4;
            }
            if ((symbolBits = decodeMap[symbol = source[sourceIndex] & 0xFF]) < 0) {
                if (symbolBits == -2) {
                    hasPadding = true;
                    sourceIndex = this.handlePaddingSymbol(source, sourceIndex, endIndex, byteStart);
                    break;
                }
                if (this.isMimeScheme) {
                    ++sourceIndex;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder("Invalid symbol '").append((char)symbol).append("'(");
                String string = Integer.toString(symbol, CharsKt.checkRadix(8));
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(sourceIndex).toString());
            }
            ++sourceIndex;
            payload = payload << 6 | symbolBits;
            if ((byteStart += 6) < 0) continue;
            destination[destinationIndex++] = (byte)(payload >>> byteStart);
            payload &= (1 << byteStart) - 1;
            byteStart -= 8;
        }
        if (byteStart == -2) {
            throw new IllegalArgumentException("The last unit of input does not have enough bits");
        }
        if (byteStart != -8 && !hasPadding && this.paddingOption == PaddingOption.PRESENT) {
            throw new IllegalArgumentException("The padding option is set to PRESENT, but the input is not properly padded");
        }
        if (payload != 0) {
            throw new IllegalArgumentException("The pad bits must be zeros");
        }
        if ((sourceIndex = this.skipIllegalSymbolsIfMime(source, sourceIndex, endIndex)) < endIndex) {
            void var1_1;
            symbol = var1_1[sourceIndex] & 0xFF;
            StringBuilder stringBuilder = new StringBuilder("Symbol '").append((char)symbol).append("'(");
            String string = Integer.toString(symbol, CharsKt.checkRadix(8));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(sourceIndex - 1).append(" is prohibited after the pad character").toString());
        }
        return destinationIndex - var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int decodeSize$kotlin_stdlib(byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(source, "source");
        int symbols = endIndex - startIndex;
        if (symbols == 0) {
            return 0;
        }
        if (symbols == 1) {
            throw new IllegalArgumentException("Input should have at least 2 symbols for Base64 decoding, startIndex: " + startIndex + ", endIndex: " + endIndex);
        }
        if (this.isMimeScheme) {
            void index;
            while (index < endIndex) {
                int symbol = source[index] & 0xFF;
                int symbolBits = Base64Kt.access$getBase64DecodeMap$p()[symbol];
                if (symbolBits < 0) {
                    if (symbolBits == -2) {
                        symbols -= endIndex - index;
                        break;
                    }
                    --symbols;
                }
                ++index;
            }
        } else if (source[endIndex - 1] == 61) {
            void var3_3;
            void var1_1;
            --symbols;
            if (var1_1[var3_3 - 2] == 61) {
                --symbols;
            }
        }
        return (int)((long)symbols * 6L / 8L);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] charsToBytesImpl$kotlin_stdlib(CharSequence source, int startIndex, int endIndex) {
        void index;
        Intrinsics.checkNotNullParameter(source, "source");
        this.checkSourceBounds$kotlin_stdlib(source.length(), startIndex, endIndex);
        byte[] byteArray = new byte[endIndex - startIndex];
        int length = 0;
        while (index < endIndex) {
            char symbol = source.charAt((int)index);
            byteArray[length++] = symbol <= '\u00ff' ? (int)symbol : 63;
            ++index;
        }
        return byteArray;
    }

    /*
     * WARNING - void declaration
     */
    public final String bytesToStringImpl$kotlin_stdlib(byte[] source) {
        void var2_2;
        Intrinsics.checkNotNullParameter(source, "source");
        StringBuilder stringBuilder = new StringBuilder(source.length);
        for (byte by : source) {
            stringBuilder.append((char)by);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final int handlePaddingSymbol(byte[] source, int padIndex, int endIndex, int byteStart) {
        switch (byteStart) {
            case -8: {
                throw new IllegalArgumentException("Redundant pad character at index " + padIndex);
            }
            case -2: {
                return padIndex + 1;
            }
            case -4: {
                void var2_2;
                void var1_1;
                void var3_3;
                this.checkPaddingIsAllowed(padIndex);
                int secondPadIndex = this.skipIllegalSymbolsIfMime(source, padIndex + 1, endIndex);
                if (secondPadIndex == var3_3 || var1_1[secondPadIndex] != 61) {
                    throw new IllegalArgumentException("Missing one pad character at index " + secondPadIndex);
                }
                return (int)(var2_2 + true);
            }
            case -6: {
                void var2_2;
                this.checkPaddingIsAllowed((int)var2_2);
                return (int)(var2_2 + true);
            }
        }
        throw new IllegalStateException("Unreachable".toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPaddingIsAllowed(int padIndex) {
        if (this.paddingOption == PaddingOption.ABSENT) {
            void var1_1;
            throw new IllegalArgumentException("The padding option is set to ABSENT, but the input has a pad character at index " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int skipIllegalSymbolsIfMime(byte[] source, int startIndex, int endIndex) {
        void var2_2;
        void sourceIndex;
        if (!this.isMimeScheme) {
            return startIndex;
        }
        while (sourceIndex < endIndex) {
            int symbol = source[sourceIndex] & 0xFF;
            if (Base64Kt.access$getBase64DecodeMap$p()[symbol] != -1) {
                return (int)sourceIndex;
            }
            ++sourceIndex;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkSourceBounds$kotlin_stdlib(int sourceSize, int startIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void var2_2;
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib((int)var2_2, (int)var3_3, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDestinationBounds(int destinationSize, int destinationOffset, int capacityNeeded) {
        if (destinationOffset < 0 || destinationOffset > destinationSize) {
            throw new IndexOutOfBoundsException("destination offset: " + destinationOffset + ", destination size: " + destinationSize);
        }
        int destinationEndIndex = destinationOffset + capacityNeeded;
        if (destinationEndIndex < 0 || destinationEndIndex > destinationSize) {
            void var3_3;
            void var1_1;
            void var2_2;
            throw new IndexOutOfBoundsException("The destination array does not have enough capacity, destination offset: " + (int)var2_2 + ", destination size: " + (int)var1_1 + ", capacity needed: " + (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Base64(boolean isUrlSafe, boolean isMimeScheme, PaddingOption paddingOption, DefaultConstructorMarker $constructor_marker) {
        this((boolean)var1_1, (boolean)var2_2, (PaddingOption)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 13;
        byArray2[1] = 10;
        mimeLineSeparatorSymbols = byArray2;
        UrlSafe = new Base64(true, false, PaddingOption.PRESENT);
        Mime = new Base64(false, true, PaddingOption.PRESENT);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lkotlin/io/encoding/Base64$Default;", "Lkotlin/io/encoding/Base64;", "<init>", "()V", "bitsPerByte", "", "bitsPerSymbol", "bytesPerGroup", "symbolsPerGroup", "padSymbol", "", "mimeLineLength", "mimeGroupsPerLine", "mimeLineSeparatorSymbols", "", "getMimeLineSeparatorSymbols$kotlin_stdlib", "()[B", "UrlSafe", "getUrlSafe", "()Lkotlin/io/encoding/Base64;", "Mime", "getMime", "kotlin-stdlib"})
    public static final class Default
    extends Base64 {
        private Default() {
            super(false, false, PaddingOption.PRESENT, null);
        }

        public final byte[] getMimeLineSeparatorSymbols$kotlin_stdlib() {
            return mimeLineSeparatorSymbols;
        }

        public final Base64 getUrlSafe() {
            return UrlSafe;
        }

        public final Base64 getMime() {
            return Mime;
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkotlin/io/encoding/Base64$PaddingOption;", "", "<init>", "(Ljava/lang/String;I)V", "PRESENT", "ABSENT", "PRESENT_OPTIONAL", "ABSENT_OPTIONAL", "kotlin-stdlib"})
    @SinceKotlin(version="2.0")
    public static final class PaddingOption
    extends Enum<PaddingOption> {
        public static final /* enum */ PaddingOption PRESENT = new PaddingOption();
        public static final /* enum */ PaddingOption ABSENT = new PaddingOption();
        public static final /* enum */ PaddingOption PRESENT_OPTIONAL = new PaddingOption();
        public static final /* enum */ PaddingOption ABSENT_OPTIONAL = new PaddingOption();
        private static final /* synthetic */ PaddingOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private PaddingOption() {
            void var2_2;
            void var1_1;
        }

        public static PaddingOption[] values() {
            return (PaddingOption[])$VALUES.clone();
        }

        public static PaddingOption valueOf(String value) {
            String string;
            return Enum.valueOf(PaddingOption.class, string);
        }

        public static EnumEntries<PaddingOption> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ PaddingOption[] $values() {
            PaddingOption[] paddingOptionArray = new PaddingOption[4];
            PaddingOption[] paddingOptionArray2 = paddingOptionArray;
            paddingOptionArray[0] = PRESENT;
            paddingOptionArray2[1] = ABSENT;
            paddingOptionArray2[2] = PRESENT_OPTIONAL;
            paddingOptionArray2[3] = ABSENT_OPTIONAL;
            return paddingOptionArray2;
        }

        static {
            $VALUES = PaddingOption.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

