/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FileSystemException;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FileTreeWalkKt;
import kotlin.io.FilesKt__UtilsKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a*\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0007\u001a*\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u0012\u0010\u000e\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\b\u0014\u001a&\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u001a8\u0010\u001b\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u001a\b\u0002\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u001a\n\u0010 \u001a\u00020\u0018*\u00020\u0001\u001a\u0012\u0010!\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001\u001a\u0012\u0010!\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\"\u001a\u00020\u0003\u001a\u0012\u0010#\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001\u001a\u0012\u0010#\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\"\u001a\u00020\u0003\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u0001\u001a\u0011\u0010$\u001a\u00020%*\u00020%H\u0002\u00a2\u0006\u0002\b&\u001a\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010'*\b\u0012\u0004\u0012\u00020\u00010'H\u0002\u00a2\u0006\u0002\b&\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0003\u001a\u0012\u0010*\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0001\u001a\u0012\u0010*\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0003\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006+"}, d2={"createTempDir", "Ljava/io/File;", "prefix", "", "suffix", "directory", "createTempFile", "extension", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath", "nameWithoutExtension", "getNameWithoutExtension", "toRelativeString", "base", "relativeTo", "relativeToOrSelf", "relativeToOrNull", "toRelativeStringOrNull", "toRelativeStringOrNull$FilesKt__UtilsKt", "copyTo", "target", "overwrite", "", "bufferSize", "", "copyRecursively", "onError", "Lkotlin/Function2;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "deleteRecursively", "startsWith", "other", "endsWith", "normalize", "Lkotlin/io/FilePathComponents;", "normalize$FilesKt__UtilsKt", "", "resolve", "relative", "resolveSibling", "kotlin-stdlib"}, xs="kotlin/io/FilesKt")
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nkotlin/io/FilesKt__UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,473:1\n1#2:474\n1288#3,3:475\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nkotlin/io/FilesKt__UtilsKt\n*L\n347#1:475,3\n*E\n"})
class FilesKt__UtilsKt
extends FilesKt__FileTreeWalkKt {
    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Avoid creating temporary directories in the default temp location with this function due to too wide permissions on the newly created directory. Use kotlin.io.path.createTempDirectory instead.")
    public static final File createTempDir(String prefix, String suffix, File directory) {
        File file;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        File dir = File.createTempFile(prefix, (String)var1_1, (File)var2_2);
        dir.delete();
        if (dir.mkdir()) {
            Intrinsics.checkNotNull(dir);
            return dir;
        }
        throw new IOException("Unable to create temporary directory " + file + '.');
    }

    public static /* synthetic */ File createTempDir$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Avoid creating temporary files in the default temp location with this function due to too wide permissions on the newly created file. Use kotlin.io.path.createTempFile instead or resort to java.io.File.createTempFile.")
    public static final File createTempFile(String prefix, String suffix, File directory) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        File file = File.createTempFile(string, (String)var1_1, (File)var2_2);
        Intrinsics.checkNotNullExpressionValue(file, "createTempFile(...)");
        return file;
    }

    public static /* synthetic */ File createTempFile$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    public static final String getExtension(File $this$extension) {
        File file;
        Intrinsics.checkNotNullParameter($this$extension, "<this>");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.substringAfterLast(string, '.', "");
    }

    public static final String getInvariantSeparatorsPath(File $this$invariantSeparatorsPath) {
        File file;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPath, "<this>");
        if (File.separatorChar != '/') {
            String string = $this$invariantSeparatorsPath.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            return StringsKt.replace$default(string, File.separatorChar, '/', false, 4, null);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        return string;
    }

    public static final String getNameWithoutExtension(File $this$nameWithoutExtension) {
        File file;
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "<this>");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.substringBeforeLast$default(string, ".", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final String toRelativeString(File $this$toRelativeString, File base) {
        Intrinsics.checkNotNullParameter($this$toRelativeString, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt($this$toRelativeString, base);
        if (string == null) {
            void var1_1;
            File file;
            throw new IllegalArgumentException("this and base files have different roots: " + file + " and " + var1_1 + '.');
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final File relativeTo(File $this$relativeTo, File base) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$relativeTo, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        return new File(FilesKt.toRelativeString(file, (File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final File relativeToOrSelf(File $this$relativeToOrSelf, File base) {
        String string;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$relativeToOrSelf, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        String string2 = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt($this$relativeToOrSelf, (File)var1_1);
        if (string2 != null) {
            String p0 = string2;
            return new File(string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final File relativeToOrNull(File $this$relativeToOrNull, File base) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$relativeToOrNull, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt($this$relativeToOrNull, (File)var1_1);
        if (string != null) {
            String string2;
            String p0 = string;
            return new File(string2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String toRelativeStringOrNull$FilesKt__UtilsKt(File $this$toRelativeStringOrNull, File base) {
        void var3_3;
        int i;
        FilePathComponents thisComponents = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents($this$toRelativeStringOrNull));
        FilePathComponents baseComponents = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents(base));
        if (!Intrinsics.areEqual(thisComponents.getRoot(), baseComponents.getRoot())) {
            return null;
        }
        int baseCount = baseComponents.getSize();
        int thisCount = thisComponents.getSize();
        int maxSameCount = Math.min(thisCount, baseCount);
        for (i = 0; i < maxSameCount && Intrinsics.areEqual(thisComponents.getSegments().get(i), baseComponents.getSegments().get(i)); ++i) {
        }
        int sameCount = i;
        StringBuilder res = new StringBuilder();
        int i2 = baseCount - 1;
        if (sameCount <= i2) {
            while (true) {
                if (Intrinsics.areEqual(baseComponents.getSegments().get(i2).getName(), "..")) {
                    return null;
                }
                res.append("..");
                if (i2 != sameCount) {
                    res.append(File.separatorChar);
                }
                if (i2 == sameCount) break;
                --i2;
            }
        }
        if (sameCount < var3_3) {
            FilePathComponents filePathComponents;
            void var2_2;
            if (sameCount < var2_2) {
                res.append(File.separatorChar);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)filePathComponents.getSegments(), sameCount);
            Appendable appendable = res;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue(string, "separator");
            CollectionsKt.joinTo$default(iterable, appendable, string, null, null, 0, null, null, 124, null);
        }
        return res.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final File copyTo(File $this$copyTo, File target2, boolean overwrite, int bufferSize) {
        void var1_1;
        block15: {
            Closeable closeable;
            block14: {
                Intrinsics.checkNotNullParameter($this$copyTo, "<this>");
                Intrinsics.checkNotNullParameter(target2, "target");
                if (!$this$copyTo.exists()) {
                    throw new NoSuchFileException($this$copyTo, null, "The source file doesn't exist.", 2, null);
                }
                if (target2.exists()) {
                    void var2_4;
                    if (var2_4 == false) {
                        throw new FileAlreadyExistsException($this$copyTo, (File)target2, "The destination file already exists.");
                    }
                    if (!target2.delete()) {
                        throw new FileAlreadyExistsException($this$copyTo, (File)target2, "Tried to overwrite the destination, but failed to delete it.");
                    }
                }
                if (!$this$copyTo.isDirectory()) break block14;
                if (!target2.mkdirs()) {
                    throw new FileSystemException($this$copyTo, (File)target2, "Failed to create target directory.");
                }
                break block15;
            }
            File file = target2.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            closeable = new FileInputStream((File)((Object)closeable));
            Throwable throwable = null;
            try {
                long l;
                FileInputStream input = (FileInputStream)closeable;
                Closeable closeable2 = new FileOutputStream((File)target2);
                Throwable throwable2 = null;
                try {
                    void var3_6;
                    FileOutputStream output = (FileOutputStream)closeable2;
                    l = ByteStreamsKt.copyTo(input, output, (int)var3_6);
                }
                catch (Throwable throwable3) {
                    try {
                        target2 = throwable3;
                        throwable2 = throwable3;
                        throw target2;
                    }
                    catch (Throwable target2) {
                        CloseableKt.closeFinally(closeable2, throwable2);
                        throw target2;
                    }
                }
                CloseableKt.closeFinally(closeable2, null);
                Long.valueOf(l);
            }
            catch (Throwable throwable4) {
                try {
                    Serializable target2 = throwable4;
                    throwable = throwable4;
                    throw target2;
                }
                catch (Throwable target2) {
                    CloseableKt.closeFinally(closeable, throwable);
                    throw target2;
                }
            }
            CloseableKt.closeFinally(closeable, null);
        }
        return var1_1;
    }

    public static /* synthetic */ File copyTo$default(File file, File file2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return FilesKt.copyTo(file, file2, bl, n);
    }

    public static final boolean copyRecursively(File $this$copyRecursively, File target, boolean overwrite, Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkNotNullParameter($this$copyRecursively, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(onError, "onError");
        if (!$this$copyRecursively.exists()) {
            return onError.invoke($this$copyRecursively, new NoSuchFileException($this$copyRecursively, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown($this$copyRecursively).onFail((arg_0, arg_1) -> FilesKt__UtilsKt.copyRecursively$lambda$4$FilesKt__UtilsKt(onError, arg_0, arg_1)).iterator();
            while (iterator2.hasNext()) {
                File src = iterator2.next();
                if (!src.exists()) {
                    if (onError.invoke(src, new NoSuchFileException(src, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
                String relPath = FilesKt.toRelativeString(src, $this$copyRecursively);
                File dstFile = new File(target, relPath);
                if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                    boolean bl;
                    boolean bl2 = !overwrite ? true : (dstFile.isDirectory() ? !FilesKt.deleteRecursively(dstFile) : (bl = !dstFile.delete()));
                    if (bl2) {
                        if (onError.invoke(dstFile, new FileAlreadyExistsException(src, dstFile, "The destination file already exists.")) != OnErrorAction.TERMINATE) continue;
                        return false;
                    }
                }
                if (src.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(src, dstFile, overwrite, 0, 4, null).length() == src.length() || onError.invoke(src, new IOException("Source file wasn't copied completely, length of destination file differs.")) != OnErrorAction.TERMINATE) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException terminateException) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, bl, function2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean deleteRecursively(File $this$deleteRecursively) {
        boolean bl;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter($this$deleteRecursively, "<this>");
        Iterator $this$fold$iv = FilesKt.walkBottomUp($this$deleteRecursively);
        boolean accumulator$iv = true;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_3;
            void var1_2;
            Object element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean res = accumulator$iv;
            bl = (it.delete() || !var1_2.exists()) && var2_3 != false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean startsWith(File $this$startsWith, File other) {
        void var1_1;
        FilePathComponents filePathComponents;
        Intrinsics.checkNotNullParameter($this$startsWith, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        FilePathComponents components = FilesKt.toComponents($this$startsWith);
        FilePathComponents otherComponents = FilesKt.toComponents(other);
        if (!Intrinsics.areEqual(components.getRoot(), otherComponents.getRoot())) {
            return false;
        }
        if (components.getSize() < otherComponents.getSize()) {
            return false;
        }
        return ((Object)filePathComponents.getSegments().subList(0, otherComponents.getSize())).equals(var1_1.getSegments());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean startsWith(File $this$startsWith, String other) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$startsWith, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return FilesKt.startsWith(file, new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean endsWith(File $this$endsWith, File other) {
        void var3_4;
        void var2_3;
        void var0_1;
        Intrinsics.checkNotNullParameter($this$endsWith, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        FilePathComponents components = FilesKt.toComponents($this$endsWith);
        FilePathComponents otherComponents = FilesKt.toComponents(other);
        if (otherComponents.isRooted()) {
            void var1_2;
            return Intrinsics.areEqual($this$endsWith, var1_2);
        }
        int shift = components.getSize() - otherComponents.getSize();
        if (shift < 0) {
            return false;
        }
        return ((Object)components.getSegments().subList((int)var0_1, var2_3.getSize())).equals(var3_4.getSegments());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean endsWith(File $this$endsWith, String other) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$endsWith, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return FilesKt.endsWith(file, new File((String)var1_1));
    }

    public static final File normalize(File $this$normalize) {
        FilePathComponents filePathComponents;
        Intrinsics.checkNotNullParameter($this$normalize, "<this>");
        FilePathComponents $this$normalize_u24lambda_u246 = FilesKt.toComponents($this$normalize);
        File file = $this$normalize_u24lambda_u246.getRoot();
        Iterable iterable = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents.getSegments());
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue(string, "separator");
        return FilesKt.resolve(file, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null));
    }

    private static final FilePathComponents normalize$FilesKt__UtilsKt(FilePathComponents $this$normalize) {
        FilePathComponents filePathComponents;
        return new FilePathComponents($this$normalize.getRoot(), FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents.getSegments()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> normalize$FilesKt__UtilsKt(List<? extends File> $this$normalize) {
        void var1_1;
        Iterator<? extends File> iterator2;
        List list = new ArrayList($this$normalize.size());
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            File file = (File)iterator2.next();
            String string = file.getName();
            if (Intrinsics.areEqual(string, ".")) continue;
            if (Intrinsics.areEqual(string, "..")) {
                if (!list.isEmpty() && !Intrinsics.areEqual(((File)CollectionsKt.last(list)).getName(), "..")) {
                    List list2 = list;
                    list2.remove(list2.size() - 1);
                    continue;
                }
                list.add(file);
                continue;
            }
            list.add(var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final File resolve(File $this$resolve, File relative) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$resolve, "<this>");
        Intrinsics.checkNotNullParameter(relative, "relative");
        if (FilesKt.isRooted(relative)) {
            return relative;
        }
        String string2 = $this$resolve.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String baseName = string2;
        if (((CharSequence)string2).length() == 0 || StringsKt.endsWith$default((CharSequence)baseName, File.separatorChar, false, 2, null)) {
            return new File((String)baseName + relative);
        }
        return new File((String)string + File.separatorChar + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final File resolve(File $this$resolve, String relative) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$resolve, "<this>");
        Intrinsics.checkNotNullParameter(relative, "relative");
        return FilesKt.resolve(file, new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final File resolveSibling(File $this$resolveSibling, File relative) {
        void var1_1;
        void var2_2;
        FilePathComponents filePathComponents;
        Intrinsics.checkNotNullParameter($this$resolveSibling, "<this>");
        Intrinsics.checkNotNullParameter(relative, "relative");
        FilePathComponents components = FilesKt.toComponents($this$resolveSibling);
        File parentSubPath = components.getSize() == 0 ? new File("..") : components.subPath(0, components.getSize() - 1);
        return FilesKt.resolve(FilesKt.resolve(filePathComponents.getRoot(), (File)var2_2), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final File resolveSibling(File $this$resolveSibling, String relative) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$resolveSibling, "<this>");
        Intrinsics.checkNotNullParameter(relative, "relative");
        return FilesKt.resolveSibling(file, new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit copyRecursively$lambda$4$FilesKt__UtilsKt(Function2 $onError, File f, IOException e) {
        void var2_2;
        Function2 function2;
        Intrinsics.checkNotNullParameter(f, "f");
        Intrinsics.checkNotNullParameter(e, "e");
        if (function2.invoke(f, var2_2) == OnErrorAction.TERMINATE) {
            void var1_1;
            throw new TerminateException((File)var1_1);
        }
        return Unit.INSTANCE;
    }
}

