/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \\*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\\B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007B\u0017\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0004H\u0083\b\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0011\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0083\bJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u000b\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010%\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u000b\u0010&\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010'\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u0013\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020\u00152\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u000b\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010-\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u000b\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010/\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u0015\u00100\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u001d\u00100\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J\u0016\u00104\u001a\u00020\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u001e\u00104\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0016\u00105\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001e\u00106\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00107J\u0016\u00108\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00101J\u0015\u00109\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u0015\u0010;\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u0015\u0010<\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u0015\u0010=\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010>\u001a\u00020\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0016\u0010?\u001a\u00020\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u001d\u0010@\u001a\u00020\"2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0BH\u0082\bJ\b\u0010C\u001a\u00020\u0015H\u0016J'\u0010D\u001a\b\u0012\u0004\u0012\u0002HE0\r\"\u0004\b\u0001\u0010E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HE0\rH\u0016\u00a2\u0006\u0002\u0010GJ\u0015\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0016\u00a2\u0006\u0002\u0010HJ\u0018\u0010I\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0014J\u0018\u0010L\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0002J\u0018\u0010M\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0002J\u0018\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u0004H\u0002J\b\u0010Q\u001a\u00020\u0015H\u0002J)\u0010R\u001a\b\u0012\u0004\u0012\u0002HE0\r\"\u0004\b\u0001\u0010E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HE0\rH\u0000\u00a2\u0006\u0004\bS\u0010GJ\u0017\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0000\u00a2\u0006\u0004\bS\u0010HJ\u001d\u0010T\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bUJM\u0010V\u001a\u00020\u00152>\u0010W\u001a:\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bY\u0012\b\bZ\u0012\u0004\b\b(\u000b\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\f\bY\u0012\b\bZ\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00150XH\u0000\u00a2\u0006\u0002\b[R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006]"}, d2={"Lkotlin/collections/ArrayDeque;", "E", "Lkotlin/collections/AbstractMutableList;", "initialCapacity", "", "<init>", "(I)V", "()V", "elements", "", "(Ljava/util/Collection;)V", "head", "elementData", "", "", "[Ljava/lang/Object;", "value", "size", "getSize", "()I", "ensureCapacity", "", "minCapacity", "copyElements", "newCapacity", "internalGet", "internalIndex", "(I)Ljava/lang/Object;", "positiveMod", "index", "negativeMod", "incremented", "decremented", "isEmpty", "", "first", "()Ljava/lang/Object;", "firstOrNull", "last", "lastOrNull", "addFirst", "element", "(Ljava/lang/Object;)V", "addLast", "removeFirst", "removeFirstOrNull", "removeLast", "removeLastOrNull", "add", "(Ljava/lang/Object;)Z", "(ILjava/lang/Object;)V", "copyCollectionElements", "addAll", "get", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "contains", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "remove", "removeAt", "removeAll", "retainAll", "filterInPlace", "predicate", "Lkotlin/Function1;", "clear", "toArray", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "()[Ljava/lang/Object;", "removeRange", "fromIndex", "toIndex", "removeRangeShiftPreceding", "removeRangeShiftSucceeding", "nullifyNonEmpty", "internalFromIndex", "internalToIndex", "registerModification", "testToArray", "testToArray$kotlin_stdlib", "testRemoveRange", "testRemoveRange$kotlin_stdlib", "internalStructure", "structure", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "internalStructure$kotlin_stdlib", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="1.4")
@SourceDebugExtension(value={"SMAP\nArrayDeque.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayDeque.kt\nkotlin/collections/ArrayDeque\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,660:1\n476#1,53:665\n476#1,53:718\n37#2:661\n36#2,3:662\n*S KotlinDebug\n*F\n+ 1 ArrayDeque.kt\nkotlin/collections/ArrayDeque\n*L\n471#1:665,53\n473#1:718,53\n46#1:661\n46#1:662,3\n*E\n"})
public final class ArrayDeque<E>
extends AbstractMutableList<E> {
    public static final Companion Companion = new Companion(null);
    private int head;
    private Object[] elementData;
    private int size;
    private static final Object[] emptyElementData = new Object[0];
    private static final int defaultMinCapacity = 10;

    @Override
    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque(int initialCapacity) {
        Object[] objectArray;
        if (initialCapacity == 0) {
            objectArray = emptyElementData;
        } else if (initialCapacity > 0) {
            objectArray = new Object[initialCapacity];
        } else {
            void var1_1;
            throw new IllegalArgumentException("Illegal Capacity: " + (int)var1_1);
        }
        this.elementData = objectArray;
    }

    public ArrayDeque() {
        this.elementData = emptyElementData;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque(Collection<? extends E> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, "elements");
        void v0 = var1_1;
        var1_1 = v0;
        var1_1 = v0;
        this.elementData = v0.toArray(new Object[0]);
        this.size = this.elementData.length;
        if (this.elementData.length == 0) {
            this.elementData = emptyElementData;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int minCapacity) {
        void var1_1;
        if (minCapacity < 0) {
            throw new IllegalStateException("Deque is too big.");
        }
        if (minCapacity <= this.elementData.length) {
            return;
        }
        if (this.elementData == emptyElementData) {
            this.elementData = new Object[RangesKt.coerceAtLeast(minCapacity, 10)];
            return;
        }
        int newCapacity = AbstractList.Companion.newCapacity$kotlin_stdlib(this.elementData.length, minCapacity);
        this.copyElements((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void copyElements(int newCapacity) {
        void var1_2;
        Object[] newElements = new Object[newCapacity];
        ArraysKt.copyInto(this.elementData, newElements, 0, this.head, this.elementData.length);
        ArraysKt.copyInto(this.elementData, newElements, this.elementData.length - this.head, 0, this.head);
        this.head = 0;
        this.elementData = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private final E internalGet(int internalIndex) {
        void var1_1;
        return (E)this.elementData[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private final int positiveMod(int index) {
        void var1_1;
        if (index >= this.elementData.length) {
            return index - this.elementData.length;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final int negativeMod(int index) {
        void var1_1;
        if (index < 0) {
            return index + this.elementData.length;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private final int internalIndex(int index) {
        void var1_1;
        ArrayDeque arrayDeque = this;
        return arrayDeque.positiveMod(arrayDeque.head + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final int incremented(int index) {
        void var1_1;
        if (index == ArraysKt.getLastIndex(this.elementData)) {
            return 0;
        }
        return (int)(var1_1 + true);
    }

    /*
     * WARNING - void declaration
     */
    private final int decremented(int index) {
        void var1_1;
        if (index == 0) {
            return ArraysKt.getLastIndex(this.elementData);
        }
        return (int)(var1_1 - true);
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        return (E)this.elementData[this.head];
    }

    public final E firstOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)this.elementData[this.head];
    }

    public final E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this))];
    }

    public final E lastOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this))];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addFirst(E element) {
        void var1_1;
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        this.head = this.decremented(this.head);
        this.elementData[this.head] = var1_1;
        this.size = this.size() + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addLast(E element) {
        void var1_1;
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        ArrayDeque arrayDeque2 = this;
        this.elementData[arrayDeque2.positiveMod((int)(arrayDeque2.head + this.size()))] = var1_1;
        this.size = this.size() + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E removeFirst() {
        void var1_1;
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        Object element = this.elementData[this.head];
        this.elementData[this.head] = null;
        this.head = this.incremented(this.head);
        this.size = this.size() - 1;
        return var1_1;
    }

    public final E removeFirstOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeFirst();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E removeLast() {
        void var2_2;
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int internalLastIndex = arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this));
        Object element = this.elementData[internalLastIndex];
        this.elementData[var1_1] = null;
        this.size = this.size() - 1;
        return var2_2;
    }

    public final E removeLastOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeLast();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var1_1;
        this.addLast(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, E element) {
        void var3_3;
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.size());
        if (index == this.size()) {
            this.addLast(element);
            return;
        }
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        ArrayDeque arrayDeque2 = this;
        int internalIndex = arrayDeque2.positiveMod(arrayDeque2.head + index);
        if (index < this.size() + 1 >> 1) {
            int decrementedInternalIndex = this.decremented(internalIndex);
            ArrayDeque arrayDeque3 = this;
            int decrementedHead = arrayDeque3.decremented(arrayDeque3.head);
            if (decrementedInternalIndex >= this.head) {
                this.elementData[decrementedHead] = this.elementData[this.head];
                ArraysKt.copyInto(this.elementData, this.elementData, this.head, this.head + 1, decrementedInternalIndex + 1);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head - 1, this.head, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, decrementedInternalIndex + 1);
            }
            this.elementData[decrementedInternalIndex] = element;
            this.head = var3_3;
        } else {
            void var2_2;
            ArrayDeque arrayDeque4 = this;
            int tail = arrayDeque4.positiveMod(arrayDeque4.head + this.size());
            if (var3_3 < tail) {
                ArraysKt.copyInto(this.elementData, this.elementData, (int)(var3_3 + true), (int)var3_3, tail);
            } else {
                void var1_1;
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, (int)var1_1);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                ArraysKt.copyInto(this.elementData, this.elementData, (int)(var3_3 + true), (int)var3_3, this.elementData.length - 1);
            }
            this.elementData[var3_3] = var2_2;
        }
        this.size = this.size() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void copyCollectionElements(int internalIndex, Collection<? extends E> elements) {
        void var2_2;
        int index;
        Iterator<E> iterator2 = elements.iterator();
        int n = this.elementData.length;
        while (index < n && iterator2.hasNext()) {
            this.elementData[index] = iterator2.next();
            ++index;
        }
        n = this.head;
        for (index = 0; index < n && iterator2.hasNext(); ++index) {
            this.elementData[index] = iterator2.next();
        }
        this.size = this.size() + var2_2.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.isEmpty()) {
            return false;
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + elements.size());
        ArrayDeque arrayDeque2 = this;
        arrayDeque2.copyCollectionElements(arrayDeque2.positiveMod(arrayDeque2.head + this.size()), (Collection<? extends E>)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends E> elements) {
        void var3_3;
        Intrinsics.checkNotNullParameter(elements, "elements");
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.size());
        if (elements.isEmpty()) {
            return false;
        }
        if (index == this.size()) {
            return this.addAll(elements);
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + elements.size());
        ArrayDeque arrayDeque2 = this;
        int tail = arrayDeque2.positiveMod(arrayDeque2.head + this.size());
        ArrayDeque arrayDeque3 = this;
        int internalIndex = arrayDeque3.positiveMod(arrayDeque3.head + index);
        int elementsSize = elements.size();
        if (index < this.size() + 1 >> 1) {
            int shiftedHead = this.head - elementsSize;
            if (internalIndex >= this.head) {
                if (shiftedHead >= 0) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, internalIndex);
                } else {
                    int shiftToBack = this.elementData.length - (shiftedHead += this.elementData.length);
                    int elementsToShift = internalIndex - this.head;
                    if (shiftToBack >= elementsToShift) {
                        ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, internalIndex);
                    } else {
                        ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, this.head + shiftToBack);
                        ArraysKt.copyInto(this.elementData, this.elementData, 0, this.head + var3_3, internalIndex);
                    }
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, this.elementData.length);
                if (elementsSize >= internalIndex) {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - elementsSize, 0, internalIndex);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - elementsSize, 0, elementsSize);
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, elementsSize, internalIndex);
                }
            }
            this.head = shiftedHead;
            ArrayDeque arrayDeque4 = this;
            arrayDeque4.copyCollectionElements(arrayDeque4.negativeMod(internalIndex - elementsSize), elements);
        } else {
            void var2_2;
            int shiftedInternalIndex = internalIndex + elementsSize;
            if (internalIndex < var3_3) {
                if (var3_3 + elementsSize <= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex, internalIndex, (int)var3_3);
                } else if (shiftedInternalIndex >= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex - this.elementData.length, internalIndex, (int)var3_3);
                } else {
                    void shiftToFront = var3_3 + elementsSize - this.elementData.length;
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, (int)(var3_3 - shiftToFront), (int)var3_3);
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex, internalIndex, (int)(var3_3 - shiftToFront));
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, elementsSize, 0, (int)var3_3);
                if (shiftedInternalIndex >= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex - this.elementData.length, internalIndex, this.elementData.length);
                } else {
                    void var1_1;
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, this.elementData.length - elementsSize, this.elementData.length);
                    ArraysKt.copyInto(this.elementData, this.elementData, (int)var1_1, internalIndex, this.elementData.length - elementsSize);
                }
            }
            this.copyCollectionElements(internalIndex, (Collection<? extends E>)var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.size());
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E set(int index, E element) {
        void var3_3;
        void var2_2;
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.size());
        ArrayDeque arrayDeque = this;
        int internalIndex = arrayDeque.positiveMod(arrayDeque.head + index);
        Object oldElement = this.elementData[internalIndex];
        this.elementData[var1_1] = var2_2;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        return this.indexOf(var1_1) != -1;
    }

    @Override
    public final int indexOf(Object element) {
        block4: {
            int index;
            int tail;
            block3: {
                ArrayDeque arrayDeque = this;
                tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
                if (this.head >= tail) break block3;
                for (int index2 = this.head; index2 < tail; ++index2) {
                    if (!Intrinsics.areEqual(element, this.elementData[index2])) continue;
                    return index2 - this.head;
                }
                break block4;
            }
            if (this.head < tail) break block4;
            int n = this.elementData.length;
            for (index = this.head; index < n; ++index) {
                if (!Intrinsics.areEqual(element, this.elementData[index])) continue;
                return index - this.head;
            }
            for (index = 0; index < tail; ++index) {
                if (!Intrinsics.areEqual(element, this.elementData[index])) continue;
                return index + this.elementData.length - this.head;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object element) {
        int index;
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < tail) {
            int n = this.head;
            index = tail - 1;
            if (n <= index) {
                while (true) {
                    if (Intrinsics.areEqual(element, this.elementData[index])) {
                        return index - this.head;
                    }
                    if (index != n) {
                        --index;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.head > index) {
            --index;
            while (index >= 0) {
                if (Intrinsics.areEqual(element, this.elementData[index])) {
                    return index + this.elementData.length - this.head;
                }
                --index;
            }
            int n = this.head;
            index = ArraysKt.getLastIndex(this.elementData);
            if (n <= index) {
                while (true) {
                    if (Intrinsics.areEqual(element, this.elementData[index])) {
                        return index - this.head;
                    }
                    if (index == n) break;
                    --index;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object element) {
        void var1_2;
        int index = this.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove((int)var1_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E removeAt(int index) {
        void var3_3;
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.size());
        if (index == CollectionsKt.getLastIndex(this)) {
            return this.removeLast();
        }
        if (index == 0) {
            return this.removeFirst();
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int internalIndex = arrayDeque.positiveMod(arrayDeque.head + index);
        Object element = this.elementData[internalIndex];
        if (index < this.size() >> 1) {
            if (internalIndex >= this.head) {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, internalIndex);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, internalIndex);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, this.elementData.length - 1);
            }
            this.elementData[this.head] = null;
            this.head = this.incremented(this.head);
        } else {
            ArrayDeque arrayDeque2 = this;
            int internalLastIndex = arrayDeque2.positiveMod(arrayDeque2.head + CollectionsKt.getLastIndex(this));
            if (internalIndex <= internalLastIndex) {
                int n = internalIndex;
                ArraysKt.copyInto(this.elementData, this.elementData, n, n + 1, internalLastIndex + 1);
            } else {
                void var2_2;
                void v3 = var2_2;
                ArraysKt.copyInto(this.elementData, this.elementData, (int)v3, (int)(v3 + true), this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, internalLastIndex + 1);
            }
            this.elementData[var1_1] = null;
        }
        this.size = this.size() - 1;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        ArrayDeque this_$iv = this;
        if (this_$iv.isEmpty() || this_$iv.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque = this_$iv;
        int tail$iv = arrayDeque.positiveMod(arrayDeque.head + this_$iv.size());
        int newTail$iv = this_$iv.head;
        boolean modified$iv = false;
        if (this_$iv.head < tail$iv) {
            for (int index$iv = this_$iv.head; index$iv < tail$iv; ++index$iv) {
                Object element$iv = this_$iv.elementData[index$iv];
                Object it = element$iv;
                if (!elements.contains(it)) {
                    this_$iv.elementData[newTail$iv++] = element$iv;
                    continue;
                }
                modified$iv = true;
            }
            ArraysKt.fill(this_$iv.elementData, null, newTail$iv, tail$iv);
        } else {
            Object it;
            int index$iv;
            int element$iv = this_$iv.elementData.length;
            for (index$iv = this_$iv.head; index$iv < element$iv; ++index$iv) {
                Object element$iv2 = this_$iv.elementData[index$iv];
                this_$iv.elementData[index$iv] = null;
                it = element$iv2;
                if (!elements.contains(it)) {
                    this_$iv.elementData[newTail$iv++] = element$iv2;
                    continue;
                }
                modified$iv = true;
            }
            newTail$iv = this_$iv.positiveMod(newTail$iv);
            for (index$iv = 0; index$iv < tail$iv; ++index$iv) {
                Object element$iv3 = this_$iv.elementData[index$iv];
                this_$iv.elementData[index$iv] = null;
                it = element$iv3;
                if (!elements.contains(it)) {
                    this_$iv.elementData[newTail$iv] = element$iv3;
                    newTail$iv = this_$iv.incremented(newTail$iv);
                    continue;
                }
                modified$iv = true;
            }
        }
        if (modified$iv) {
            void var2_2;
            this_$iv.registerModification();
            this_$iv.size = this_$iv.negativeMod(newTail$iv - var2_2.head);
        }
        return modified$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        ArrayDeque this_$iv = this;
        if (this_$iv.isEmpty() || this_$iv.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque = this_$iv;
        int tail$iv = arrayDeque.positiveMod(arrayDeque.head + this_$iv.size());
        int newTail$iv = this_$iv.head;
        boolean modified$iv = false;
        if (this_$iv.head < tail$iv) {
            for (int index$iv = this_$iv.head; index$iv < tail$iv; ++index$iv) {
                Object element$iv = this_$iv.elementData[index$iv];
                Object it = element$iv;
                if (elements.contains(it)) {
                    this_$iv.elementData[newTail$iv++] = element$iv;
                    continue;
                }
                modified$iv = true;
            }
            ArraysKt.fill(this_$iv.elementData, null, newTail$iv, tail$iv);
        } else {
            Object it;
            int index$iv;
            int element$iv = this_$iv.elementData.length;
            for (index$iv = this_$iv.head; index$iv < element$iv; ++index$iv) {
                Object element$iv2 = this_$iv.elementData[index$iv];
                this_$iv.elementData[index$iv] = null;
                it = element$iv2;
                if (elements.contains(it)) {
                    this_$iv.elementData[newTail$iv++] = element$iv2;
                    continue;
                }
                modified$iv = true;
            }
            newTail$iv = this_$iv.positiveMod(newTail$iv);
            for (index$iv = 0; index$iv < tail$iv; ++index$iv) {
                Object element$iv3 = this_$iv.elementData[index$iv];
                this_$iv.elementData[index$iv] = null;
                it = element$iv3;
                if (elements.contains(it)) {
                    this_$iv.elementData[newTail$iv] = element$iv3;
                    newTail$iv = this_$iv.incremented(newTail$iv);
                    continue;
                }
                modified$iv = true;
            }
        }
        if (modified$iv) {
            void var2_2;
            this_$iv.registerModification();
            this_$iv.size = this_$iv.negativeMod(newTail$iv - var2_2.head);
        }
        return modified$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean filterInPlace(Function1<? super E, Boolean> predicate) {
        if (this.isEmpty() || this.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        int newTail = this.head;
        boolean modified = false;
        if (this.head < tail) {
            for (int index = this.head; index < tail; ++index) {
                Object element = this.elementData[index];
                if (predicate.invoke(element).booleanValue()) {
                    this.elementData[newTail++] = element;
                    continue;
                }
                modified = true;
            }
            ArraysKt.fill(this.elementData, null, newTail, tail);
        } else {
            int index;
            int element = this.elementData.length;
            for (index = this.head; index < element; ++index) {
                Object element2 = this.elementData[index];
                this.elementData[index] = null;
                if (predicate.invoke(element2).booleanValue()) {
                    this.elementData[newTail++] = element2;
                    continue;
                }
                modified = true;
            }
            newTail = this.positiveMod(newTail);
            for (index = 0; index < tail; ++index) {
                Object element3 = this.elementData[index];
                this.elementData[index] = null;
                if (predicate.invoke(element3).booleanValue()) {
                    this.elementData[newTail] = element3;
                    newTail = this.incremented(newTail);
                    continue;
                }
                modified = true;
            }
        }
        if (modified) {
            void var3_3;
            this.registerModification();
            this.size = this.negativeMod((int)(var3_3 - this.head));
        }
        return modified;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        if (!((Collection)this).isEmpty()) {
            void var1_1;
            this.registerModification();
            ArrayDeque arrayDeque = this;
            int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
            ArrayDeque arrayDeque2 = this;
            arrayDeque2.nullifyNonEmpty(arrayDeque2.head, (int)var1_1);
        }
        this.head = 0;
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, "array");
        Object[] dest = array.length >= this.size() ? array : ArraysKt.arrayOfNulls(array, this.size());
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < tail) {
            ArraysKt.copyInto$default(this.elementData, dest, 0, this.head, tail, 2, null);
        } else if (!((Collection)this).isEmpty()) {
            void var2_2;
            ArraysKt.copyInto(this.elementData, dest, 0, this.head, this.elementData.length);
            ArraysKt.copyInto(this.elementData, dest, this.elementData.length - this.head, 0, (int)var2_2);
        }
        return CollectionsKt.terminateCollectionToArray(this.size(), var1_1);
    }

    @Override
    public final Object[] toArray() {
        ArrayDeque arrayDeque = this;
        return arrayDeque.toArray(new Object[arrayDeque.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        void var3_3;
        int length;
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.size());
        int n = length = toIndex - fromIndex;
        if (length == 0) {
            return;
        }
        if (n == this.size()) {
            this.clear();
            return;
        }
        if (n == 1) {
            this.remove(fromIndex);
            return;
        }
        this.registerModification();
        if (fromIndex < this.size() - toIndex) {
            this.removeRangeShiftPreceding(fromIndex, toIndex);
            ArrayDeque arrayDeque = this;
            int newHead = arrayDeque.positiveMod(arrayDeque.head + length);
            ArrayDeque arrayDeque2 = this;
            arrayDeque2.nullifyNonEmpty(arrayDeque2.head, newHead);
            this.head = newHead;
        } else {
            void var2_2;
            void var1_1;
            this.removeRangeShiftSucceeding((int)var1_1, (int)var2_2);
            ArrayDeque arrayDeque = this;
            int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
            ArrayDeque arrayDeque3 = this;
            arrayDeque3.nullifyNonEmpty(arrayDeque3.negativeMod(tail - length), tail);
        }
        this.size = this.size() - var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRangeShiftPreceding(int fromIndex, int toIndex) {
        void copyCount;
        ArrayDeque arrayDeque = this;
        int copyFromIndex = arrayDeque.positiveMod(arrayDeque.head + (fromIndex - 1));
        ArrayDeque arrayDeque2 = this;
        int copyToIndex = arrayDeque2.positiveMod(arrayDeque2.head + (toIndex - 1));
        while (copyCount > 0) {
            int n = copyFromIndex + 1;
            int n2 = copyToIndex + 1;
            int segmentLength = Math.min((int)copyCount, Math.min(n, n2));
            ArraysKt.copyInto(this.elementData, this.elementData, copyToIndex - segmentLength + 1, copyFromIndex - segmentLength + 1, copyFromIndex + 1);
            copyFromIndex = this.negativeMod(copyFromIndex - segmentLength);
            copyToIndex = this.negativeMod(copyToIndex - segmentLength);
            copyCount -= segmentLength;
        }
    }

    private final void removeRangeShiftSucceeding(int fromIndex, int toIndex) {
        int segmentLength;
        ArrayDeque arrayDeque = this;
        int copyFromIndex = arrayDeque.positiveMod(arrayDeque.head + toIndex);
        ArrayDeque arrayDeque2 = this;
        int copyToIndex = arrayDeque2.positiveMod(arrayDeque2.head + fromIndex);
        for (int copyCount = this.size() - toIndex; copyCount > 0; copyCount -= segmentLength) {
            int n = this.elementData.length - copyFromIndex;
            int n2 = this.elementData.length - copyToIndex;
            segmentLength = Math.min(copyCount, Math.min(n, n2));
            int n3 = copyFromIndex;
            ArraysKt.copyInto(this.elementData, this.elementData, copyToIndex, n3, n3 + segmentLength);
            copyFromIndex = this.positiveMod(copyFromIndex + segmentLength);
            copyToIndex = this.positiveMod(copyToIndex + segmentLength);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void nullifyNonEmpty(int internalFromIndex, int internalToIndex) {
        void var2_2;
        void var1_1;
        if (internalFromIndex < internalToIndex) {
            ArraysKt.fill(this.elementData, null, internalFromIndex, internalToIndex);
            return;
        }
        ArraysKt.fill(this.elementData, null, (int)var1_1, this.elementData.length);
        ArraysKt.fill(this.elementData, null, 0, (int)var2_2);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T[] testToArray$kotlin_stdlib(T[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, "array");
        return this.toArray((T[])var1_1);
    }

    public final Object[] testToArray$kotlin_stdlib() {
        return this.toArray();
    }

    /*
     * WARNING - void declaration
     */
    public final void testRemoveRange$kotlin_stdlib(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        this.removeRange((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void internalStructure$kotlin_stdlib(Function2<? super Integer, ? super Object[], Unit> structure) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(structure, "structure");
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        int head = this.isEmpty() || this.head < tail ? this.head : this.head - this.elementData.length;
        var1_1.invoke((int)var2_2, this.toArray());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkotlin/collections/ArrayDeque$Companion;", "", "<init>", "()V", "emptyElementData", "", "[Ljava/lang/Object;", "defaultMinCapacity", "", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

