/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.GetPropertyAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBContextFactory;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;
import javax.xml.bind.ServiceLoaderUtil;

final class ContextFinder {
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static ServiceLoaderUtil.ExceptionHandler<JAXBException> EXCEPTION_HANDLER$33135ed1;

    /*
     * WARNING - void declaration
     */
    private static Throwable handleInvocationTargetException(InvocationTargetException x) throws JAXBException {
        InvocationTargetException invocationTargetException;
        Throwable t = x.getTargetException();
        if (t != null) {
            void var1_1;
            if (t instanceof JAXBException) {
                throw (JAXBException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            return var1_1;
        }
        return invocationTargetException;
    }

    /*
     * WARNING - void declaration
     */
    private static JAXBException handleClassCastException(Class originalType, Class targetType) {
        void var1_1;
        Class clazz;
        URL targetTypeURL = ContextFinder.which(targetType);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(clazz).getResource("javax/xml/bind/JAXBContext.class"), var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static JAXBContext newInstance(String contextPath, Class[] contextPathClasses, String className, ClassLoader classLoader, Map properties) throws JAXBException {
        try {
            void var3_3;
            void var1_1;
            String string;
            Class spFactory = ServiceLoaderUtil.safeLoadClass(className, "com.sun.xml.internal.bind.v2.ContextFactory", classLoader);
            return ContextFinder.newInstance(string, (Class[])var1_1, spFactory, (ClassLoader)var3_3, properties);
        }
        catch (ClassNotFoundException x) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), x);
        }
        catch (RuntimeException | JAXBException exception) {
            Exception x = exception;
            throw exception;
        }
        catch (Exception x) {
            void var2_2;
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", var2_2, x), x);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static JAXBContext newInstance(String contextPath, Class[] contextPathClasses, Class spFactory, ClassLoader classLoader, Map properties) throws JAXBException {
        Object context;
        try {
            Object obj;
            Method m;
            context = null;
            try {
                m = spFactory.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
                context = m.invoke(obj, contextPath, classLoader, properties);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (context == null) {
                void var3_4;
                String string;
                m = spFactory.getMethod("createContext", String.class, ClassLoader.class);
                obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
                context = m.invoke(obj, string, var3_4);
            }
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (InvocationTargetException invocationTargetException) {
            context = invocationTargetException;
            Throwable e = ContextFinder.handleInvocationTargetException(invocationTargetException);
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, e), e);
        }
        catch (Exception x) {
            void var1_2;
            void var2_3;
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", var2_3, x), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object instantiateProviderIfNecessary(Class<?> implClass) throws JAXBException {
        try {
            if (JAXBContextFactory.class.isAssignableFrom(implClass)) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(implClass){
                    private /* synthetic */ Class val$implClass;
                    {
                        this.val$implClass = clazz;
                    }

                    @Override
                    public final Object run() throws Exception {
                        return this.val$implClass.newInstance();
                    }
                });
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void var1_1;
            Class<?> clazz;
            PrivilegedActionException x = privilegedActionException;
            Throwable e = privilegedActionException.getCause() == null ? x : x.getCause();
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, e), (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static JAXBContext newInstance(Class[] classes, Map properties, String className) throws JAXBException {
        void var3_4;
        void var1_2;
        Class[] classArray;
        Class spi;
        try {
            spi = ServiceLoaderUtil.safeLoadClass(className, "com.sun.xml.internal.bind.v2.ContextFactory", ContextFinder.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            void var0_1;
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), (Throwable)var0_1);
        }
        if (logger.isLoggable(Level.FINE)) {
            void var2_3;
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{var2_3, ContextFinder.which(spi)});
        }
        return ContextFinder.newInstance(classArray, (Map)var1_2, (Class)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private static JAXBContext newInstance(Class[] classes, Map properties, Class spFactory) throws JAXBException {
        try {
            Object object;
            void var1_1;
            Method m = spFactory.getMethod("createContext", Class[].class, Map.class);
            Object obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
            Object context = m.invoke(obj, classes, var1_1);
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            void var3_4;
            throw new JAXBException((Throwable)var3_4);
        }
        catch (InvocationTargetException invocationTargetException) {
            void var2_2;
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable x = ContextFinder.handleInvocationTargetException(invocationTargetException);
            throw new JAXBException((Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static JAXBContext find(String factoryId, String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        void var3_3;
        void var2_2;
        void var1_1;
        Class factoryClassName;
        Object object;
        block7: {
            if (contextPath == null || contextPath.isEmpty()) {
                throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
            }
            String[] stringArray = factoryId;
            ClassLoader classLoader2 = classLoader;
            factoryId = contextPath;
            String[] stringArray2 = factoryId.split(":");
            factoryId = stringArray2;
            factoryId = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = factoryId[i];
                object2 = ((String)object2).replace('.', '/');
                String string = (String)object2 + "/jaxb.properties";
                object2 = classLoader2;
                object2 = object2 == null ? ClassLoader.getSystemResource(string) : ((ClassLoader)object2).getResource(string);
                if (object2 == null) continue;
                object = ContextFinder.classNameFromPackageProperties((URL)object2, stringArray, "javax.xml.bind.context.factory");
                break block7;
            }
            object = factoryClassName = null;
        }
        if (object != null) {
            return ContextFinder.newInstance(contextPath, null, (String)((Object)factoryClassName), classLoader, properties);
        }
        Class factoryName = ContextFinder.classNameFromSystemProperties();
        if (factoryName != null) {
            return ContextFinder.newInstance(contextPath, null, (String)((Object)factoryName), classLoader, properties);
        }
        Class obj = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER$33135ed1);
        if (obj != null) {
            obj.getClass();
            return obj.createContext$18cd5cc2();
        }
        obj = ContextFinder.firstByServiceLoaderDeprecated(JAXBContext.class, classLoader);
        if (obj != null) {
            return ContextFinder.newInstance(contextPath, null, (String)((Object)obj), classLoader, properties);
        }
        Class ctxFactory = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext", logger);
        if (ctxFactory != null) {
            Class clazz;
            return ContextFinder.newInstance(contextPath, null, clazz, classLoader, properties);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance((String)var1_1, null, "com.sun.xml.internal.bind.v2.ContextFactory", (ClassLoader)var2_2, (Map)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static JAXBContext find(Class<?>[] classes, Map<String, ?> properties) throws JAXBException {
        void var1_1;
        Class<?>[] classArray;
        String factoryClassName;
        logger.fine("Searching jaxb.properties");
        Class<?>[] classArray2 = classes;
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            String string;
            URL jaxbPropertiesUrl;
            Class<?> c = classArray2[i];
            if (c.getPackage() == null || (jaxbPropertiesUrl = c.getResource(string = "jaxb.properties")) == null) continue;
            factoryClassName = ContextFinder.classNameFromPackageProperties(jaxbPropertiesUrl, "javax.xml.bind.JAXBContextFactory", "javax.xml.bind.context.factory");
            return ContextFinder.newInstance((Class[])classes, properties, factoryClassName);
        }
        factoryClassName = ContextFinder.classNameFromSystemProperties();
        if (factoryClassName != null) {
            return ContextFinder.newInstance((Class[])classes, properties, classArray2);
        }
        JAXBContextFactory factory = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER$33135ed1);
        if (factory != null) {
            void var3_4;
            factory.getClass();
            return var3_4.createContext$663e6350();
        }
        String className = ContextFinder.firstByServiceLoaderDeprecated(JAXBContext.class, ContextFinder.getContextClassLoader());
        if (className != null) {
            return ContextFinder.newInstance((Class[])classes, properties, className);
        }
        logger.fine("Trying to create the platform default provider");
        Class ctxFactoryClass = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext", logger);
        if (ctxFactoryClass != null) {
            return ContextFinder.newInstance((Class[])classes, properties, ctxFactoryClass);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance((Class[])classArray, (Map)var1_1, "com.sun.xml.internal.bind.v2.ContextFactory");
    }

    /*
     * WARNING - void declaration
     */
    private static String classNameFromPackageProperties(URL packagePropertiesUrl, String ... factoryIds) throws JAXBException {
        void var1_1;
        String string;
        logger.log(Level.FINE, "Trying to locate {0}", packagePropertiesUrl.toString());
        Properties props = ContextFinder.loadJAXBProperties(packagePropertiesUrl);
        String[] stringArray = factoryIds;
        int cfr_ignored_0 = factoryIds.length;
        for (int i = 0; i < 2; ++i) {
            String factoryId = stringArray[i];
            if (!props.containsKey(factoryId)) continue;
            return props.getProperty(factoryId);
        }
        String propertiesUrl = packagePropertiesUrl.toExternalForm();
        String packageName = propertiesUrl.substring(0, stringArray.indexOf("/jaxb.properties"));
        throw new JAXBException(Messages.format("ContextFinder.MissingProperty", string, var1_1[0]));
    }

    /*
     * WARNING - void declaration
     */
    private static String classNameFromSystemProperties() throws JAXBException {
        String factoryClassName = ContextFinder.getSystemProperty("javax.xml.bind.JAXBContextFactory");
        if (factoryClassName != null) {
            return factoryClassName;
        }
        factoryClassName = ContextFinder.getDeprecatedSystemProperty("javax.xml.bind.context.factory");
        if (factoryClassName != null) {
            return factoryClassName;
        }
        factoryClassName = ContextFinder.getDeprecatedSystemProperty(JAXBContext.class.getName());
        if (factoryClassName != null) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String getDeprecatedSystemProperty(String property) {
        void var1_1;
        String value = ContextFinder.getSystemProperty(property);
        if (value != null) {
            String string;
            logger.log(Level.WARNING, "Using non-standard property: {0}. Property {1} should be used instead.", new Object[]{string, "javax.xml.bind.JAXBContextFactory"});
        }
        return var1_1;
    }

    private static String getSystemProperty(String property) {
        String string;
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new GetPropertyAction(property));
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static Properties loadJAXBProperties(URL url) throws JAXBException {
        try {
            void var2_3;
            logger.log(Level.FINE, "loading props from {0}", url);
            Properties props = new Properties();
            InputStream is = url.openStream();
            props.load(is);
            var2_3.close();
            return props;
        }
        catch (IOException ioe) {
            void var1_2;
            URL uRL;
            logger.log(Level.FINE, "Unable to load " + uRL.toString(), ioe);
            throw new JAXBException(ioe.toString(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static URL which(Class clazz, ClassLoader loader) {
        String string;
        void var1_1;
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = System.getSecurityManager() == null ? ClassLoader.getSystemClassLoader() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
        }
        return var1_1.getResource(string);
    }

    private static URL which(Class clazz) {
        Class clazz2 = clazz;
        return ContextFinder.which(clazz2, ContextFinder.getClassClassLoader(clazz2));
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader getClassClassLoader(Class c) {
        Class clazz;
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(clazz){
            private /* synthetic */ Class val$c;
            {
                this.val$c = clazz;
            }

            public final Object run() {
                return this.val$c.getClassLoader();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private static String firstByServiceLoaderDeprecated(Class spiClass, ClassLoader classLoader) throws JAXBException {
        String resource;
        block11: {
            String jaxbContextFQCN = spiClass.getName();
            logger.fine("Searching META-INF/services");
            BufferedReader r = null;
            resource = "META-INF/services/" + (String)jaxbContextFQCN;
            InputStream resourceStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(resource) : classLoader.getResourceAsStream(resource);
            if (resourceStream == null) break block11;
            r = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
            String factoryClassName = r.readLine();
            if (factoryClassName != null) {
                factoryClassName = factoryClassName.trim();
            }
            r.close();
            logger.log(Level.FINE, "Configured factorty class:{0}", factoryClassName);
            try {
                r.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Unable to close resource: " + (String)resource, ex);
            }
            return factoryClassName;
        }
        try {
            logger.log(Level.FINE, "Unable to load:{0}", resource);
            return null;
        }
        catch (IOException e) {
            try {
                void var1_2;
                throw new JAXBException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                try {
                    void ex;
                    if (ex != null) {
                        ex.close();
                    }
                }
                catch (IOException ex) {
                    void var2_6;
                    String string;
                    logger.log(Level.SEVERE, "Unable to close resource: " + (String)string, (Throwable)var2_6);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                void var0;
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler((Handler)var0);
            }
        }
        catch (Throwable throwable) {}
        EXCEPTION_HANDLER$33135ed1 = new ServiceLoaderUtil.ExceptionHandler<JAXBException>(){};
    }
}

