/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.IntSet;
import androidx.collection.ScatterMapKt;
import androidx.collection.internal.RuntimeHelpersKt;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0011\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0007J\u0019\u0010 \u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/collection/MutableIntSet;", "Landroidx/collection/IntSet;", "initialCapacity", "", "(I)V", "growthLimit", "add", "", "element", "addAll", "elements", "", "adjustStorage", "", "clear", "dropDeletes", "findAbsoluteInsertIndex", "findFirstAvailableSlot", "hash1", "initializeGrowth", "initializeMetadata", "capacity", "initializeStorage", "minusAssign", "plusAssign", "remove", "removeAll", "removeElementAt", "index", "resizeStorage", "newCapacity", "trim", "writeMetadata", "value", "", "collection"})
@SourceDebugExtension(value={"SMAP\nIntSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntSet.kt\nandroidx/collection/MutableIntSet\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 IntSet.kt\nandroidx/collection/IntSet\n+ 6 IntSet.kt\nandroidx/collection/IntSetKt\n*L\n1#1,925:1\n46#2,5:926\n1804#3,6:931\n1956#3:950\n1820#3:954\n1728#3:971\n1724#3:974\n1925#3,3:978\n1939#3,3:982\n1865#3:986\n1853#3:988\n1847#3:989\n1860#3:994\n1948#3:996\n1728#3:1010\n1724#3:1013\n1925#3,3:1017\n1939#3,3:1021\n1865#3:1025\n1853#3:1027\n1847#3:1028\n1860#3:1033\n1948#3:1035\n1956#3:1057\n1820#3:1061\n1780#3:1073\n1804#3,6:1074\n1792#3:1080\n1791#3,4:1081\n1804#3,6:1085\n1724#3:1094\n1728#3:1095\n1925#3,3:1096\n1939#3,3:1099\n1865#3:1102\n1853#3:1103\n1847#3:1104\n1860#3:1105\n1948#3:1106\n1814#3:1107\n1770#3:1108\n1812#3:1109\n1770#3:1110\n1780#3:1111\n1804#3,6:1112\n1792#3:1118\n1791#3,4:1119\n1925#3,3:1123\n1956#3:1126\n1847#3:1127\n1770#3:1128\n1724#3:1132\n1728#3:1133\n1804#3,6:1134\n1770#3:1140\n1728#3:1141\n1804#3,6:1142\n1804#3,6:1148\n1728#3:1154\n1804#3,6:1155\n1817#3:1161\n1770#3:1162\n1724#3:1166\n1728#3:1167\n1780#3:1168\n1804#3,6:1169\n1792#3:1175\n1791#3,4:1176\n1804#3,6:1180\n1804#3,6:1186\n13600#4,2:937\n13600#4,2:1044\n262#5,4:939\n232#5,7:943\n243#5,3:951\n246#5,2:955\n266#5,2:957\n249#5,6:959\n268#5:965\n439#5:966\n440#5:970\n442#5,2:972\n444#5,3:975\n447#5:981\n448#5:985\n449#5:987\n450#5,4:990\n456#5:995\n457#5,8:997\n439#5:1005\n440#5:1009\n442#5,2:1011\n444#5,3:1014\n447#5:1020\n448#5:1024\n449#5:1026\n450#5,4:1029\n456#5:1034\n457#5,8:1036\n262#5,4:1046\n232#5,7:1050\n243#5,3:1058\n246#5,2:1062\n266#5,2:1064\n249#5,6:1066\n268#5:1072\n921#6,3:967\n921#6,3:1006\n921#6,3:1091\n921#6,3:1129\n921#6,3:1163\n*S KotlinDebug\n*F\n+ 1 IntSet.kt\nandroidx/collection/MutableIntSet\n*L\n496#1:926,5\n523#1:931,6\n592#1:950\n592#1:954\n604#1:971\n604#1:974\n604#1:978,3\n604#1:982,3\n604#1:986\n604#1:988\n604#1:989\n604#1:994\n604#1:996\n617#1:1010\n617#1:1013\n617#1:1017,3\n617#1:1021,3\n617#1:1025\n617#1:1027\n617#1:1028\n617#1:1033\n617#1:1035\n660#1:1057\n660#1:1061\n670#1:1073\n670#1:1074,6\n670#1:1080\n670#1:1081,4\n680#1:1085,6\n694#1:1094\n695#1:1095\n702#1:1096,3\n703#1:1099,3\n704#1:1102\n705#1:1103\n705#1:1104\n709#1:1105\n712#1:1106\n721#1:1107\n721#1:1108\n727#1:1109\n727#1:1110\n728#1:1111\n728#1:1112,6\n728#1:1118\n728#1:1119,4\n742#1:1123,3\n743#1:1126\n745#1:1127\n798#1:1128\n814#1:1132\n825#1:1133\n826#1:1134,6\n836#1:1140\n839#1:1141\n840#1:1142,6\n841#1:1148,6\n850#1:1154\n851#1:1155,6\n887#1:1161\n887#1:1162\n890#1:1166\n892#1:1167\n892#1:1168\n892#1:1169,6\n892#1:1175\n892#1:1176,4\n905#1:1180,6\n911#1:1186,6\n570#1:937,2\n639#1:1044,2\n592#1:939,4\n592#1:943,7\n592#1:951,3\n592#1:955,2\n592#1:957,2\n592#1:959,6\n592#1:965\n604#1:966\n604#1:970\n604#1:972,2\n604#1:975,3\n604#1:981\n604#1:985\n604#1:987\n604#1:990,4\n604#1:995\n604#1:997,8\n617#1:1005\n617#1:1009\n617#1:1011,2\n617#1:1014,3\n617#1:1020\n617#1:1024\n617#1:1026\n617#1:1029,4\n617#1:1034\n617#1:1036,8\n660#1:1046,4\n660#1:1050,7\n660#1:1058,3\n660#1:1062,2\n660#1:1064,2\n660#1:1066,6\n660#1:1072\n604#1:967,3\n617#1:1006,3\n693#1:1091,3\n813#1:1129,3\n889#1:1163,3\n*E\n"})
public final class MutableIntSet
extends IntSet {
    private int growthLimit;

    /*
     * WARNING - void declaration
     */
    public MutableIntSet(int initialCapacity) {
        super((byte)0);
        void var1_1;
        boolean bl = initialCapacity >= 0;
        if (!bl) {
            RuntimeHelpersKt.throwIllegalArgumentException("Capacity must be a positive value.");
        }
        this.initializeStorage(ScatterMapKt.unloadedCapacity((int)var1_1));
    }

    public /* synthetic */ MutableIntSet(int n, int n2) {
        this(6);
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeStorage(int initialCapacity) {
        void var1_1;
        int newCapacity;
        this._capacity = newCapacity = initialCapacity > 0 ? Math.max(7, ScatterMapKt.normalizeCapacity(initialCapacity)) : 0;
        this.initializeMetadata(newCapacity);
        this.elements = new int[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeMetadata(int capacity) {
        void var1_1;
        void var3_5;
        long[] lArray;
        long[] lArray2;
        MutableIntSet mutableIntSet = this;
        if (capacity == 0) {
            lArray2 = ScatterMapKt.EmptyGroup;
        } else {
            void $this$initializeMetadata_u24lambda_u241;
            int n = (capacity + 1 + 7 + 7 & 0xFFFFFFF8) >> 3;
            long[] lArray3 = lArray = new long[n];
            MutableIntSet mutableIntSet2 = mutableIntSet;
            ArraysKt.fill$default((long[])$this$initializeMetadata_u24lambda_u241, (long)-9187201950435737472L, (int)0, (int)0, (int)6, null);
            mutableIntSet = mutableIntSet2;
            lArray2 = lArray;
        }
        mutableIntSet.metadata = lArray2;
        long[] data$iv = this.metadata;
        int i$iv = capacity >> 3;
        int b$iv = (capacity & 7) << 3;
        data$iv[i$iv] = lArray[var3_5] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | 255L << var1_1;
        this.initializeGrowth();
    }

    private final void initializeGrowth() {
        MutableIntSet mutableIntSet = this;
        mutableIntSet.growthLimit = ScatterMapKt.loadedCapacity(mutableIntSet._capacity) - this._size;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(int element) {
        void var2_2;
        void var1_1;
        int oldSize = this._size;
        int index = this.findAbsoluteInsertIndex(element);
        this.elements[var3_3] = var1_1;
        return this._size != var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(IntSet elements) {
        void var2_2;
        MutableIntSet mutableIntSet;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int oldSize = this._size;
        long[] lArray = mutableIntSet;
        mutableIntSet = this;
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"elements");
        int[] nArray = lArray.elements;
        void v0 = lArray;
        lArray = v0;
        lArray = v0.metadata;
        int n = v0.metadata.length - 2;
        int n2 = 0;
        if (n >= 0) {
            while (true) {
                long l;
                long l2;
                if ((l2 & ((l = (l2 = lArray[n2])) ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int n3 = 8 - (~(n2 - n) >>> 31);
                    for (int i = 0; i < n3; ++i) {
                        long l3 = l2 & 0xFFL;
                        if (l3 < 128L) {
                            int n4 = (n2 << 3) + i;
                            int n5 = n4 = nArray[n4];
                            MutableIntSet mutableIntSet2 = mutableIntSet;
                            int n6 = mutableIntSet2.findAbsoluteInsertIndex(n5);
                            mutableIntSet2.elements[n6] = n5;
                        }
                        l2 >>= 8;
                    }
                    if (n3 != 8) break;
                }
                if (n2 == n) break;
                ++n2;
            }
        }
        return var2_2 != this._size;
    }

    /*
     * WARNING - void declaration
     */
    private final int findAbsoluteInsertIndex(int element) {
        void capacity$iv;
        void data$iv;
        void var2_2;
        long[] lArray;
        int hash$iv = Integer.hashCode(element) * -862048943;
        int hash = hash$iv ^ hash$iv << 16;
        int hash1 = hash >>> 7;
        int hash2 = hash & 0x7F;
        int probeMask = this._capacity;
        int probeOffset = hash1 & probeMask;
        int probeIndex = 0;
        while (true) {
            long g;
            long[] metadata$iv = this.metadata;
            int i$iv22 = probeOffset >> 3;
            int b$iv = (probeOffset & 7) << 3;
            long i$iv22 = g = metadata$iv[i$iv22] >>> b$iv | metadata$iv[i$iv22 + 1] << 64 - b$iv & -((long)b$iv) >> 63;
            long x$iv = g ^ 0x101010101010101L * (long)hash2;
            long m = x$iv - 0x101010101010101L & (x$iv ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
            while ((i$iv22 = m) != 0L) {
                long l = b$iv = m;
                int index = probeOffset + (Long.numberOfTrailingZeros(b$iv) >> 3) & probeMask;
                if (this.elements[index] == element) {
                    return index;
                }
                long $this$next$iv = m;
                m = $this$next$iv & $this$next$iv - 1L;
            }
            long $this$maskEmpty$iv = g;
            if (($this$maskEmpty$iv & ($this$maskEmpty$iv ^ 0xFFFFFFFFFFFFFFFFL) << 6 & 0x8080808080808080L) != 0L) break;
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
        int index = this.findFirstAvailableSlot(hash1);
        if (this.growthLimit == 0) {
            lArray = this.metadata;
            if (!((this.metadata[index >> 3] >> ((index & 7) << 3) & 0xFFL) == 254L)) {
                void var3_3;
                this.adjustStorage();
                index = this.findFirstAvailableSlot((int)var3_3);
            }
        }
        ++this._size;
        lArray = this.metadata;
        this.growthLimit -= (this.metadata[index >> 3] >> ((index & 7) << 3) & 0xFFL) == 128L ? 1 : 0;
        lArray = this.metadata;
        int m = this._capacity;
        long value$iv = (long)var2_2;
        int i$iv$iv = index >> 3;
        int b$iv$iv = (index & 7) << 3;
        data$iv[i$iv$iv] = data$iv[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
        int cloneIndex$iv = (index - 7 & capacity$iv) + (7 & capacity$iv);
        data$iv[cloneIndex$iv >> 3] = data$iv[index >> 3];
        return index;
    }

    private final int findFirstAvailableSlot(int hash1) {
        int probeMask = this._capacity;
        int probeOffset = hash1 & probeMask;
        int probeIndex = 0;
        while (true) {
            int b$iv;
            int i$iv;
            long[] metadata$iv;
            long $this$maskEmptyOrDeleted$iv;
            long l;
            long m;
            if ((m = l & (($this$maskEmptyOrDeleted$iv = (l = (metadata$iv = this.metadata)[i$iv = probeOffset >> 3] >>> (b$iv = (probeOffset & 7) << 3) | metadata$iv[i$iv + 1] << 64 - b$iv & -((long)b$iv) >> 63)) ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != 0L) {
                long l2 = m;
                return probeOffset + (Long.numberOfTrailingZeros(l2) >> 3) & probeMask;
            }
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
    }

    private final void adjustStorage() {
        if (this._capacity > 8 && Long.compareUnsigned(ULong.constructor-impl((long)(ULong.constructor-impl((long)this._size) << 5)), ULong.constructor-impl((long)(ULong.constructor-impl((long)this._capacity) * 25L))) <= 0) {
            this.dropDeletes();
            return;
        }
        MutableIntSet mutableIntSet = this;
        mutableIntSet.resizeStorage(ScatterMapKt.nextCapacity(mutableIntSet._capacity));
    }

    private final void dropDeletes() {
        long[] metadata = this.metadata;
        int capacity = this._capacity;
        int[] elements = this.elements;
        ScatterMapKt.convertMetadataForCleanup(metadata, capacity);
        int swapIndex = -1;
        int index = 0;
        while (index != capacity) {
            int i$iv2;
            int b$iv;
            long value$iv;
            int oldProbeIndex;
            int probeOffset;
            long m22 = metadata[index >> 3] >> ((index & 7) << 3) & 0xFFL;
            if (m22 == 128L) {
                swapIndex = index++;
                continue;
            }
            if (m22 != 254L) {
                ++index;
                continue;
            }
            int m22 = elements[index];
            int hash$iv = Integer.hashCode(m22) * -862048943;
            int hash = hash$iv ^ hash$iv << 16;
            int hash1 = hash >>> 7;
            int targetIndex = this.findFirstAvailableSlot(hash1);
            int newProbeIndex = (targetIndex - (probeOffset = hash1 & capacity) & capacity) / 8;
            if (newProbeIndex == (oldProbeIndex = (index - probeOffset & capacity) / 8)) {
                oldProbeIndex = hash & 0x7F;
                value$iv = oldProbeIndex;
                int i$iv2 = index >> 3;
                b$iv = (index & 7) << 3;
                metadata[i$iv2] = metadata[i$iv2] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                metadata[ArraysKt.getLastIndex((long[])metadata)] = Long.MIN_VALUE | metadata[0] & 0xFFFFFFFFFFFFFFL;
                ++index;
                continue;
            }
            long i$iv2 = metadata[targetIndex >> 3] >> ((targetIndex & 7) << 3) & 0xFFL;
            if (i$iv2 == 128L) {
                i$iv2 = hash & 0x7F;
                value$iv = i$iv2;
                i$iv2 = targetIndex >> 3;
                b$iv = (targetIndex & 7) << 3;
                metadata[i$iv2] = metadata[i$iv2] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                i$iv2 = index >> 3;
                b$iv = (index & 7) << 3;
                metadata[i$iv2] = metadata[i$iv2] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | 128L << b$iv;
                elements[targetIndex] = elements[index];
                elements[index] = 0;
                swapIndex = index;
            } else {
                i$iv2 = hash & 0x7F;
                value$iv = i$iv2;
                i$iv2 = targetIndex >> 3;
                b$iv = (targetIndex & 7) << 3;
                metadata[i$iv2] = metadata[i$iv2] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                if (swapIndex == -1) {
                    swapIndex = ScatterMapKt.findEmptySlot(metadata, index + 1, capacity);
                }
                elements[swapIndex] = elements[targetIndex];
                elements[targetIndex] = elements[index];
                elements[index] = elements[swapIndex];
                --index;
            }
            metadata[ArraysKt.getLastIndex((long[])metadata)] = Long.MIN_VALUE | metadata[0] & 0xFFFFFFFFFFFFFFL;
            ++index;
        }
        this.initializeGrowth();
    }

    private final void resizeStorage(int newCapacity) {
        long[] previousMetadata = this.metadata;
        int[] previousElements = this.elements;
        int previousCapacity = this._capacity;
        this.initializeStorage(newCapacity);
        long[] newMetadata = this.metadata;
        int[] newElements = this.elements;
        int capacity = this._capacity;
        for (int i = 0; i < previousCapacity; ++i) {
            if (!((previousMetadata[i >> 3] >> ((i & 7) << 3) & 0xFFL) < 128L)) continue;
            int previousElement = previousElements[i];
            int hash$iv = Integer.hashCode(previousElement) * -862048943;
            int hash = hash$iv ^ hash$iv << 16;
            int index = this.findFirstAvailableSlot(hash >>> 7);
            long value$iv = hash & 0x7F;
            int i$iv$iv = index >> 3;
            int b$iv$iv = (index & 7) << 3;
            newMetadata[i$iv$iv] = newMetadata[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
            int cloneIndex$iv = (index - 7 & capacity) + (7 & capacity);
            newMetadata[cloneIndex$iv >> 3] = newMetadata[index >> 3];
            newElements[index] = previousElement;
        }
    }

    public MutableIntSet() {
        this(0, 1);
    }
}

