/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.internal.Lock;
import androidx.collection.internal.LruHashMap;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u000f\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0007\u001a\u00020\u0005J/\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\b\u0010\u0019\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u001d\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010\u000f\u001a\u00020\u0005J\u0015\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010!\u001a\u00020\u00152\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\"\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010#J\u0006\u0010\u0010\u001a\u00020\u0005J\u001d\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010#J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/collection/LruCache;", "K", "", "V", "maxSize", "", "(I)V", "createCount", "evictionCount", "hitCount", "lock", "Landroidx/collection/internal/Lock;", "map", "Landroidx/collection/internal/LruHashMap;", "missCount", "putCount", "size", "create", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryRemoved", "", "evicted", "", "oldValue", "newValue", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "evictAll", "get", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "resize", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "snapshot", "", "toString", "", "trimToSize", "collection"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 LockExt.kt\nandroidx/collection/internal/LockExtKt\n+ 4 Lock.jvm.kt\nandroidx/collection/internal/Lock\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n46#2,5:376\n46#2,5:381\n32#2,5:406\n32#2,5:415\n23#3,3:386\n23#3,3:390\n23#3,3:394\n23#3,3:398\n23#3,3:402\n23#3,3:411\n23#3,3:420\n23#3,3:424\n23#3,3:428\n23#3,3:432\n23#3,3:436\n23#3,3:440\n23#3,3:444\n23#3,3:448\n23#3,3:454\n26#4:389\n26#4:393\n26#4:397\n26#4:401\n26#4:405\n26#4:414\n26#4:423\n26#4:427\n26#4:431\n26#4:435\n26#4:439\n26#4:443\n26#4:447\n26#4:451\n26#4:457\n1855#5,2:452\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n*L\n62#1:376,5\n85#1:381,5\n174#1:406,5\n252#1:415,5\n87#1:386,3\n100#1:390,3\n117#1:394,3\n144#1:398,3\n173#1:402,3\n202#1:411,3\n277#1:420,3\n284#1:424,3\n290#1:428,3\n296#1:432,3\n301#1:436,3\n306#1:440,3\n311#1:444,3\n320#1:448,3\n328#1:454,3\n87#1:389\n100#1:393\n117#1:397\n144#1:401\n173#1:405\n202#1:414\n277#1:423\n284#1:427\n290#1:431\n296#1:435\n301#1:439\n306#1:443\n311#1:447\n320#1:451\n328#1:457\n322#1:452,2\n*E\n"})
public class LruCache<K, V> {
    private int maxSize;
    private final LruHashMap<K, V> map;
    private final Lock lock;
    private int size;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(int maxSize) {
        boolean bl;
        this.maxSize = bl;
        bl = this.maxSize > 0;
        if (!bl) {
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        this.map = new LruHashMap(0, 0.75f);
        this.lock = new Lock();
    }

    /*
     * WARNING - void declaration
     */
    public void resize(int maxSize) {
        boolean bl = maxSize > 0;
        if (!bl) {
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            void var1_1;
            this.maxSize = maxSize;
            // ** MonitorExit[var2_4] (shouldn't be in output)
            this.trimToSize((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.lock;
        Lock lock2 = lock;
        Lock lock3 = lock;
        lock2 = lock;
        synchronized (lock) {
            Object mapValue222;
            block11: {
                mapValue222 = this.map.get(key);
                if (mapValue222 == null) break block11;
                int n = this.hitCount;
                this.hitCount = n + 1;
                key = mapValue222;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (V)key;
            }
            int n = this.missCount;
            this.missCount = n + 1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            V v = this.create(key);
            if (v == null) {
                return null;
            }
            V createdValue = v;
            Lock lock4 = this.lock;
            mapValue222 = lock4;
            mapValue222 = lock4;
            Lock lock5 = lock4;
            synchronized (lock4) {
                int mapValue222 = this.createCount;
                this.createCount = mapValue222 + 1;
                V mapValue222 = this.map.put(key, createdValue);
                if (mapValue222 != null) {
                    this.map.put(key, mapValue222);
                } else {
                    this.size += this.safeSizeOf(key, createdValue);
                }
                // ** MonitorExit[var4_10] (shouldn't be in output)
                if (mapValue222 != null) {
                    void var2_7;
                    void var1_1;
                    this.entryRemoved(false, var1_1, createdValue, mapValue222);
                    return var2_7;
                }
                LruCache lruCache = this;
                lruCache.trimToSize(lruCache.maxSize);
                return (V)lock2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        Lock lock3 = lock;
        synchronized (lock) {
            void var3_6;
            int n = this.putCount;
            this.putCount = n + 1;
            this.size += this.safeSizeOf(key, value);
            V previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            // ** MonitorExit[var4_7] (shouldn't be in output)
            if (previous != null) {
                void var2_3;
                void var1_1;
                this.entryRemoved(false, var1_1, previous, var2_3);
            }
            LruCache lruCache = this;
            lruCache.trimToSize(lruCache.maxSize);
            return var3_6;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void trimToSize(int maxSize) {
        while (true) {
            void var3_3;
            Map.Entry toEvict;
            Lock lock = this.lock;
            Lock lock2 = lock;
            lock2 = lock;
            Lock lock3 = lock;
            // MONITORENTER : lock
            boolean bl = this.size >= 0 && (!this.map.isEmpty() || this.size == 0);
            if (!bl) {
                RuntimeHelpersKt.throwIllegalStateException("LruCache.sizeOf() is reporting inconsistent results!");
            }
            if (this.size <= maxSize || this.map.isEmpty()) {
                // MONITOREXIT : lock3
                return;
            }
            if ((Map.Entry)CollectionsKt.firstOrNull((Iterable)this.map.getEntries()) == null) {
                // MONITOREXIT : lock3
                return;
            }
            Object key = toEvict.getKey();
            Object value = toEvict.getValue();
            this.map.remove(key);
            this.size -= this.safeSizeOf(key, value);
            int n = this.evictionCount;
            this.evictionCount = n + 1;
            // MONITOREXIT : lock3
            this.entryRemoved(true, lock2, var3_3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V remove(K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        Lock lock3 = lock;
        synchronized (lock) {
            V previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (previous != null) {
                void var1_1;
                this.entryRemoved(false, var1_1, previous, null);
            }
            return (V)lock2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
        void var3_3;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"oldValue");
    }

    protected V create(K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final int safeSizeOf(K key, V value) {
        void var3_3;
        int result = this.sizeOf(key, value);
        boolean bl = result >= 0;
        if (!bl) {
            void var2_2;
            void var1_1;
            RuntimeHelpersKt.throwIllegalStateException("Negative size: " + var1_1 + '=' + var2_2);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected int sizeOf(K key, V value) {
        void var2_2;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"value");
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final int size() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int maxSize() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.maxSize;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int hitCount() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.hitCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int missCount() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.missCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int createCount() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.createCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int putCount() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.putCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final int evictionCount() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            int n = this.evictionCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public final Map<K, V> snapshot() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            Map map;
            LinkedHashMap copy = new LinkedHashMap(this.map.getEntries().size());
            Object object = this.map.getEntries();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Map.Entry)object2;
                Object key = object2.getKey();
                Object value = object2.getValue();
                ((Map)copy).put(key, value);
            }
            map = map;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            void var2_2;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + (int)var2_2 + "%]";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }
}

