/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/compose/animation/core/FloatExponentialDecaySpec;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "frictionMultiplier", "", "absVelocityThreshold", "(FF)V", "getAbsVelocityThreshold", "()F", "friction", "getDurationNanos", "", "initialValue", "initialVelocity", "getTargetValue", "getValueFromNanos", "playTimeNanos", "getVelocityFromNanos", "animation-core"})
@StabilityInferred(parameters=1)
public final class FloatExponentialDecaySpec
implements FloatDecayAnimationSpec {
    private final float absVelocityThreshold;
    private final float friction;

    /*
     * WARNING - void declaration
     */
    public FloatExponentialDecaySpec(float frictionMultiplier, float absVelocityThreshold) {
        void var1_1;
        void var2_2;
        this.absVelocityThreshold = Math.max(1.0E-7f, Math.abs((float)var2_2));
        this.friction = -4.2f * Math.max(1.0E-4f, (float)var1_1);
    }

    private /* synthetic */ FloatExponentialDecaySpec(float f, float f2, int n) {
        this(1.0f, 0.1f);
    }

    @Override
    public final float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getValueFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        void var3_2;
        long playTimeMillis = playTimeNanos / 1000000L;
        return (float)(var3_2 - initialVelocity / this.friction + initialVelocity / this.friction * (float)Math.exp(this.friction * (float)playTimeMillis / 1000.0f));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getVelocityFromNanos$4875821f(long playTimeNanos, float initialVelocity) {
        void var3_2;
        long playTimeMillis = playTimeNanos / 1000000L;
        return (float)(var3_2 * (float)Math.exp((float)playTimeMillis / 1000.0f * this.friction));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos$2548a29(float initialVelocity) {
        void var1_1;
        FloatExponentialDecaySpec floatExponentialDecaySpec = this;
        return (long)(1000.0f * (float)Math.log(floatExponentialDecaySpec.absVelocityThreshold / Math.abs((float)var1_1)) / this.friction) * 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getTargetValue(float initialValue, float initialVelocity) {
        void var3_4;
        void var2_2;
        void var1_1;
        FloatExponentialDecaySpec floatExponentialDecaySpec;
        FloatExponentialDecaySpec floatExponentialDecaySpec2 = this;
        if (Math.abs(initialVelocity) <= floatExponentialDecaySpec.absVelocityThreshold) {
            return initialValue;
        }
        floatExponentialDecaySpec2 = this;
        double duration = Math.log(Math.abs(floatExponentialDecaySpec2.absVelocityThreshold / initialVelocity)) / (double)this.friction * 1000.0;
        return (float)(var1_1 - initialVelocity / this.friction + var2_2 / this.friction * (float)Math.exp((double)this.friction * var3_4 / 1000.0));
    }

    public FloatExponentialDecaySpec() {
        this(0.0f, 0.0f, 3);
    }
}

