/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.BezierKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/CubicBezierEasing;", "Landroidx/compose/animation/core/Easing;", "a", "", "b", "c", "d", "(FFFF)V", "max", "min", "equals", "", "other", "", "hashCode", "", "throwNoSolution", "", "fraction", "toString", "", "transform", "animation-core"})
@Immutable
@SourceDebugExtension(value={"SMAP\nEasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 5 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,172:1\n33#2,7:173\n48#3:180\n54#3:182\n22#4:181\n22#4:183\n71#5,16:184\n*S KotlinDebug\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n*L\n115#1:173,7\n120#1:180\n121#1:182\n120#1:181\n121#1:183\n149#1:184,16\n*E\n"})
public final class CubicBezierEasing
implements Easing {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final float min;
    private final float max;

    /*
     * WARNING - void declaration
     */
    public CubicBezierEasing(float a2, float b, float c, float d) {
        void var1_3;
        void var3_6;
        void var2_5;
        this.a = a2;
        this.b = var2_5;
        this.c = var3_6;
        this.d = d;
        boolean a2 = !Float.isNaN(this.a) && !Float.isNaN(this.b) && !Float.isNaN(this.c) && !Float.isNaN(this.d);
        if (!a2) {
            PreconditionsKt.throwIllegalArgumentException("Parameters to CubicBezierEasing cannot be NaN. Actual parameters are: " + this.a + ", " + this.b + ", " + this.c + ", " + this.d + '.');
        }
        float[] roots = new float[5];
        long extrema = BezierKt.computeCubicVerticalBounds((float)0.0f, (float)this.b, (float)this.d, (float)1.0f, (float[])var1_3, (int)0);
        int n = (int)(extrema >> 32);
        this.min = Float.intBitsToFloat(n);
        n = (int)extrema;
        this.max = Float.intBitsToFloat(n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final float transform(float fraction2) {
        void v2;
        void var1_1;
        if (fraction2 > 0.0f && fraction2 < 1.0f) {
            void var3_4;
            void var2_3;
            void minimumValue$iv;
            void v1;
            void $this$fastCoerceAtMost$iv$iv;
            void $this$fastCoerceIn$iv;
            float t = BezierKt.findFirstCubicRoot((float)(0.0f - fraction2), (float)(this.a - fraction2), (float)(this.c - fraction2), (float)(1.0f - fraction2));
            if (Float.isNaN(t)) {
                t = fraction2;
                CubicBezierEasing fraction2 = this;
                throw new IllegalArgumentException("The cubic curve with parameters (" + fraction2.a + ", " + fraction2.b + ", " + fraction2.c + ", " + fraction2.d + ") has no solution at " + t);
            }
            float fraction2 = BezierKt.evaluateCubic((float)this.b, (float)this.d, (float)t);
            t = this.min;
            float maximumValue$iv = this.max;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            void v0 = $this$fastCoerceAtMost$iv$iv = v1 < minimumValue$iv ? var2_3 : $this$fastCoerceAtLeast$iv$iv;
            if (!(v0 > maximumValue$iv)) return (float)var1_1;
            v2 = var3_4;
            return (float)v2;
        } else {
            v2 = var1_1;
        }
        return (float)v2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof CubicBezierEasing && this.a == ((CubicBezierEasing)other).a && this.b == ((CubicBezierEasing)other).b && this.c == ((CubicBezierEasing)other).c && this.d == ((CubicBezierEasing)var1_1).d;
    }

    public final int hashCode() {
        return ((Float.hashCode(this.a) * 31 + Float.hashCode(this.b)) * 31 + Float.hashCode(this.c)) * 31 + Float.hashCode(this.d);
    }

    public final String toString() {
        return "CubicBezierEasing(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ')';
    }
}

