/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.internal.ArraysKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005R\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/ArcSpline;", "", "arcModes", "", "timePoints", "", "y", "", "([I[F[[F)V", "arcs", "Landroidx/compose/animation/core/ArcSpline$Arc;", "[[Landroidx/compose/animation/core/ArcSpline$Arc;", "isExtrapolate", "", "getPos", "", "time", "", "v", "getSlope", "Arc", "Companion", "animation-core"})
@StabilityInferred(parameters=0)
public final class ArcSpline {
    private final Arc[][] arcs;
    private final boolean isExtrapolate;

    public ArcSpline(int[] arcModes, float[] timePoints, float[][] y) {
        Intrinsics.checkNotNullParameter((Object)arcModes, (String)"arcModes");
        Intrinsics.checkNotNullParameter((Object)timePoints, (String)"timePoints");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.isExtrapolate = true;
        int mode = 1;
        int last = 1;
        int n = timePoints.length - 1;
        Arc[][] arcArrayArray = new Arc[n][];
        ArcSpline arcSpline = this;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            switch (arcModes[n2]) {
                case 1: {
                    mode = 1;
                    last = 1;
                    break;
                }
                case 2: {
                    mode = 2;
                    last = 2;
                    break;
                }
                case 3: {
                    mode = last == 1 ? 2 : 1;
                    last = mode;
                    break;
                }
                case 0: {
                    mode = 3;
                    break;
                }
                case 5: {
                    mode = 5;
                    break;
                }
                case 4: {
                    mode = 4;
                }
            }
            int dim = y[n2].length / 2 + y[n2].length % 2;
            int n3 = 0;
            Arc[] arcArray = new Arc[dim];
            int n4 = n2;
            Arc[][] arcArrayArray2 = arcArrayArray;
            while (n3 < dim) {
                int n5;
                int n6 = n5 = n3++;
                int k = n6 << 1;
                arcArray[n6] = new Arc(mode, timePoints[n2], timePoints[n2 + 1], y[n2][k], y[n2][k + 1], y[n2 + 1][k], y[n2 + 1][k + 1]);
            }
            arcArrayArray2[n4] = arcArray;
        }
        arcSpline.arcs = arcArrayArray;
    }

    public final void getPos(float time, float[] v) {
        float t;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (this.isExtrapolate) {
            if (t < this.arcs[0][0].getTime1() || t > this.arcs[((Object[])this.arcs).length - 1][0].getTime2()) {
                float t0;
                int p;
                if (t > this.arcs[((Object[])this.arcs).length - 1][0].getTime2()) {
                    p = ((Object[])this.arcs).length - 1;
                    t0 = this.arcs[((Object[])this.arcs).length - 1][0].getTime2();
                } else {
                    p = 0;
                    t0 = this.arcs[0][0].getTime1();
                }
                float dt = t - t0;
                int i = 0;
                int j = 0;
                while (i < v.length) {
                    if (this.arcs[p][j].isLinear()) {
                        v[i] = this.arcs[p][j].getLinearX(t0) + dt * this.arcs[p][j].getLinearDX();
                        v[i + 1] = this.arcs[p][j].getLinearY(t0) + dt * this.arcs[p][j].getLinearDY();
                    } else {
                        this.arcs[p][j].setPoint(t0);
                        v[i] = this.arcs[p][j].calcX() + dt * this.arcs[p][j].calcDX();
                        v[i + 1] = this.arcs[p][j].calcY() + dt * this.arcs[p][j].calcDY();
                    }
                    i += 2;
                    ++j;
                }
                return;
            }
        } else {
            if (t < this.arcs[0][0].getTime1()) {
                t = this.arcs[0][0].getTime1();
            }
            if (t > this.arcs[((Object[])this.arcs).length - 1][0].getTime2()) {
                t = this.arcs[((Object[])this.arcs).length - 1][0].getTime2();
            }
        }
        boolean populated = false;
        int n = ((Object[])this.arcs).length;
        for (int i = 0; i < n; ++i) {
            int k = 0;
            int j = 0;
            while (j < v.length) {
                if (t <= this.arcs[i][k].getTime2()) {
                    if (this.arcs[i][k].isLinear()) {
                        v[j] = this.arcs[i][k].getLinearX(t);
                        v[j + 1] = this.arcs[i][k].getLinearY(t);
                        populated = true;
                    } else {
                        this.arcs[i][k].setPoint(t);
                        v[j] = this.arcs[i][k].calcX();
                        v[j + 1] = this.arcs[i][k].calcY();
                        populated = true;
                    }
                }
                j += 2;
                ++k;
            }
            if (!populated) continue;
            return;
        }
    }

    public final void getSlope(float time, float[] v) {
        float f;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float t = time;
        if (f < this.arcs[0][0].getTime1()) {
            t = this.arcs[0][0].getTime1();
        } else if (t > this.arcs[((Object[])this.arcs).length - 1][0].getTime2()) {
            t = this.arcs[((Object[])this.arcs).length - 1][0].getTime2();
        }
        boolean populated = false;
        int n = ((Object[])this.arcs).length;
        for (int i = 0; i < n; ++i) {
            int j = 0;
            int k = 0;
            while (j < v.length) {
                if (t <= this.arcs[i][k].getTime2()) {
                    if (this.arcs[i][k].isLinear()) {
                        v[j] = this.arcs[i][k].getLinearDX();
                        v[j + 1] = this.arcs[i][k].getLinearDY();
                        populated = true;
                    } else {
                        this.arcs[i][k].setPoint(t);
                        v[j] = this.arcs[i][k].calcDX();
                        v[j + 1] = this.arcs[i][k].calcDY();
                        populated = true;
                    }
                }
                j += 2;
                ++k;
            }
            if (!populated) continue;
            return;
        }
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0005J\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0005R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/compose/animation/core/ArcSpline$Arc;", "", "mode", "", "time1", "", "time2", "x1", "y1", "x2", "y2", "(IFFFFFF)V", "arcDistance", "arcVelocity", "ellipseA", "ellipseB", "ellipseCenterX", "ellipseCenterY", "isLinear", "", "()Z", "isVertical", "lut", "", "oneOverDeltaTime", "getTime1", "()F", "getTime2", "tmpCosAngle", "tmpSinAngle", "buildTable", "", "calcDX", "calcDY", "calcX", "calcY", "getLinearDX", "getLinearDY", "getLinearX", "time", "getLinearY", "lookup", "v", "setPoint", "Companion", "animation-core"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nArcSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n+ 2 ArcSpline.kt\nandroidx/compose/animation/core/ArcSplineKt\n*L\n1#1,388:1\n387#2:389\n*S KotlinDebug\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n*L\n323#1:389\n*E\n"})
    public static final class Arc {
        private static Companion Companion = new Companion(0);
        private final float time1;
        private final float time2;
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private float arcDistance;
        private float tmpSinAngle;
        private float tmpCosAngle;
        private final float[] lut;
        private final float oneOverDeltaTime;
        private final float ellipseA;
        private final float ellipseB;
        private final float ellipseCenterX;
        private final float ellipseCenterY;
        private final float arcVelocity;
        private final boolean isVertical;
        private final boolean isLinear;
        private static float[] _ourPercent;

        /*
         * WARNING - void declaration
         */
        public Arc(int mode, float time1, float time2, float x1, float y1, float x2, float y2) {
            void var1_1;
            boolean bl;
            this.time1 = time1;
            this.time2 = time2;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            float dx = this.x2 - this.x1;
            float dy = this.y2 - this.y1;
            switch (mode) {
                case 1: {
                    bl = true;
                    break;
                }
                case 5: {
                    if (dy < 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (dy > 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            this.isVertical = bl;
            this.oneOverDeltaTime = 1.0f / (this.time2 - this.time1);
            boolean isLinear = false;
            if (3 == var1_1) {
                isLinear = true;
            }
            if (isLinear || Math.abs(dx) < 0.001f || Math.abs(dy) < 0.001f) {
                isLinear = true;
                this.arcDistance = (float)Math.hypot(dy, dx);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
                this.ellipseCenterX = dx / (this.time2 - this.time1);
                this.ellipseCenterY = dy / (this.time2 - this.time1);
                this.lut = new float[101];
                this.ellipseA = Float.NaN;
                this.ellipseB = Float.NaN;
            } else {
                int n;
                float f;
                float f2;
                this.lut = new float[101];
                this.ellipseA = f2 * (float)(this.isVertical ? -1 : 1);
                this.ellipseB = f * (float)(this.isVertical ? 1 : -1);
                this.ellipseCenterX = this.isVertical ? this.x2 : this.x1;
                this.ellipseCenterY = this.isVertical ? this.y1 : this.y2;
                Arc arc = this;
                float f3 = this.y2;
                float f4 = this.x2;
                f = this.y1;
                f2 = arc.x1;
                Arc arc2 = arc;
                f2 = f4 - f2;
                f -= f3;
                f4 = 0.0f;
                f3 = 0.0f;
                float f5 = 0.0f;
                int n2 = Companion.access$getOurPercent(Companion).length;
                for (n = 0; n < n2; ++n) {
                    double d = 90.0 * (double)n / (double)(Companion.access$getOurPercent(Companion).length - 1);
                    float f6 = (float)(d / 180.0 * Math.PI);
                    float f7 = (float)Math.sin(f6);
                    float f8 = (float)Math.cos(f6);
                    float f9 = f2 * f7;
                    f6 = f * f8;
                    if (n > 0) {
                        Companion.access$getOurPercent((Companion)Arc.Companion)[n] = f5 += (float)Math.hypot(f9 - f4, f6 - f3);
                    }
                    f4 = f9;
                    f3 = f6;
                }
                arc2.arcDistance = f5;
                n = 0;
                n2 = Companion.access$getOurPercent(Companion).length;
                while (n < n2) {
                    float[] fArray = Companion.access$getOurPercent(Companion);
                    int n3 = n++;
                    fArray[n3] = fArray[n3] / f5;
                }
                n2 = arc2.lut.length;
                for (n = 0; n < n2; ++n) {
                    float f10 = (float)n / (float)(arc2.lut.length - 1);
                    int n4 = 6;
                    int n5 = 0;
                    n4 = 0;
                    f = f10;
                    float[] fArray = Companion.access$getOurPercent(Companion);
                    int n6 = ArraysKt.binarySearch(fArray, f, 0, n5 = fArray.length);
                    if (n6 >= 0) {
                        arc2.lut[n] = (float)n6 / (float)(Companion.access$getOurPercent(Companion).length - 1);
                        continue;
                    }
                    if (n6 == -1) {
                        arc2.lut[n] = 0.0f;
                        continue;
                    }
                    int n7 = -n6 - 2;
                    int n8 = -n6 - 1;
                    arc2.lut[n] = f10 = ((float)n7 + (f10 - Companion.access$getOurPercent(Companion)[n7]) / (Companion.access$getOurPercent(Companion)[n8] - Companion.access$getOurPercent(Companion)[n7])) / (float)(Companion.access$getOurPercent(Companion).length - 1);
                }
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
            }
            this.isLinear = isLinear;
        }

        public final float getTime1() {
            return this.time1;
        }

        public final float getTime2() {
            return this.time2;
        }

        public final boolean isLinear() {
            return this.isLinear;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPoint(float time) {
            void var1_3;
            float f;
            float percent22;
            float f2 = percent22 = (this.isVertical ? this.time2 - time : time - this.time1) * this.oneOverDeltaTime;
            Arc percent22 = this;
            if (f2 <= 0.0f) {
                f = 0.0f;
            } else if (f2 >= 1.0f) {
                f = 1.0f;
            } else {
                int n = (int)(f2 *= (float)(percent22.lut.length - 1));
                float f3 = f2;
                f2 = f3 - (float)((int)f3);
                f = percent22.lut[n] + f2 * (percent22.lut[n + 1] - percent22.lut[n]);
            }
            float angle = 1.5707964f * f;
            this.tmpSinAngle = (float)Math.sin(angle);
            this.tmpCosAngle = (float)Math.cos((double)var1_3);
        }

        public final float calcX() {
            return this.ellipseCenterX + this.ellipseA * this.tmpSinAngle;
        }

        public final float calcY() {
            return this.ellipseCenterY + this.ellipseB * this.tmpCosAngle;
        }

        /*
         * WARNING - void declaration
         */
        public final float calcDX() {
            void var2_2;
            void var1_1;
            float vx = this.ellipseA * this.tmpCosAngle;
            float vy = -this.ellipseB * this.tmpSinAngle;
            float norm = this.arcVelocity / (float)Math.hypot(vx, vy);
            if (this.isVertical) {
                return -vx * norm;
            }
            return (float)(var1_1 * var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final float calcDY() {
            void var1_1;
            void var2_2;
            float vx = this.ellipseA * this.tmpCosAngle;
            float vy = -this.ellipseB * this.tmpSinAngle;
            float norm = this.arcVelocity / (float)Math.hypot(vx, vy);
            if (this.isVertical) {
                return -vy * norm;
            }
            return (float)(var2_2 * var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final float getLinearX(float time) {
            void var1_1;
            float t = (time - this.time1) * this.oneOverDeltaTime;
            return this.x1 + var1_1 * (this.x2 - this.x1);
        }

        /*
         * WARNING - void declaration
         */
        public final float getLinearY(float time) {
            void var1_1;
            float t = (time - this.time1) * this.oneOverDeltaTime;
            return this.y1 + var1_1 * (this.y2 - this.y1);
        }

        public final float getLinearDX() {
            return this.ellipseCenterX;
        }

        public final float getLinearDY() {
            return this.ellipseCenterY;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/compose/animation/core/ArcSpline$Arc$Companion;", "", "()V", "Epsilon", "", "_ourPercent", "", "ourPercent", "getOurPercent", "()[F", "animation-core"})
        public static final class Companion {
            private Companion() {
            }

            public static final /* synthetic */ float[] access$getOurPercent(Companion $this) {
                if (_ourPercent != null) {
                    float[] fArray = _ourPercent;
                    Intrinsics.checkNotNull((Object)fArray);
                    return fArray;
                }
                _ourPercent = new float[91];
                float[] fArray = _ourPercent;
                Intrinsics.checkNotNull((Object)fArray);
                return fArray;
            }

            public /* synthetic */ Companion(byte by) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/animation/core/ArcSpline$Companion;", "", "()V", "ArcAbove", "", "ArcBelow", "ArcStartFlip", "ArcStartHorizontal", "ArcStartLinear", "ArcStartVertical", "DownArc", "StartHorizontal", "StartLinear", "StartVertical", "UpArc", "animation-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

