/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Klass;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;

public class NativeMappedConverter
implements TypeConverter {
    private static final Map<Class<?>, Reference<NativeMappedConverter>> converters = new WeakHashMap();
    private final Class<?> type;
    private final Class<?> nativeType;
    private final NativeMapped instance;

    /*
     * WARNING - void declaration
     */
    public static NativeMappedConverter getInstance(Class<?> cls) {
        Map<Class<?>, Reference<NativeMappedConverter>> map = converters;
        synchronized (map) {
            void var2_3;
            Reference<NativeMappedConverter> r = converters.get(cls);
            NativeMappedConverter nmc = r != null ? r.get() : null;
            if (nmc == null) {
                Class<?> clazz;
                nmc = new NativeMappedConverter(cls);
                converters.put(clazz, new SoftReference<NativeMappedConverter>(nmc));
            }
            return var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public NativeMappedConverter(Class<?> type) {
        void var1_1;
        if (!NativeMapped.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Type must derive from " + NativeMapped.class);
        }
        this.type = var1_1;
        this.instance = this.defaultValue();
        this.nativeType = this.instance.nativeType();
    }

    public NativeMapped defaultValue() {
        if (this.type.isEnum()) {
            return (NativeMapped)this.type.getEnumConstants()[0];
        }
        return (NativeMapped)Klass.newInstance(this.type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        void var2_2;
        void var1_1;
        return this.instance.fromNative(var1_1, (FromNativeContext)var2_2);
    }

    @Override
    public Class<?> nativeType() {
        return this.nativeType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object toNative(Object value, ToNativeContext context) {
        void var1_1;
        if (value == null) {
            if (Pointer.class.isAssignableFrom(this.nativeType)) {
                return null;
            }
            value = this.defaultValue();
        }
        return ((NativeMapped)var1_1).toNative();
    }
}

