/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.SymbolProvider;
import com.sun.jna.internal.Cleaner;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeLibrary
implements Closeable {
    private static final Logger LOG = Logger.getLogger(NativeLibrary.class.getName());
    private static final Level DEBUG_LOAD_LEVEL = Native.DEBUG_LOAD ? Level.INFO : Level.FINE;
    private static final SymbolProvider NATIVE_SYMBOL_PROVIDER = new SymbolProvider(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final long getSymbolAddress(long handle, String name, SymbolProvider parent) {
            void var3_2;
            return Native.findSymbol(handle, (String)var3_2);
        }
    };
    private final Cleaner.Cleanable cleanable;
    private volatile long handle;
    private final String libraryName;
    private final String libraryPath;
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final SymbolProvider symbolProvider;
    private final int callFlags;
    private final String encoding;
    private final Map<String, ?> options;
    private static final Map<String, Reference<NativeLibrary>> libraries = new HashMap<String, Reference<NativeLibrary>>();
    private static final Map<String, List<String>> searchPaths = new ConcurrentHashMap<String, List<String>>();
    private static final LinkedHashSet<String> librarySearchPath = new LinkedHashSet();
    private static final int DEFAULT_OPEN_OPTIONS = -1;
    private static Method addSuppressedMethod;

    /*
     * WARNING - void declaration
     */
    private static String functionKey(String name, int flags, String encoding) {
        void var2_2;
        void var1_1;
        String string;
        return string + "|" + (int)var1_1 + "|" + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private NativeLibrary(String libraryName, String libraryPath, long handle, Map<String, ?> options) {
        Map<String, Function> map;
        int callingConvention;
        void var3_6;
        this.libraryName = this.getLibraryName(libraryName);
        this.libraryPath = libraryPath;
        this.handle = handle;
        this.cleanable = Cleaner.getCleaner().register(this, new NativeLibraryDisposer((long)var3_6));
        Object option = options.get("calling-convention");
        this.callFlags = callingConvention = option instanceof Number ? ((Number)option).intValue() : 0;
        this.options = options;
        SymbolProvider optionSymbolProvider = (SymbolProvider)options.get("symbol-provider");
        this.symbolProvider = optionSymbolProvider == null ? NATIVE_SYMBOL_PROVIDER : optionSymbolProvider;
        String encodingValue = (String)options.get("string-encoding");
        if (encodingValue == null) {
            encodingValue = Native.getDefaultStringEncoding();
        }
        this.encoding = map;
        if (Platform.isWindows() && "kernel32".equals(this.libraryName.toLowerCase())) {
            map = this.functions;
            synchronized (map) {
                void var2_4;
                NativeLibrary nativeLibrary = this;
                Function f = new Function(nativeLibrary, nativeLibrary, "GetLastError", 63, this.encoding){
                    final /* synthetic */ NativeLibrary this$0;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((NativeLibrary)var2_2, (String)var3_3, callFlags, encoding);
                    }

                    @Override
                    Object invoke(Object[] args, Class<?> returnType, boolean b, int fixedArgs) {
                        return Native.getLastError();
                    }

                    @Override
                    Object invoke(Method invokingMethod, Class<?>[] paramTypes, Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
                        return Native.getLastError();
                    }
                };
                this.functions.put(NativeLibrary.functionKey("GetLastError", this.callFlags, this.encoding), (Function)var2_4);
                return;
            }
        }
    }

    private static int openFlags(Map<String, ?> options) {
        Map<String, Object> opt = options.get("open-flags");
        if (opt instanceof Number) {
            Map<String, Object> map;
            return ((Number)((Object)map)).intValue();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static NativeLibrary loadLibrary(String libraryName, Map<String, ?> options) {
        void var1_1;
        String string;
        long handle;
        String libraryPath;
        block40: {
            String webstartPath;
            LOG.log(DEBUG_LOAD_LEVEL, "Looking for library '" + libraryName + "'");
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            boolean isAbsolutePath = new File(libraryName).isAbsolute();
            LinkedHashSet<String> searchPath = new LinkedHashSet<String>();
            int openFlags = NativeLibrary.openFlags(options);
            List<String> customPaths = searchPaths.get(libraryName);
            if (customPaths != null) {
                List<String> list = customPaths;
                synchronized (list) {
                    searchPath.addAll(customPaths);
                }
            }
            if ((webstartPath = Native.getWebStartLibraryPath(libraryName)) != null) {
                LOG.log(DEBUG_LOAD_LEVEL, "Adding web start path " + webstartPath);
                searchPath.add(webstartPath);
            }
            LOG.log(DEBUG_LOAD_LEVEL, "Adding paths from jna.library.path: " + System.getProperty("jna.library.path"));
            searchPath.addAll(NativeLibrary.initPaths("jna.library.path"));
            libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
            handle = 0L;
            try {
                LOG.log(DEBUG_LOAD_LEVEL, "Trying " + libraryPath);
                handle = Native.open(libraryPath, openFlags);
            }
            catch (UnsatisfiedLinkError e) {
                LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + e.getMessage());
                LOG.log(DEBUG_LOAD_LEVEL, "Adding system paths: " + librarySearchPath);
                exceptions.add(e);
                searchPath.addAll(librarySearchPath);
            }
            try {
                if (handle == 0L) {
                    libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
                    LOG.log(DEBUG_LOAD_LEVEL, "Trying " + libraryPath);
                    handle = Native.open(libraryPath, openFlags);
                    if (handle == 0L) {
                        throw new UnsatisfiedLinkError("Failed to load library '" + libraryName + "'");
                    }
                }
            }
            catch (UnsatisfiedLinkError ule) {
                void var2_2;
                void var3_10;
                block39: {
                    void e23;
                    LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + ule.getMessage());
                    exceptions.add(ule);
                    if (Platform.isAndroid()) {
                        try {
                            LOG.log(DEBUG_LOAD_LEVEL, "Preload (via System.loadLibrary) " + libraryName);
                            System.loadLibrary(libraryName);
                            handle = Native.open(libraryPath, openFlags);
                        }
                        catch (UnsatisfiedLinkError e22) {
                            LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + e22.getMessage());
                            exceptions.add(e22);
                        }
                    } else if (Platform.isLinux() || Platform.isFreeBSD()) {
                        LOG.log(DEBUG_LOAD_LEVEL, "Looking for version variants");
                        libraryPath = NativeLibrary.matchLibrary(libraryName, searchPath);
                        if (libraryPath != null) {
                            LOG.log(DEBUG_LOAD_LEVEL, "Trying " + libraryPath);
                            try {
                                handle = Native.open(libraryPath, openFlags);
                            }
                            catch (UnsatisfiedLinkError e23) {
                                LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + e23.getMessage());
                                exceptions.add(e23);
                            }
                        }
                    } else if (Platform.isMac() && !libraryName.endsWith(".dylib")) {
                        for (String frameworkName : NativeLibrary.matchFramework(libraryName)) {
                            try {
                                LOG.log(DEBUG_LOAD_LEVEL, "Trying " + frameworkName);
                                handle = Native.open(frameworkName, openFlags);
                                break;
                            }
                            catch (UnsatisfiedLinkError e24) {
                                LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + e24.getMessage());
                                exceptions.add(e24);
                            }
                        }
                    } else if (Platform.isWindows() && e23 == false) {
                        LOG.log(DEBUG_LOAD_LEVEL, "Looking for lib- prefix");
                        libraryPath = NativeLibrary.findLibraryPath("lib" + libraryName, searchPath);
                        if (libraryPath != null) {
                            LOG.log(DEBUG_LOAD_LEVEL, "Trying " + libraryPath);
                            try {
                                handle = Native.open(libraryPath, openFlags);
                            }
                            catch (UnsatisfiedLinkError e25) {
                                LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + e25.getMessage());
                                exceptions.add(e25);
                            }
                        }
                    }
                    if (handle == 0L) {
                        try {
                            File embedded = Native.extractFromResourcePath(libraryName, (ClassLoader)options.get("classloader"));
                            if (embedded == null) break block39;
                            try {
                                handle = Native.open(embedded.getAbsolutePath(), openFlags);
                                libraryPath = embedded.getAbsolutePath();
                            }
                            finally {
                                if (Native.isUnpacked(embedded)) {
                                    Native.deleteLibrary(embedded);
                                }
                            }
                        }
                        catch (IOException e26) {
                            LOG.log(DEBUG_LOAD_LEVEL, "Loading failed with message: " + e26.getMessage());
                            exceptions.add(e26);
                        }
                    }
                }
                if (handle != 0L) break block40;
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to load library '");
                sb.append(libraryName);
                sb.append("':");
                for (Throwable t : exceptions) {
                    sb.append("\n");
                    sb.append(t.getMessage());
                }
                UnsatisfiedLinkError res = new UnsatisfiedLinkError(var3_10.toString());
                for (Throwable t : var2_2) {
                    NativeLibrary.addSuppressedReflected(res, t);
                }
                throw res;
            }
        }
        LOG.log(DEBUG_LOAD_LEVEL, "Found library '" + libraryName + "' at " + libraryPath);
        return new NativeLibrary(string, libraryPath, handle, (Map<String, ?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void addSuppressedReflected(Throwable target, Throwable suppressed) {
        if (addSuppressedMethod == null) {
            return;
        }
        try {
            void var1_2;
            addSuppressedMethod.invoke((Object)target, var1_2);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            void var0_1;
            throw new RuntimeException("Failed to call addSuppressedMethod", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static String[] matchFramework(String libraryName) {
        void var1_1;
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        File framework = new File(libraryName);
        if (framework.isAbsolute()) {
            if (libraryName.contains(".framework")) {
                if (framework.exists()) {
                    return new String[]{framework.getAbsolutePath()};
                }
                paths.add(framework.getAbsolutePath());
            } else {
                if ((framework = new File(new File(framework.getParentFile(), framework.getName() + ".framework"), framework.getName())).exists()) {
                    return new String[]{framework.getAbsolutePath()};
                }
                paths.add(framework.getAbsolutePath());
            }
        } else {
            String suffix;
            String[] PREFIXES = new String[]{System.getProperty("user.home"), "", "/System"};
            suffix = !libraryName.contains(".framework") ? libraryName + ".framework/" + libraryName : suffix;
            String[] stringArray = PREFIXES;
            int cfr_ignored_0 = PREFIXES.length;
            for (int i = 0; i < 3; ++i) {
                File file;
                String prefix = stringArray[i];
                if ((file = new File((String)((Object)file) + "/Library/Frameworks/" + suffix)).exists()) {
                    return new String[]{file.getAbsolutePath()};
                }
                paths.add(file.getAbsolutePath());
            }
        }
        return var1_1.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private String getLibraryName(String libraryName) {
        void var1_1;
        void var3_4;
        String suffix;
        int suffixStart;
        String simplified = libraryName;
        String template = NativeLibrary.mapSharedLibraryName("---");
        int prefixEnd = template.indexOf("---");
        if (prefixEnd > 0 && simplified.startsWith(template.substring(0, prefixEnd))) {
            simplified = simplified.substring(prefixEnd);
        }
        if ((suffixStart = simplified.indexOf(suffix = template.substring((int)(var3_4 + 3)))) != -1) {
            void var2_3;
            simplified = simplified.substring(0, (int)var2_3);
        }
        return var1_1;
    }

    public static final NativeLibrary getInstance(String libraryName) {
        return NativeLibrary.getInstance(libraryName, Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    public static final NativeLibrary getInstance(String libraryName, ClassLoader classLoader) {
        void var1_1;
        return NativeLibrary.getInstance(libraryName, Collections.singletonMap("classloader", var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final NativeLibrary getInstance(String libraryName, Map<String, ?> libraryOptions) {
        HashMap options = new HashMap(libraryOptions);
        if (options.get("calling-convention") == null) {
            options.put("calling-convention", 0);
        }
        if ((Platform.isLinux() || Platform.isFreeBSD() || Platform.isAIX()) && Platform.C_LIBRARY_NAME.equals(libraryName)) {
            libraryName = null;
        }
        Map<String, Reference<NativeLibrary>> map = libraries;
        synchronized (map) {
            Reference<NativeLibrary> ref = libraries.get(libraryName + options);
            NativeLibrary library = ref != null ? ref.get() : null;
            if (library == null) {
                library = libraryName == null ? new NativeLibrary("<process>", null, Native.open(null, NativeLibrary.openFlags(options)), options) : NativeLibrary.loadLibrary(libraryName, options);
                ref = new WeakReference<NativeLibrary>(library);
                libraries.put(library.getName() + options, ref);
                File file = library.getFile();
                if (file != null) {
                    void var3_4;
                    void var1_2;
                    File file2;
                    libraries.put(file.getAbsolutePath() + options, ref);
                    libraries.put(file2.getName() + var1_2, (Reference<NativeLibrary>)var3_4);
                }
            }
            return library;
        }
    }

    public static final synchronized NativeLibrary getProcess() {
        return NativeLibrary.getInstance(null);
    }

    public static final synchronized NativeLibrary getProcess(Map<String, ?> options) {
        Map<String, ?> map;
        return NativeLibrary.getInstance(null, map);
    }

    /*
     * WARNING - void declaration
     */
    public static final void addSearchPath(String libraryName, String path) {
        void var1_1;
        void var2_2;
        List<String> customPaths = searchPaths.get(libraryName);
        if (customPaths == null) {
            String string;
            customPaths = Collections.synchronizedList(new ArrayList());
            searchPaths.put(string, customPaths);
        }
        var2_2.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Function getFunction(String functionName) {
        void var1_1;
        return this.getFunction((String)var1_1, this.callFlags);
    }

    /*
     * WARNING - void declaration
     */
    Function getFunction(String name, Method method) {
        void var3_4;
        void var1_1;
        String prefix;
        FunctionMapper mapper = (FunctionMapper)this.options.get("function-mapper");
        if (mapper != null) {
            name = mapper.getFunctionName(this, method);
        }
        if (name.startsWith(prefix = System.getProperty("jna.profiler.prefix", "$$YJP$$"))) {
            name = name.substring(prefix.length());
        }
        int flags = this.callFlags;
        Class<?>[] etypes = method.getExceptionTypes();
        for (int i = 0; i < etypes.length; ++i) {
            if (!LastErrorException.class.isAssignableFrom(etypes[i])) continue;
            flags |= 0x40;
        }
        return this.getFunction((String)var1_1, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public Function getFunction(String functionName, int callFlags) {
        void var2_2;
        void var1_1;
        return this.getFunction((String)var1_1, (int)var2_2, this.encoding);
    }

    /*
     * WARNING - void declaration
     */
    public Function getFunction(String functionName, int callFlags, String encoding) {
        if (functionName == null) {
            throw new NullPointerException("Function name may not be null");
        }
        Map<String, Function> map = this.functions;
        synchronized (map) {
            String key = NativeLibrary.functionKey(functionName, callFlags, encoding);
            Function function = this.functions.get(key);
            if (function == null) {
                void var3_4;
                void var2_3;
                void var1_1;
                function = new Function(this, (String)var1_1, (int)var2_3, (String)var3_4);
                this.functions.put(key, function);
            }
            return function;
        }
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    /*
     * WARNING - void declaration
     */
    public Pointer getGlobalVariableAddress(String symbolName) {
        try {
            return new Pointer(this.getSymbolAddress(symbolName));
        }
        catch (UnsatisfiedLinkError e) {
            void var2_2;
            void var1_1;
            throw new UnsatisfiedLinkError("Error looking up '" + (String)var1_1 + "': " + var2_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    long getSymbolAddress(String name) {
        void var1_1;
        if (this.handle == 0L) {
            throw new UnsatisfiedLinkError("Library has been unloaded");
        }
        return this.symbolProvider.getSymbolAddress(this.handle, (String)var1_1, NATIVE_SYMBOL_PROVIDER);
    }

    public String toString() {
        return "Native Library <" + this.libraryPath + "@" + this.handle + ">";
    }

    public String getName() {
        return this.libraryName;
    }

    public File getFile() {
        if (this.libraryPath == null) {
            return null;
        }
        return new File(this.libraryPath);
    }

    /*
     * WARNING - void declaration
     */
    static void disposeAll() {
        Object values;
        Object object = libraries;
        synchronized (object) {
            values = new LinkedHashSet<Reference<NativeLibrary>>(libraries.values());
        }
        object = values.iterator();
        while (object.hasNext()) {
            void var0_1;
            values = (Reference)object.next();
            NativeLibrary lib = (NativeLibrary)((Reference)values).get();
            if (lib == null) continue;
            var0_1.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        HashSet<String> keys = new HashSet<String>();
        Object object = libraries;
        synchronized (object) {
            void var1_1;
            for (Map.Entry<String, Reference<NativeLibrary>> e : libraries.entrySet()) {
                Reference<NativeLibrary> reference = e.getValue();
                if (reference.get() != this) continue;
                keys.add(e.getKey());
            }
            for (String k : var1_1) {
                libraries.remove(k);
            }
        }
        object = this;
        synchronized (object) {
            if (this.handle != 0L) {
                this.handle = 0L;
                this.cleanable.clean();
            }
            return;
        }
    }

    @Deprecated
    public void dispose() {
        this.close();
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> initPaths(String key) {
        void var1_1;
        String value = System.getProperty(key, "");
        if ("".equals(value)) {
            return Collections.emptyList();
        }
        String st = new StringTokenizer(value, File.pathSeparator);
        ArrayList<void> list = new ArrayList<void>();
        while (((StringTokenizer)((Object)st)).hasMoreTokens()) {
            void var2_2;
            String path = ((StringTokenizer)((Object)st)).nextToken();
            if ("".equals(path)) continue;
            list.add(var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String findLibraryPath(String libName, Collection<String> searchPath) {
        String string;
        Iterator iterator;
        if (new File(libName).isAbsolute()) {
            return libName;
        }
        String name = NativeLibrary.mapSharedLibraryName(libName);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            void var2_2;
            String path = (String)iterator.next();
            File file = new File(path, name);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!Platform.isMac() || !name.endsWith(".dylib") || !(file = new File((String)var2_2, name.substring(0, name.lastIndexOf(".dylib")) + ".jnilib")).exists()) continue;
            return var3_3.getAbsolutePath();
        }
        return string;
    }

    static String mapSharedLibraryName(String libName) {
        String string;
        String name;
        if (Platform.isMac()) {
            if (libName.startsWith("lib") && (libName.endsWith(".dylib") || libName.endsWith(".jnilib"))) {
                return libName;
            }
            name = System.mapLibraryName(libName);
            if (name.endsWith(".jnilib")) {
                return name.substring(0, name.lastIndexOf(".jnilib")) + ".dylib";
            }
            return name;
        }
        if (Platform.isLinux() || Platform.isFreeBSD() ? NativeLibrary.isVersionedName(name) || name.endsWith(".so") : (Platform.isAIX() ? NativeLibrary.isVersionedName(name) || name.endsWith(".so") || name.startsWith("lib") || name.endsWith(".a") : Platform.isWindows() && (name.endsWith(".drv") || name.endsWith(".dll") || name.endsWith(".ocx")))) {
            return name;
        }
        String mappedName = System.mapLibraryName(name);
        if (Platform.isAIX() && mappedName.endsWith(".so")) {
            return mappedName.replaceAll(".so$", ".a");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isVersionedName(String name) {
        int so;
        if (name.startsWith("lib") && (so = name.lastIndexOf(".so.")) != -1 && so + 4 < name.length()) {
            for (int i = so + 4; i < name.length(); ++i) {
                void var2_2;
                char ch = name.charAt(i);
                if (Character.isDigit(ch) || var2_2 == 46) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static String matchLibrary(final String libName, Collection<String> searchPath) {
        void var1_1;
        File lib = new File(libName);
        if (lib.isAbsolute()) {
            searchPath = Arrays.asList(lib.getParent());
        }
        Iterator filter = new FilenameFilter(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean accept(File dir, String filename) {
                void var2_2;
                return (filename.startsWith("lib" + libName + ".so") || filename.startsWith(libName + ".so") && libName.startsWith("lib")) && NativeLibrary.isVersionedName((String)var2_2);
            }
        };
        Serializable matches = new LinkedList();
        for (String path : searchPath) {
            File[] files = new File(path).listFiles((FilenameFilter)((Object)filter));
            if (files == null || files.length <= 0) continue;
            matches.addAll(Arrays.asList(files));
        }
        double bestVersion = -1.0;
        Object bestMatch = null;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            double d;
            matches = (File)iterator.next();
            String path = ((File)matches).getAbsolutePath();
            String string = path.substring(path.lastIndexOf(".so.") + 4);
            double version = NativeLibrary.parseVersion(string);
            if (!(d > bestVersion)) continue;
            bestVersion = version;
            bestMatch = var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static double parseVersion(String ver) {
        void var1_1;
        double v = 0.0;
        double divisor = 1.0;
        int dot = ver.indexOf(".");
        while (ver != null) {
            String num;
            if (dot != -1) {
                num = ver.substring(0, dot);
                ver = ver.substring(dot + 1);
                dot = ver.indexOf(".");
            } else {
                num = ver;
                ver = null;
            }
            try {
                v += (double)Integer.parseInt(num) / divisor;
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
            divisor *= 100.0;
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getMultiArchPath() {
        void var2_2;
        void var1_1;
        void var0;
        String cpu = Platform.ARCH;
        String kernel = Platform.iskFreeBSD() ? "-kfreebsd" : (Platform.isGNU() ? "" : "-linux");
        String libc = "-gnu";
        if (Platform.isIntel()) {
            cpu = Platform.is64Bit() ? "x86_64" : "i386";
        } else if (Platform.isPPC()) {
            cpu = Platform.is64Bit() ? "powerpc64" : "powerpc";
        } else if (Platform.isARM()) {
            cpu = "arm";
            libc = "-gnueabi";
        } else if (Platform.ARCH.equals("mips64el")) {
            libc = "-gnuabi64";
        }
        return (String)var0 + (String)var1_1 + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList<String> getLinuxLdPaths() {
        void var0;
        ArrayList<void> ldPaths23332 = new ArrayList<void>();
        Process process = null;
        BufferedReader reader = null;
        try {
            String buffer;
            process = Runtime.getRuntime().exec("/sbin/ldconfig -p");
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((buffer = reader.readLine()) != null) {
                void var3_4;
                String path;
                int startPath = buffer.indexOf(" => ");
                int endPath = buffer.lastIndexOf(47);
                if (startPath == -1 || endPath == -1 || startPath >= endPath || ldPaths23332.contains(path = buffer.substring(startPath + 4, endPath))) continue;
                ldPaths23332.add(var3_4);
            }
        }
        catch (Exception exception) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process == null) return var0;
            try {
                process.waitFor();
                return var0;
            }
            catch (InterruptedException interruptedException) {
                return var0;
            }
        }
        catch (Throwable ldPaths23332) {
            if (reader != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (IOException iOException) {}
            }
            if (process == null) throw ldPaths23332;
            try {
                void var1_2;
                var1_2.waitFor();
                throw ldPaths23332;
            }
            catch (InterruptedException interruptedException) {}
            throw ldPaths23332;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        if (process == null) return var0;
        try {
            process.waitFor();
            return var0;
        }
        catch (InterruptedException interruptedException) {
            return var0;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        if (Native.POINTER_SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        addSuppressedMethod = null;
        try {
            addSuppressedMethod = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException ex) {
            Logger.getLogger(NativeLibrary.class.getName()).log(Level.SEVERE, "Failed to initialize 'addSuppressed' method", ex);
        }
        String webstartPath = Native.getWebStartLibraryPath("jnidispatch");
        if (webstartPath != null) {
            librarySearchPath.add(webstartPath);
        }
        if (System.getProperty("jna.platform.library.path") == null && !Platform.isWindows()) {
            String platformPath = "";
            String sep = "";
            String archPath = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD() || Platform.iskFreeBSD()) {
                archPath = (Platform.isSolaris() ? "/" : "") + (Native.POINTER_SIZE << 3);
            }
            String[] paths = new String[]{"/usr/lib" + archPath, "/lib" + archPath, "/usr/lib", "/lib"};
            if (Platform.isLinux() || Platform.iskFreeBSD() || Platform.isGNU()) {
                String multiArchPath = NativeLibrary.getMultiArchPath();
                paths = new String[]{"/usr/lib/" + multiArchPath, "/lib/" + multiArchPath, "/usr/lib" + archPath, "/lib" + archPath, "/usr/lib", "/lib"};
            }
            if (Platform.isLinux()) {
                ArrayList<String> ldPaths = NativeLibrary.getLinuxLdPaths();
                for (int i = paths.length - 1; i >= 0; --i) {
                    int found = ldPaths.indexOf(paths[i]);
                    if (found != -1) {
                        ldPaths.remove(found);
                    }
                    ldPaths.add(0, paths[i]);
                }
                paths = ldPaths.toArray(new String[0]);
            }
            for (int i = 0; i < paths.length; ++i) {
                void var2_5;
                File dir = new File(paths[i]);
                if (!dir.exists() || !var2_5.isDirectory()) continue;
                platformPath = platformPath + sep + paths[i];
                sep = File.pathSeparator;
            }
            if (!"".equals(platformPath)) {
                void var0_1;
                System.setProperty("jna.platform.library.path", (String)var0_1);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths("jna.platform.library.path"));
    }

    private static final class NativeLibraryDisposer
    implements Runnable {
        private long handle;

        /*
         * WARNING - void declaration
         */
        public NativeLibraryDisposer(long handle) {
            void var1_1;
            this.handle = var1_1;
        }

        @Override
        public final synchronized void run() {
            if (this.handle != 0L) {
                try {
                    Native.close(this.handle);
                    return;
                }
                finally {
                    this.handle = 0L;
                }
            }
        }
    }
}

