/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.dnsoverhttps;

import java.io.EOFException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import okio.Utf8;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/dnsoverhttps/DnsRecordCodec;", "", "()V", "ASCII", "Ljava/nio/charset/Charset;", "NXDOMAIN", "", "SERVFAIL", "TYPE_A", "TYPE_AAAA", "TYPE_PTR", "decodeAnswers", "", "Ljava/net/InetAddress;", "hostname", "", "byteString", "Lokio/ByteString;", "encodeQuery", "host", "type", "skipName", "", "source", "Lokio/Buffer;", "okhttp-dnsoverhttps"})
@SourceDebugExtension(value={"SMAP\nDnsRecordCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsRecordCodec.kt\nokhttp3/dnsoverhttps/DnsRecordCodec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n731#2,9:136\n1#3:145\n*S KotlinDebug\n*F\n+ 1 DnsRecordCodec.kt\nokhttp3/dnsoverhttps/DnsRecordCodec\n*L\n49#1:136,9\n*E\n"})
public final class DnsRecordCodec {
    public static final DnsRecordCodec INSTANCE = new DnsRecordCodec();
    private static final int SERVFAIL = 2;
    private static final int NXDOMAIN = 3;
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    private static final int TYPE_PTR = 12;
    private static final Charset ASCII = Charsets.US_ASCII;

    private DnsRecordCodec() {
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString encodeQuery(String host, int type) {
        void var2_2;
        List list;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Buffer $this$encodeQuery_u24lambda_u242 = buffer = new Buffer();
        buffer.writeShort(0);
        $this$encodeQuery_u24lambda_u242.writeShort(256);
        $this$encodeQuery_u24lambda_u242.writeShort(1);
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        Buffer nameBuf = new Buffer();
        char[] cArray = new char[1];
        Object object = cArray;
        cArray[0] = 46;
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)host, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (!$this$dropLastWhile$iv.isEmpty()) {
            List list2 = $this$dropLastWhile$iv;
            ListIterator iterator$iv = list2.listIterator(list2.size());
            while (iterator$iv.hasPrevious()) {
                String string = (String)iterator$iv.previous();
                if (((CharSequence)string).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        object = list;
        object = list.iterator();
        while (object.hasNext()) {
            String label = (String)object.next();
            long utf8ByteCount = Utf8.size$default((String)label, (int)0, (int)0, (int)3, null);
            if (!(utf8ByteCount == (long)label.length())) {
                host = "non-ascii hostname: " + host;
                throw new IllegalArgumentException(host.toString());
            }
            nameBuf.writeByte((int)utf8ByteCount);
            nameBuf.writeUtf8(label);
        }
        nameBuf.writeByte(0);
        nameBuf.copyTo($this$encodeQuery_u24lambda_u242, 0L, nameBuf.size());
        $this$encodeQuery_u24lambda_u242.writeShort((int)var2_2);
        $this$encodeQuery_u24lambda_u242.writeShort(1);
        return buffer.readByteString();
    }

    /*
     * WARNING - void declaration
     */
    public final List<InetAddress> decodeAnswers(String hostname, ByteString byteString) throws Exception {
        void var3_7;
        int i;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        List result = new ArrayList();
        Buffer buf = new Buffer();
        buf.write(byteString);
        buf.readShort();
        int flags = buf.readShort() & 0xFFFF;
        if (!(flags >> 15 != 0)) {
            hostname = "not a response";
            throw new IllegalArgumentException(hostname.toString());
        }
        switch (flags &= 0xF) {
            case 3: {
                throw new UnknownHostException(hostname + ": NXDOMAIN");
            }
            case 2: {
                throw new UnknownHostException(hostname + ": SERVFAIL");
            }
        }
        int questionCount = buf.readShort() & 0xFFFF;
        int answerCount = buf.readShort() & 0xFFFF;
        buf.readShort();
        buf.readShort();
        for (i = 0; i < questionCount; ++i) {
            this.skipName(buf);
            buf.readShort();
            buf.readShort();
        }
        block8: for (i = 0; i < answerCount; ++i) {
            this.skipName(buf);
            int type = buf.readShort() & 0xFFFF;
            buf.readShort();
            buf.readInt();
            int length = buf.readShort() & 0xFFFF;
            switch (type) {
                case 1: 
                case 28: {
                    void var1_4;
                    byte[] bytes = new byte[length];
                    buf.read(bytes);
                    InetAddress inetAddress = InetAddress.getByAddress((byte[])var1_4);
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(...)");
                    result.add(inetAddress);
                    continue block8;
                }
                default: {
                    buf.skip((long)length);
                }
            }
        }
        return var3_7;
    }

    private final void skipName(Buffer source) throws EOFException {
        byte length = source.readByte();
        if (length < 0) {
            source.skip(1L);
            return;
        }
        while (length > 0) {
            source.skip((long)length);
            length = source.readByte();
        }
    }
}

