/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.dnsoverhttps;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.dnsoverhttps.BootstrapDns;
import okhttp3.dnsoverhttps.DnsRecordCodec;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.ByteString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 +2\u00020\u0001:\u0002*+B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JF\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J>\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u0017H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J8\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u0017H\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\"H\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001fH\u0002R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0013\u0010\u0006\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0013\u0010\b\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0013\u0010\t\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0013\u0010\n\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\rR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000e\u00a8\u0006,"}, d2={"Lokhttp3/dnsoverhttps/DnsOverHttps;", "Lokhttp3/Dns;", "client", "Lokhttp3/OkHttpClient;", "url", "Lokhttp3/HttpUrl;", "includeIPv6", "", "post", "resolvePrivateAddresses", "resolvePublicAddresses", "(Lokhttp3/OkHttpClient;Lokhttp3/HttpUrl;ZZZZ)V", "()Lokhttp3/OkHttpClient;", "()Z", "()Lokhttp3/HttpUrl;", "buildRequest", "Lokhttp3/Request;", "hostname", "", "type", "", "", "networkRequests", "", "Lokhttp3/Call;", "results", "Ljava/net/InetAddress;", "failures", "Ljava/lang/Exception;", "Lkotlin/Exception;", "executeRequests", "", "responses", "getCacheOnlyResponse", "Lokhttp3/Response;", "request", "lookup", "lookupHttps", "processResponse", "response", "readResponse", "throwBestFailure", "Builder", "Companion", "okhttp-dnsoverhttps"})
@SourceDebugExtension(value={"SMAP\nDnsOverHttps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsOverHttps.kt\nokhttp3/dnsoverhttps/DnsOverHttps\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1#2:356\n*E\n"})
public final class DnsOverHttps
implements Dns {
    public static final Companion Companion = new Companion(null);
    private final OkHttpClient client;
    private final HttpUrl url;
    private final boolean includeIPv6;
    private final boolean post;
    private final boolean resolvePrivateAddresses;
    private final boolean resolvePublicAddresses;
    private static final MediaType DNS_MESSAGE = MediaType.Companion.get("application/dns-message");
    public static final int MAX_RESPONSE_SIZE = 65536;

    /*
     * WARNING - void declaration
     */
    public DnsOverHttps(OkHttpClient client, HttpUrl url, boolean includeIPv6, boolean post, boolean resolvePrivateAddresses, boolean resolvePublicAddresses) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.client = var1_1;
        this.url = var2_2;
        this.includeIPv6 = var3_3;
        this.post = post;
        this.resolvePrivateAddresses = resolvePrivateAddresses;
        this.resolvePublicAddresses = resolvePublicAddresses;
    }

    @JvmName(name="client")
    public final OkHttpClient client() {
        return this.client;
    }

    @JvmName(name="url")
    public final HttpUrl url() {
        return this.url;
    }

    @JvmName(name="includeIPv6")
    public final boolean includeIPv6() {
        return this.includeIPv6;
    }

    @JvmName(name="post")
    public final boolean post() {
        return this.post;
    }

    @JvmName(name="resolvePrivateAddresses")
    public final boolean resolvePrivateAddresses() {
        return this.resolvePrivateAddresses;
    }

    @JvmName(name="resolvePublicAddresses")
    public final boolean resolvePublicAddresses() {
        return this.resolvePublicAddresses;
    }

    /*
     * WARNING - void declaration
     */
    public final List<InetAddress> lookup(String hostname) throws UnknownHostException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (!this.resolvePrivateAddresses || !this.resolvePublicAddresses) {
            void var2_2;
            boolean privateHost = Companion.isPrivateHost$okhttp_dnsoverhttps(hostname);
            if (privateHost && !this.resolvePrivateAddresses) {
                throw new UnknownHostException("private hosts not resolved");
            }
            if (var2_2 == false && !this.resolvePublicAddresses) {
                throw new UnknownHostException("public hosts not resolved");
            }
        }
        return this.lookupHttps((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<InetAddress> lookupHttps(String hostname) throws UnknownHostException {
        void var3_3;
        void var1_1;
        List<InetAddress> list;
        ArrayList networkRequests = new ArrayList(2);
        ArrayList failures = new ArrayList(2);
        ArrayList results = new ArrayList(5);
        this.buildRequest(hostname, networkRequests, results, failures, 1);
        if (this.includeIPv6) {
            this.buildRequest(hostname, networkRequests, results, failures, 28);
        }
        this.executeRequests(hostname, (List<? extends Call>)list, results, failures);
        list = results;
        return list.isEmpty() ? this.throwBestFailure((String)var1_1, (List)var3_3) : list;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRequest(String hostname, List<Call> networkRequests, List<InetAddress> results, List<Exception> failures, int type) {
        void var2_2;
        Request request = this.buildRequest(hostname, type);
        Response response = this.getCacheOnlyResponse(request);
        if (response != null) {
            void var3_3;
            void var1_1;
            Response it = response;
            this.processResponse((Response)var2_2, (String)var1_1, (List<InetAddress>)var3_3, failures);
            return;
        }
        var2_2.add(this.client.newCall(request));
    }

    /*
     * WARNING - void declaration
     */
    private final void executeRequests(String hostname, List<? extends Call> networkRequests, List<InetAddress> responses, List<Exception> failures) {
        CountDownLatch latch = new CountDownLatch(networkRequests.size());
        networkRequests = networkRequests.iterator();
        while (networkRequests.hasNext()) {
            Call call = (Call)networkRequests.next();
            call.enqueue(new Callback(failures, latch, this, hostname, responses){
                final /* synthetic */ List<Exception> $failures;
                final /* synthetic */ CountDownLatch $latch;
                final /* synthetic */ DnsOverHttps this$0;
                final /* synthetic */ String $hostname;
                final /* synthetic */ List<InetAddress> $responses;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$failures = var1_1;
                    this.$latch = var2_2;
                    this.this$0 = var3_3;
                    this.$hostname = $hostname;
                    this.$responses = $responses;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void onFailure(Call call, IOException e) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    List<Exception> list = this.$failures;
                    List<Exception> list2 = this.$failures;
                    synchronized (list) {
                        void var2_2;
                        list2.add((Exception)var2_2);
                    }
                    this.$latch.countDown();
                }

                /*
                 * WARNING - void declaration
                 */
                public final void onResponse(Call call, Response response) {
                    void var2_2;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    DnsOverHttps.access$processResponse(this.this$0, (Response)var2_2, this.$hostname, this.$responses, this.$failures);
                    this.$latch.countDown();
                }
            });
        }
        try {
            latch.await();
            return;
        }
        catch (InterruptedException e) {
            void var2_3;
            failures.add((Exception)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processResponse(Response response, String hostname, List<InetAddress> results, List<Exception> failures) {
        List<Serializable> list;
        try {
            List<InetAddress> addresses = this.readResponse((String)((Object)list), response);
            list = results;
            synchronized (list) {
                void var3_6;
                var3_6.addAll((Collection)addresses);
                return;
            }
        }
        catch (Exception e) {
            list = failures;
            synchronized (list) {
                void var1_3;
                failures.add((Exception)var1_3);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InetAddress> throwBestFailure(String hostname, List<? extends Exception> failures) throws UnknownHostException {
        void var1_1;
        if (failures.isEmpty()) {
            throw new UnknownHostException(hostname);
        }
        Exception failure = failures.get(0);
        if (failure instanceof UnknownHostException) {
            throw failure;
        }
        UnknownHostException unknownHostException = new UnknownHostException(hostname);
        unknownHostException.initCause(failure);
        int n = failures.size();
        for (int i = 1; i < n; ++i) {
            ExceptionsKt.addSuppressed((Throwable)unknownHostException, (Throwable)failures.get(i));
        }
        throw var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final Response getCacheOnlyResponse(Request request) {
        if (this.client.cache() != null) {
            try {
                void var3_3;
                void var2_2;
                CacheControl onlyIfCached = new CacheControl.Builder().onlyIfCached().build();
                HttpUrl cacheUrl = request.url();
                Request cacheRequest = request.newBuilder().cacheControl((CacheControl)var2_2).cacheUrlOverride((HttpUrl)var3_3).build();
                Response cacheResponse = this.client.newCall(cacheRequest).execute();
                if (cacheResponse.code() != 504) {
                    void var1_1;
                    return var1_1;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InetAddress> readResponse(String hostname, Response response) throws Exception {
        Object object;
        if (response.cacheResponse() == null && response.protocol() != Protocol.HTTP_2) {
            Platform.log$default((Platform)Platform.Companion.get(), (String)("Incorrect protocol: " + response.protocol()), (int)5, null, (int)4, null);
        }
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            void var2_3;
            Response cfr_ignored_0 = (Response)closeable;
            if (!response.isSuccessful()) {
                throw new IOException("response: " + response.code() + ' ' + response.message());
            }
            ResponseBody body = response.body();
            if (body.contentLength() > 65536L) {
                throw new IOException("response size exceeds limit (65536 bytes): " + body.contentLength() + " bytes");
            }
            ByteString responseBytes = body.source().readByteString();
            object = DnsRecordCodec.INSTANCE.decodeAnswers((String)object, (ByteString)var2_3);
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Request buildRequest(String hostname, int type) {
        Request.Builder builder;
        Request.Builder $this$buildRequest_u24lambda_u245 = builder = new Request.Builder().header("Accept", DNS_MESSAGE.toString());
        ByteString query = DnsRecordCodec.INSTANCE.encodeQuery(hostname, type);
        if (this.post) {
            $this$buildRequest_u24lambda_u245.url(this.url).cacheUrlOverride(this.url.newBuilder().addQueryParameter("hostname", hostname).build()).post(RequestBody.Companion.create(query, DNS_MESSAGE));
        } else {
            void var1_1;
            void var2_3;
            String encoded = StringsKt.replace$default((String)var2_3.base64Url(), (String)"=", (String)"", (boolean)false, (int)4, null);
            HttpUrl requestUrl = this.url.newBuilder().addQueryParameter("dns", encoded).build();
            $this$buildRequest_u24lambda_u245.url((HttpUrl)var1_1);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$processResponse(DnsOverHttps $this, Response response, String hostname, List results, List failures) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.processResponse((Response)var1_1, (String)var2_2, (List<InetAddress>)var3_3, failures);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050+\"\u00020\u0005\u00a2\u0006\u0002\u0010,J\u0016\u0010\u0003\u001a\u00020\u00002\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004J\u0006\u0010-\u001a\u00020.J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0011J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Lokhttp3/dnsoverhttps/DnsOverHttps$Builder;", "", "()V", "bootstrapDnsHosts", "", "Ljava/net/InetAddress;", "getBootstrapDnsHosts$okhttp_dnsoverhttps", "()Ljava/util/List;", "setBootstrapDnsHosts$okhttp_dnsoverhttps", "(Ljava/util/List;)V", "client", "Lokhttp3/OkHttpClient;", "getClient$okhttp_dnsoverhttps", "()Lokhttp3/OkHttpClient;", "setClient$okhttp_dnsoverhttps", "(Lokhttp3/OkHttpClient;)V", "includeIPv6", "", "getIncludeIPv6$okhttp_dnsoverhttps", "()Z", "setIncludeIPv6$okhttp_dnsoverhttps", "(Z)V", "post", "getPost$okhttp_dnsoverhttps", "setPost$okhttp_dnsoverhttps", "resolvePrivateAddresses", "getResolvePrivateAddresses$okhttp_dnsoverhttps", "setResolvePrivateAddresses$okhttp_dnsoverhttps", "resolvePublicAddresses", "getResolvePublicAddresses$okhttp_dnsoverhttps", "setResolvePublicAddresses$okhttp_dnsoverhttps", "systemDns", "Lokhttp3/Dns;", "getSystemDns$okhttp_dnsoverhttps", "()Lokhttp3/Dns;", "setSystemDns$okhttp_dnsoverhttps", "(Lokhttp3/Dns;)V", "url", "Lokhttp3/HttpUrl;", "getUrl$okhttp_dnsoverhttps", "()Lokhttp3/HttpUrl;", "setUrl$okhttp_dnsoverhttps", "(Lokhttp3/HttpUrl;)V", "", "([Ljava/net/InetAddress;)Lokhttp3/dnsoverhttps/DnsOverHttps$Builder;", "build", "Lokhttp3/dnsoverhttps/DnsOverHttps;", "okhttp-dnsoverhttps"})
    @SourceDebugExtension(value={"SMAP\nDnsOverHttps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsOverHttps.kt\nokhttp3/dnsoverhttps/DnsOverHttps$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1#2:356\n*E\n"})
    public static final class Builder {
        private OkHttpClient client;
        private HttpUrl url;
        private boolean includeIPv6 = true;
        private boolean post;
        private Dns systemDns = Dns.SYSTEM;
        private List<? extends InetAddress> bootstrapDnsHosts;
        private boolean resolvePrivateAddresses;
        private boolean resolvePublicAddresses = true;

        public final OkHttpClient getClient$okhttp_dnsoverhttps() {
            return this.client;
        }

        /*
         * WARNING - void declaration
         */
        public final void setClient$okhttp_dnsoverhttps(OkHttpClient okHttpClient) {
            void var1_1;
            this.client = var1_1;
        }

        public final HttpUrl getUrl$okhttp_dnsoverhttps() {
            return this.url;
        }

        /*
         * WARNING - void declaration
         */
        public final void setUrl$okhttp_dnsoverhttps(HttpUrl httpUrl) {
            void var1_1;
            this.url = var1_1;
        }

        public final boolean getIncludeIPv6$okhttp_dnsoverhttps() {
            return this.includeIPv6;
        }

        /*
         * WARNING - void declaration
         */
        public final void setIncludeIPv6$okhttp_dnsoverhttps(boolean bl) {
            void var1_1;
            this.includeIPv6 = var1_1;
        }

        public final boolean getPost$okhttp_dnsoverhttps() {
            return this.post;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPost$okhttp_dnsoverhttps(boolean bl) {
            void var1_1;
            this.post = var1_1;
        }

        public final Dns getSystemDns$okhttp_dnsoverhttps() {
            return this.systemDns;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSystemDns$okhttp_dnsoverhttps(Dns dns) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dns, (String)"<set-?>");
            this.systemDns = var1_1;
        }

        public final List<InetAddress> getBootstrapDnsHosts$okhttp_dnsoverhttps() {
            return this.bootstrapDnsHosts;
        }

        /*
         * WARNING - void declaration
         */
        public final void setBootstrapDnsHosts$okhttp_dnsoverhttps(List<? extends InetAddress> list) {
            void var1_1;
            this.bootstrapDnsHosts = var1_1;
        }

        public final boolean getResolvePrivateAddresses$okhttp_dnsoverhttps() {
            return this.resolvePrivateAddresses;
        }

        /*
         * WARNING - void declaration
         */
        public final void setResolvePrivateAddresses$okhttp_dnsoverhttps(boolean bl) {
            void var1_1;
            this.resolvePrivateAddresses = var1_1;
        }

        public final boolean getResolvePublicAddresses$okhttp_dnsoverhttps() {
            return this.resolvePublicAddresses;
        }

        /*
         * WARNING - void declaration
         */
        public final void setResolvePublicAddresses$okhttp_dnsoverhttps(boolean bl) {
            void var1_1;
            this.resolvePublicAddresses = var1_1;
        }

        public final DnsOverHttps build() {
            OkHttpClient okHttpClient = this.client;
            if (okHttpClient == null) {
                throw new NullPointerException("client not set");
            }
            Object object = okHttpClient;
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                object = "url not set";
                throw new IllegalStateException(object.toString());
            }
            boolean bl = this.resolvePublicAddresses;
            boolean bl2 = this.resolvePrivateAddresses;
            boolean bl3 = this.post;
            boolean bl4 = this.includeIPv6;
            HttpUrl httpUrl2 = httpUrl;
            OkHttpClient okHttpClient2 = okHttpClient.newBuilder().dns(okhttp3.dnsoverhttps.DnsOverHttps$Companion.access$buildBootstrapClient(Companion, this)).build();
            return new DnsOverHttps(okHttpClient2, httpUrl2, bl4, bl3, bl2, bl);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder client(OkHttpClient client) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Builder builder2 = builder = this;
            builder.client = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder url(HttpUrl url) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder builder2 = builder = this;
            builder.url = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder includeIPv6(boolean includeIPv6) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.includeIPv6 = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder post(boolean post) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.post = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder resolvePrivateAddresses(boolean resolvePrivateAddresses) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.resolvePrivateAddresses = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder resolvePublicAddresses(boolean resolvePublicAddresses) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.resolvePublicAddresses = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder bootstrapDnsHosts(List<? extends InetAddress> bootstrapDnsHosts) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.bootstrapDnsHosts = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder bootstrapDnsHosts(InetAddress ... bootstrapDnsHosts) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bootstrapDnsHosts, (String)"bootstrapDnsHosts");
            return this.bootstrapDnsHosts(ArraysKt.toList((Object[])var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder systemDns(Dns systemDns) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)systemDns, (String)"systemDns");
            Builder builder2 = builder = this;
            builder.systemDns = var1_1;
            return builder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/dnsoverhttps/DnsOverHttps$Companion;", "", "()V", "DNS_MESSAGE", "Lokhttp3/MediaType;", "getDNS_MESSAGE", "()Lokhttp3/MediaType;", "MAX_RESPONSE_SIZE", "", "buildBootstrapClient", "Lokhttp3/Dns;", "builder", "Lokhttp3/dnsoverhttps/DnsOverHttps$Builder;", "isPrivateHost", "", "host", "", "isPrivateHost$okhttp_dnsoverhttps", "okhttp-dnsoverhttps"})
    public static final class Companion {
        private Companion() {
        }

        public final MediaType getDNS_MESSAGE() {
            return DNS_MESSAGE;
        }

        /*
         * WARNING - void declaration
         */
        private final Dns buildBootstrapClient(Builder builder) {
            void var1_1;
            List<InetAddress> hosts = builder.getBootstrapDnsHosts$okhttp_dnsoverhttps();
            if (hosts != null) {
                void var2_2;
                HttpUrl httpUrl = builder.getUrl$okhttp_dnsoverhttps();
                Intrinsics.checkNotNull((Object)httpUrl);
                return new BootstrapDns(httpUrl.host(), (List<? extends InetAddress>)var2_2);
            }
            return var1_1.getSystemDns$okhttp_dnsoverhttps();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isPrivateHost$okhttp_dnsoverhttps(String host) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne((String)var1_1) == null;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Dns access$buildBootstrapClient(Companion $this, Builder builder) {
            void var1_1;
            return $this.buildBootstrapClient((Builder)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

