/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
class RequestEntityProxy
implements HttpEntity {
    private final HttpEntity original;
    private boolean consumed = false;

    /*
     * WARNING - void declaration
     */
    static void enhance(HttpEntityEnclosingRequest request) {
        HttpEntity entity = request.getEntity();
        if (entity != null && !entity.isRepeatable() && !RequestEntityProxy.isEnhanced(entity)) {
            void var1_1;
            HttpEntityEnclosingRequest httpEntityEnclosingRequest;
            httpEntityEnclosingRequest.setEntity((HttpEntity)new RequestEntityProxy((HttpEntity)var1_1));
        }
    }

    static boolean isEnhanced(HttpEntity entity) {
        return entity instanceof RequestEntityProxy;
    }

    static boolean isRepeatable(HttpRequest request) {
        HttpRequest entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            HttpRequest httpRequest;
            RequestEntityProxy requestEntityProxy;
            if (RequestEntityProxy.isEnhanced((HttpEntity)entity) && !(requestEntityProxy = (RequestEntityProxy)entity).isConsumed()) {
                return true;
            }
            return httpRequest.isRepeatable();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    RequestEntityProxy(HttpEntity original) {
        void var1_1;
        this.original = var1_1;
    }

    public HttpEntity getOriginal() {
        return this.original;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public boolean isRepeatable() {
        return this.original.isRepeatable();
    }

    public boolean isChunked() {
        return this.original.isChunked();
    }

    public long getContentLength() {
        return this.original.getContentLength();
    }

    public Header getContentType() {
        return this.original.getContentType();
    }

    public Header getContentEncoding() {
        return this.original.getContentEncoding();
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.original.getContent();
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(OutputStream outstream) throws IOException {
        void var1_1;
        this.consumed = true;
        this.original.writeTo((OutputStream)var1_1);
    }

    public boolean isStreaming() {
        return this.original.isStreaming();
    }

    @Deprecated
    public void consumeContent() throws IOException {
        this.consumed = true;
        this.original.consumeContent();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("RequestEntityProxy{");
        sb.append(this.original);
        sb.append('}');
        return var1_1.toString();
    }
}

