/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.http.HttpClientConnection;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.HttpClientConnectionManager;

@ThreadSafe
class ConnectionHolder
implements Closeable,
Cancellable,
ConnectionReleaseTrigger {
    private final Log log;
    private final HttpClientConnectionManager manager;
    private final HttpClientConnection managedConn;
    private final AtomicBoolean released;
    private volatile boolean reusable;
    private volatile Object state;
    private volatile long validDuration;
    private volatile TimeUnit tunit;

    /*
     * WARNING - void declaration
     */
    public ConnectionHolder(Log log, HttpClientConnectionManager manager, HttpClientConnection managedConn) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.log = var1_1;
        this.manager = var2_2;
        this.managedConn = var3_3;
        this.released = new AtomicBoolean(false);
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public void markReusable() {
        this.reusable = true;
    }

    public void markNonReusable() {
        this.reusable = false;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(Object state) {
        void var1_1;
        this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setValidFor(long duration, TimeUnit tunit) {
        HttpClientConnection httpClientConnection = this.managedConn;
        synchronized (httpClientConnection) {
            void var3_3;
            void var1_1;
            this.validDuration = var1_1;
            this.tunit = var3_3;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void releaseConnection(boolean reusable) {
        if (this.released.compareAndSet(false, true)) {
            HttpClientConnection httpClientConnection = this.managedConn;
            synchronized (httpClientConnection) {
                if (reusable) {
                    this.manager.releaseConnection(this.managedConn, this.state, this.validDuration, this.tunit);
                } else {
                    try {
                        this.managedConn.close();
                        this.log.debug((Object)"Connection discarded");
                    }
                    catch (IOException ex) {
                        if (this.log.isDebugEnabled()) {
                            void var1_2;
                            this.log.debug((Object)ex.getMessage(), (Throwable)var1_2);
                        }
                    }
                    finally {
                        this.manager.releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
        }
    }

    @Override
    public void releaseConnection() {
        ConnectionHolder connectionHolder = this;
        connectionHolder.releaseConnection(connectionHolder.reusable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void abortConnection() {
        if (this.released.compareAndSet(false, true)) {
            HttpClientConnection httpClientConnection = this.managedConn;
            synchronized (httpClientConnection) {
                try {
                    this.managedConn.shutdown();
                    this.log.debug((Object)"Connection discarded");
                }
                catch (IOException ex) {
                    if (this.log.isDebugEnabled()) {
                        void var2_2;
                        this.log.debug((Object)ex.getMessage(), (Throwable)var2_2);
                    }
                }
                finally {
                    this.manager.releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancel() {
        void var1_1;
        boolean alreadyReleased = this.released.get();
        this.log.debug((Object)"Cancelling request execution");
        this.abortConnection();
        return var1_1 == false;
    }

    public boolean isReleased() {
        return this.released.get();
    }

    @Override
    public void close() throws IOException {
        this.releaseConnection(false);
    }
}

