/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.util.Args;

@Immutable
public class BackoffStrategyExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    /*
     * WARNING - void declaration
     */
    public BackoffStrategyExec(ClientExecChain requestExecutor, ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)requestExecutor, (String)"HTTP client request executor");
        Args.notNull((Object)connectionBackoffStrategy, (String)"Connection backoff strategy");
        Args.notNull((Object)backoffManager, (String)"Backoff manager");
        this.requestExecutor = var1_1;
        this.connectionBackoffStrategy = var2_2;
        this.backoffManager = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        void var2_2;
        Args.notNull((Object)route, (String)"HTTP route");
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)((Object)context), (String)"HTTP context");
        try {
            void var3_4;
            CloseableHttpResponse out = this.requestExecutor.execute(route, request, (HttpClientContext)var3_4, execAware);
        }
        catch (Exception ex) {
            void var2_3;
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                this.backoffManager.backOff(route);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof HttpException) {
                throw (HttpException)((Object)ex);
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new UndeclaredThrowableException((Throwable)var2_3);
        }
        if (this.connectionBackoffStrategy.shouldBackoff((HttpResponse)var2_2)) {
            this.backoffManager.backOff(route);
        } else {
            void var1_1;
            this.backoffManager.probe((HttpRoute)var1_1);
        }
        return var2_2;
    }
}

