/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePriorityComparator;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@ThreadSafe
public class RFC6265CookieSpec
implements CookieSpec {
    private static final char PARAM_DELIMITER = ';';
    private static final char COMMA_CHAR = ',';
    private static final char EQUAL_CHAR = '=';
    private static final char DQUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{61, 59});
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{59});
    private static final BitSet SPECIAL_CHARS = TokenParser.INIT_BITSET((int[])new int[]{32, 34, 44, 59, 92});
    private final CookieAttributeHandler[] attribHandlers;
    private final Map<String, CookieAttributeHandler> attribHandlerMap;
    private final TokenParser tokenParser;

    protected RFC6265CookieSpec(CommonCookieAttributeHandler ... handlers) {
        this.attribHandlers = (CookieAttributeHandler[])handlers.clone();
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(handlers.length);
        CommonCookieAttributeHandler[] arr$ = handlers;
        int len$ = handlers.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CommonCookieAttributeHandler handler = arr$[i$];
            this.attribHandlerMap.put(handler.getAttributeName().toLowerCase(Locale.ROOT), handler);
        }
        this.tokenParser = TokenParser.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static String getDefaultPath(CookieOrigin origin) {
        Object object;
        Object defaultPath = origin.getPath();
        int lastSlashIndex = ((String)defaultPath).lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            void var1_1;
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = ((String)defaultPath).substring(0, (int)var1_1);
        }
        return object;
    }

    static String getDefaultDomain(CookieOrigin origin) {
        return origin.getHost();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        void var1_1;
        ParserCursor cursor;
        CharArrayBuffer buffer;
        Args.notNull((Object)header, (String)"Header");
        Args.notNull((Object)origin, (String)"Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header: '" + header.toString() + "'");
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedCookieException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            cursor = new ParserCursor(0, buffer.length());
        }
        String name = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (name.length() == 0) {
            throw new MalformedCookieException("Cookie name is invalid: '" + header.toString() + "'");
        }
        if (cursor.atEnd()) {
            throw new MalformedCookieException("Cookie value is invalid: '" + header.toString() + "'");
        }
        char valueDelim = buffer.charAt(cursor.getPos());
        ParserCursor parserCursor = cursor;
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (valueDelim != '=') {
            throw new MalformedCookieException("Cookie value is invalid: '" + header.toString() + "'");
        }
        String value = this.tokenParser.parseValue(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            ParserCursor parserCursor2 = cursor;
            parserCursor2.updatePos(parserCursor2.getPos() + 1);
        }
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setPath(RFC6265CookieSpec.getDefaultPath(origin));
        cookie.setDomain(RFC6265CookieSpec.getDefaultDomain(origin));
        cookie.setCreationDate(new Date());
        LinkedHashMap<String, String> attribMap = new LinkedHashMap<String, String>();
        while (!cursor.atEnd()) {
            String paramName = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS).toLowerCase(Locale.ROOT);
            String paramValue = null;
            if (!cursor.atEnd()) {
                char paramDelim = buffer.charAt(cursor.getPos());
                ParserCursor parserCursor3 = cursor;
                parserCursor3.updatePos(parserCursor3.getPos() + 1);
                if (paramDelim == '=') {
                    paramValue = this.tokenParser.parseToken(buffer, cursor, VALUE_DELIMS);
                    if (!cursor.atEnd()) {
                        ParserCursor parserCursor4 = cursor;
                        parserCursor4.updatePos(parserCursor4.getPos() + 1);
                    }
                }
            }
            cookie.setAttribute(paramName, paramValue);
            attribMap.put(paramName, paramValue);
        }
        if (attribMap.containsKey("max-age")) {
            attribMap.remove("expires");
        }
        for (Map.Entry entry : attribMap.entrySet()) {
            void var2_2;
            void var3_3;
            String paramName = (String)entry.getKey();
            String paramValue = (String)entry.getValue();
            CookieAttributeHandler handler = this.attribHandlerMap.get(paramName);
            if (handler == null) continue;
            var3_3.parse(cookie, (String)var2_2);
        }
        return Collections.singletonList(var1_1);
    }

    @Override
    public final void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        CookieAttributeHandler[] arr$ = this.attribHandlers;
        int len$ = this.attribHandlers.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CookieAttributeHandler cookieAttributeHandler = arr$[i$];
            cookieAttributeHandler.validate(cookie, origin);
        }
    }

    @Override
    public final boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        CookieAttributeHandler[] arr$ = this.attribHandlers;
        int len$ = this.attribHandlers.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CookieAttributeHandler cookieAttributeHandler = arr$[i$];
            if (cookieAttributeHandler.match(cookie, origin)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        void var3_4;
        void var2_2;
        ArrayList<Cookie> sortedCookies;
        Args.notEmpty(cookies, (String)"List of cookies");
        if (cookies.size() > 1) {
            sortedCookies = new ArrayList<Cookie>(cookies);
            Collections.sort(sortedCookies, CookiePriorityComparator.INSTANCE);
        }
        CharArrayBuffer buffer = new CharArrayBuffer(20 * sortedCookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int n = 0; n < sortedCookies.size(); ++n) {
            Cookie cookie = (Cookie)sortedCookies.get(n);
            if (n > 0) {
                buffer.append(';');
                buffer.append(' ');
            }
            buffer.append(cookie.getName());
            String s = cookie.getValue();
            if (s == null) continue;
            buffer.append('=');
            if (this.containsSpecialChar(s)) {
                buffer.append('\"');
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch == '\"' || ch == '\\') {
                        buffer.append('\\');
                    }
                    buffer.append(ch);
                }
                buffer.append('\"');
                continue;
            }
            buffer.append(s);
        }
        ArrayList<BufferedHeader> headers = new ArrayList<BufferedHeader>(1);
        headers.add(new BufferedHeader((CharArrayBuffer)var2_2));
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    boolean containsSpecialChar(CharSequence s) {
        void var1_1;
        return this.containsChars((CharSequence)var1_1, SPECIAL_CHARS);
    }

    boolean containsChars(CharSequence s, BitSet chars) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!chars.get(ch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getVersion() {
        return 0;
    }

    @Override
    public final Header getVersionHeader() {
        return null;
    }
}

