/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.StringTokenizer;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.util.Args;

@Immutable
public class RFC2965PortAttributeHandler
implements CommonCookieAttributeHandler {
    /*
     * WARNING - void declaration
     */
    private static int[] parsePortAttribute(String portValue) throws MalformedCookieException {
        void var1_1;
        StringTokenizer st = new StringTokenizer(portValue, ",");
        int[] ports = new int[st.countTokens()];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                ports[i] = Integer.parseInt(st.nextToken().trim());
                if (ports[i] < 0) {
                    throw new MalformedCookieException("Invalid Port attribute.");
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            void var2_3;
            throw new MalformedCookieException("Invalid Port attribute: " + var2_3.getMessage());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean portMatch(int port, int[] ports) {
        void var2_2;
        boolean portInList = false;
        int[] arr$ = ports;
        int len$ = ports.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int port2 = arr$[i$];
            if (port != port2) continue;
            portInList = true;
            break;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(SetCookie cookie, String portValue) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        if (cookie instanceof SetCookie2) {
            SetCookie2 cookie2 = (SetCookie2)cookie;
            if (portValue != null && !portValue.trim().isEmpty()) {
                void var2_2;
                void var1_1;
                int[] ports = RFC2965PortAttributeHandler.parsePortAttribute(portValue);
                var1_1.setPorts((int[])var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        void var1_1;
        void var2_3;
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        int port = origin.getPort();
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("port") && !RFC2965PortAttributeHandler.portMatch((int)var2_3, var1_1.getPorts())) {
            throw new CookieRestrictionViolationException("Port attribute violates RFC 2965: Request port not found in cookie's port list.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        int port = origin.getPort();
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("port")) {
            void var1_1;
            void var2_3;
            if (cookie.getPorts() == null) {
                return false;
            }
            if (!RFC2965PortAttributeHandler.portMatch((int)var2_3, var1_1.getPorts())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        return "port";
    }
}

