/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@Immutable
public class RFC2965DomainAttributeHandler
implements CommonCookieAttributeHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(SetCookie cookie, String domain) throws MalformedCookieException {
        void var1_1;
        void var2_2;
        Args.notNull((Object)cookie, (String)"Cookie");
        if (domain == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (domain.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        String string = domain;
        String s = string.toLowerCase(Locale.ROOT);
        if (!var2_2.startsWith(".")) {
            s = "." + s;
        }
        var1_1.setDomain(string);
    }

    /*
     * WARNING - void declaration
     */
    public boolean domainMatch(String host, String domain) {
        void var2_3;
        void var1_1;
        boolean bl = host.equals(domain) || domain.startsWith(".") && var1_1.endsWith((String)var2_3);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        String host = origin.getHost().toLowerCase(Locale.ROOT);
        if (cookie.getDomain() == null) {
            throw new CookieRestrictionViolationException("Invalid cookie state: domain not specified");
        }
        String cookieDomain = cookie.getDomain().toLowerCase(Locale.ROOT);
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            void var3_3;
            if (!cookieDomain.startsWith(".")) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: domain must start with a dot");
            }
            int dotIndex = cookieDomain.indexOf(46, 1);
            if (!(dotIndex >= 0 && dotIndex != cookieDomain.length() - 1 || cookieDomain.equals(".local"))) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2965: the value contains no embedded dots and the value is not .local");
            }
            if (!this.domainMatch(host, cookieDomain)) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2965: effective host name does not domain-match domain attribute.");
            }
            if ((host = host.substring(0, host.length() - var3_3.length())).indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2965: effective host minus domain may not contain any dots");
            }
            return;
        }
        if (!cookie.getDomain().equals(host)) {
            void var2_2;
            void var1_1;
            throw new CookieRestrictionViolationException("Illegal domain attribute: \"" + var1_1.getDomain() + "\".Domain of origin: \"" + (String)var2_2 + "\"");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        String string;
        void var2_2;
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        String host = origin.getHost().toLowerCase(Locale.ROOT);
        String cookieDomain = cookie.getDomain();
        if (!this.domainMatch(host, cookieDomain)) {
            return false;
        }
        string = host.substring(0, var2_2.length() - string.length());
        return string.indexOf(46) == -1;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

