/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            void var2_3;
            cookie.setVersion(Integer.parseInt((String)var2_3));
            return;
        }
        catch (NumberFormatException e) {
            void var1_2;
            throw new MalformedCookieException("Invalid version: " + var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        void var1_1;
        Args.notNull((Object)cookie, (String)"Cookie");
        if (var1_1.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

